/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.unlock;

import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.data.unlock.UnlockTracker;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public final class UnlockManager {
    private static UnlockManager instance;
    private final Set<class_3222> testForCompletion = new HashSet<class_3222>();

    public static UnlockManager instance() {
        if (instance == null) {
            instance = new UnlockManager();
        }
        return instance;
    }

    private UnlockManager() {
        PlayerEvents.LOGGED_IN.register((IFrameworkEvent)((IPlayerEvent.LoggedIn)this::onPlayerLoggedIn));
        PlayerEvents.RESPAWN.register((IFrameworkEvent)((IPlayerEvent.Respawn)this::onPlayerRespawn));
        PlayerEvents.CHANGE_DIMENSION.register((IFrameworkEvent)((IPlayerEvent.ChangeDimension)this::onPlayerChangedDimension));
        TickEvents.END_SERVER.register((IFrameworkEvent)((ITickEvent.EndServer)this::onServerTick));
        TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)this::onPlayerTick));
    }

    private void onPlayerTick(class_1657 player) {
        if (player.method_37908().method_8608() || player.field_6012 % 20 != 0) {
            return;
        }
        class_1937 world = player.method_37908();
        class_2338 playerPosition = player.method_24515();
        class_1959 biome = (class_1959)world.method_23753(playerPosition).comp_349();
    }

    private void onPlayerLoggedIn(class_1657 player) {
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> {
            Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks()));
            UnlockManager.queuePlayerForCompletionTest((class_3222)player);
        });
    }

    private void onPlayerRespawn(class_1657 player, boolean finishedGame) {
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private void onPlayerChangedDimension(class_1657 player, class_5321<class_1937> oldDimension, class_5321<class_1937> newDimension) {
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private void onServerTick(MinecraftServer server) {
        if (this.testForCompletion.isEmpty()) {
            return;
        }
        for (class_3222 player : this.testForCompletion) {
            UnlockManager.getTracker((class_1657)player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
                if (!unlockTracker.getUnlockedBackpacks().contains(location) && progressTracker.isComplete()) {
                    BackpackManager.instance().unlockBackpack(player, (class_2960)location);
                }
            }));
        }
        this.testForCompletion.clear();
    }

    public static void queuePlayerForCompletionTest(class_3222 player) {
        UnlockManager.instance().testForCompletion.add(player);
    }

    public static Optional<UnlockTracker> getTracker(class_1657 player) {
        return Optional.ofNullable((UnlockTracker)((Object)ModSyncedDataKeys.UNLOCK_TRACKER.getValue((class_1297)player)));
    }

    public static <T> List<T> getTrackers(class_1657 player, Class<T> trackerClass) {
        UnlockTracker tracker = (UnlockTracker)((Object)ModSyncedDataKeys.UNLOCK_TRACKER.getValue((class_1297)player));
        return tracker != null ? tracker.getProgressTrackers(trackerClass) : Collections.emptyList();
    }
}

