/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.ChallengeUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4550;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class MineBlockChallenge
extends Challenge {
    public static final ChallengeSerializer<MineBlockChallenge> SERIALIZER = new ChallengeSerializer(class_2960.method_60655((String)"backpacked", (String)"mine_block"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.MINED_X_OF_X).forGetter(challenge -> challenge.formatter), (App)class_4550.field_45723.optionalFieldOf("block").forGetter(challenge -> challenge.block), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(challenge -> challenge.item), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, MineBlockChallenge::new)));
    private final ProgressFormatter formatter;
    private final Optional<class_4550> block;
    private final Optional<class_2073> item;
    private final int count;

    public MineBlockChallenge(ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item, int count) {
        this.formatter = formatter;
        this.block = block;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.block, this.item);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_4550> block;
        private final Optional<class_2073> item;

        protected Tracker(int maxCount, ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.block = block;
            this.item = item;
        }

        private boolean test(class_2680 state, class_1799 stack, @Nullable class_2487 tag) {
            return ChallengeUtils.testPredicate(this.block, state, tag) && ChallengeUtils.testPredicate(this.item, stack);
        }

        public static void registerEvent() {
            BackpackedEvents.MINED_BLOCK_CAPTURE_TAG.register((state, stack, player) -> {
                if (player.method_37908().method_8608()) {
                    return false;
                }
                return UnlockManager.getTrackers(player, Tracker.class).stream().anyMatch(tracker -> !tracker.isComplete() && tracker.test(state, stack, null));
            });
            BackpackedEvents.MINED_BLOCK.register((state, stack, tag, player) -> {
                if (player.method_37908().method_8608()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (!tracker.isComplete() && tracker.test(state, stack, tag)) {
                        tracker.increment((class_3222)player);
                    }
                });
            });
        }
    }
}

