/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.ChallengeUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5699;

public class InteractWithEntityChallenge
extends Challenge {
    public static final ChallengeSerializer<InteractWithEntityChallenge> SERIALIZER = new ChallengeSerializer(class_2960.method_60655((String)"backpacked", (String)"interact_with_entity"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.USED_X_TIMES).forGetter(challenge -> challenge.formatter), (App)class_2048.field_45746.optionalFieldOf("entity").forGetter(challenge -> challenge.entity), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(challenge -> challenge.item), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, InteractWithEntityChallenge::new)));
    private final ProgressFormatter formatter;
    private final Optional<class_2048> entity;
    private final Optional<class_2073> item;
    private final int count;

    public InteractWithEntityChallenge(ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item, int count) {
        this.formatter = formatter;
        this.entity = entity;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(backpackId, this.count, this.formatter, this.entity, this.item);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final class_2960 backpackId;
        private final Optional<class_2048> entity;
        private final Optional<class_2073> item;

        private Tracker(class_2960 backpackId, int maxCount, ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.backpackId = backpackId;
            this.entity = entity;
            this.item = item;
        }

        private boolean test(class_3222 player, class_1297 entity, class_1799 stack) {
            return ChallengeUtils.testPredicate(this.entity, player, entity) && ChallengeUtils.testPredicate(this.item, stack);
        }

        public static void registerEvent() {
            BackpackedEvents.INTERACTED_WITH_ENTITY_CAPTURE.register((player, stack, entity, consumer) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && tracker.test(player, entity, stack)) {
                    consumer.accept(tracker.backpackId);
                }
            }));
            BackpackedEvents.INTERACTED_WITH_ENTITY.register((player, stack, entity, callbacks) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && callbacks.contains(tracker.backpackId)) {
                    tracker.increment(player);
                }
            }));
        }
    }
}

