/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.ChallengeUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import net.minecraft.class_5699;

public class InteractWithBlockChallenge
extends Challenge {
    public static final ChallengeSerializer<InteractWithBlockChallenge> SERIALIZER = new ChallengeSerializer(class_2960.method_60655((String)"backpacked", (String)"interact_with_block"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.USED_X_TIMES).forGetter(challenge -> challenge.formatter), (App)class_4550.field_45723.optionalFieldOf("block").forGetter(challenge -> challenge.block), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(challenge -> challenge.item), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, InteractWithBlockChallenge::new)));
    private final ProgressFormatter formatter;
    private final Optional<class_4550> block;
    private final Optional<class_2073> item;
    private final int count;

    public InteractWithBlockChallenge(ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item, int count) {
        this.formatter = formatter;
        this.block = block;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.count, this.formatter, this.block, this.item);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_4550> block;
        private final Optional<class_2073> item;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.block = block;
            this.item = item;
        }

        private boolean test(class_2680 state, class_1799 stack) {
            return ChallengeUtils.testPredicate(this.block, state, null) && ChallengeUtils.testPredicate(this.item, stack);
        }

        public static void registerEvent() {
            BackpackedEvents.INTERACTED_WITH_BLOCK_CAPTURE_TAG.register((state, stack, player) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).stream().anyMatch(tracker -> !tracker.isComplete() && tracker.test(state, stack)));
            BackpackedEvents.INTERACTED_WITH_BLOCK.register((state, stack, tag, player) -> UnlockManager.getTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && tracker.test(state, stack)) {
                    tracker.increment(player);
                }
            }));
        }
    }
}

