/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ExploreBiomeChallenge
extends Challenge {
    public static final Codec<List<class_5321<class_1959>>> BIOME_LIST_CODEC = Codec.either((Codec)class_5321.method_39154((class_5321)class_7924.field_41236), (Codec)class_5321.method_39154((class_5321)class_7924.field_41236).listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), keys -> keys.size() == 1 ? Either.left((Object)((class_5321)keys.get(0))) : Either.right((Object)keys)).validate(keys -> keys.isEmpty() ? DataResult.error(() -> "Must specify at least one biome") : DataResult.success((Object)keys));
    public static final ChallengeSerializer<ExploreBiomeChallenge> SERIALIZER = new ChallengeSerializer(class_2960.method_60655((String)"backpacked", (String)"explore_biome"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.EXPLORED_X_OF_X).forGetter(challenge -> challenge.formatter), (App)BIOME_LIST_CODEC.fieldOf("biome").forGetter(challenge -> challenge.biomes)).apply((Applicative)builder, ExploreBiomeChallenge::new)));
    private final ProgressFormatter formatter;
    private final List<class_5321<class_1959>> biomes;

    public ExploreBiomeChallenge(ProgressFormatter formatter, List<class_5321<class_1959>> biomes) {
        this.formatter = formatter;
        this.biomes = biomes;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.formatter, this.biomes);
    }

    public static class Tracker
    implements IProgressTracker {
        private final ProgressFormatter formatter;
        private final ImmutableSet<class_5321<class_1959>> biomes;
        private final Set<class_2960> exploredBiomes = new HashSet<class_2960>();

        private Tracker(ProgressFormatter formatter, List<class_5321<class_1959>> biomes) {
            this.formatter = formatter;
            this.biomes = ImmutableSet.copyOf(biomes);
        }

        private void explore(class_5321<class_1959> biome, class_3222 player) {
            if (this.biomes.contains(biome)) {
                this.exploredBiomes.add(biome.method_29177());
                this.markForCompletionTest(player);
            }
        }

        @Override
        public boolean isComplete() {
            return this.exploredBiomes.size() >= this.biomes.size();
        }

        @Override
        public void read(class_2487 tag) {
            this.exploredBiomes.clear();
            class_2499 list = tag.method_10554("ExploredBiomes", 8);
            list.forEach(nbt -> {
                class_2960 id = class_2960.method_12829((String)nbt.method_10714());
                if (id != null && this.biomes.stream().anyMatch(key -> key.method_29177().equals((Object)id))) {
                    this.exploredBiomes.add(id);
                }
            });
        }

        @Override
        public void write(class_2487 tag) {
            class_2499 list = new class_2499();
            this.exploredBiomes.forEach(location -> list.add((Object)class_2519.method_23256((String)location.toString())));
            tag.method_10566("ExploredBiomes", (class_2520)list);
        }

        @Override
        public class_2561 getDisplayComponent() {
            return this.formatter.formatter().apply(this.exploredBiomes.size(), this.biomes.size());
        }

        public static void registerEvent() {
            BackpackedEvents.EXPLORE_UPDATE.register((key, player) -> {
                if (player.method_37908().method_8608()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (!tracker.isComplete()) {
                        tracker.explore((class_5321<class_1959>)key, (class_3222)player);
                    }
                });
            });
        }
    }
}

