/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.BackpackedCodecs;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CraftItemChallenge
extends Challenge {
    public static final ChallengeSerializer<CraftItemChallenge> SERIALIZER = new ChallengeSerializer(class_2960.method_60655((String)"backpacked", (String)"craft_item"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.CRAFT_X_OF_X).forGetter(challenge -> challenge.formatter), (App)CraftedItemPredicate.CODEC.optionalFieldOf("crafted_item").forGetter(challenge -> challenge.predicate), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, CraftItemChallenge::new)));
    private final ProgressFormatter formatter;
    private final Optional<CraftedItemPredicate> predicate;
    private final int count;

    public CraftItemChallenge(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int count) {
        this.formatter = formatter;
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return new Tracker(this.formatter, this.predicate, this.count);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<CraftedItemPredicate> predicate;

        public Tracker(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int maxCount) {
            super(maxCount, formatter);
            this.predicate = predicate;
        }

        public static void registerEvent() {
            PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)(player, stack, inventory) -> {
                if (player.method_37908().method_8608()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (tracker.isComplete()) {
                        return;
                    }
                    if (tracker.predicate.map(p -> p.test(stack)).orElse(true).booleanValue()) {
                        tracker.increment(stack.method_7947(), (class_3222)player);
                    }
                });
            }));
        }
    }

    public record CraftedItemPredicate(Optional<Set<String>> modIds, Optional<class_6862<class_1792>> tag, Optional<class_6885<class_1792>> items) {
        public static final Codec<CraftedItemPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BackpackedCodecs.STRING_SET.optionalFieldOf("namespace").forGetter(o -> o.modIds), (App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("tag").forGetter(CraftedItemPredicate::tag), (App)BackpackedCodecs.ITEMS.optionalFieldOf("items").forGetter(CraftedItemPredicate::items)).apply((Applicative)builder, CraftedItemPredicate::new));

        public boolean test(class_1799 stack) {
            if (this.modIds.isPresent()) {
                class_2960 key = class_7923.field_41178.method_10221((Object)stack.method_7909());
                if (this.modIds.get().contains(key.method_12836())) {
                    return true;
                }
            }
            if (this.tag.isPresent() && stack.method_31573(this.tag.get())) {
                return true;
            }
            return this.items.isPresent() && this.items.get().method_40241(stack.method_41409());
        }
    }
}

