/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public class ModelMetaLoader
extends class_4080<Map<class_2960, ModelMeta>> {
    private static final String DIRECTORY = "backpacked";
    private static final String EXTENSION = ".backpack";
    private static final class_7654 CONVERTER = new class_7654("backpacked", ".backpack");
    private static final Gson GSON = new GsonBuilder().create();

    protected Map<class_2960, ModelMeta> prepare(class_3300 manager, class_3695 filler) {
        HashMap<class_2960, ModelMeta> map = new HashMap<class_2960, ModelMeta>();
        CONVERTER.method_45113(manager).forEach((location, resource) -> {
            try (BufferedReader reader = resource.method_43039();){
                JsonElement element = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                DataResult result = ModelMeta.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (result.error().isPresent()) {
                    Constants.LOG.error("Failed to parse backpack meta: %s".formatted(location));
                    Constants.LOG.error(((DataResult.Error)result.error().get()).message());
                } else {
                    String raw = location.method_12832();
                    String path = location.method_12832().substring("backpacked/".length(), raw.length() - EXTENSION.length());
                    class_2960 key = class_2960.method_60655((String)location.method_12836(), (String)path);
                    map.put(key, (ModelMeta)result.getOrThrow(JsonParseException::new));
                }
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load backpack meta: %s".formatted(location), (Throwable)e);
            }
        });
        return map;
    }

    protected void apply(Map<class_2960, ModelMeta> map, class_3300 manager, class_3695 filler) {
        ClientRegistry.instance().updateModelMeta(map);
    }
}

