/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class BackpackLoader
extends class_4309 {
    private static final String DIRECTORY = "backpacked";
    private static final Gson GSON = new GsonBuilder().create();
    private final class_7225.class_7874 provider;

    public BackpackLoader(class_7225.class_7874 provider) {
        super(GSON, DIRECTORY);
        this.provider = provider;
    }

    protected class_7225.class_7874 getProvider() {
        return this.provider;
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 filler) {
        HashMap<class_2960, Backpack> backpacks = new HashMap<class_2960, Backpack>();
        map.forEach((location, element) -> {
            String modId;
            if (location.method_12832().contains("/")) {
                Constants.LOG.warn("Ignoring backpack '{}' as it was in a sub-directory", location);
                return;
            }
            JsonObject object = element.getAsJsonObject();
            if (object.has("mod_loaded") && object.get("mod_loaded").isJsonPrimitive() && !Services.REGISTRATION.isModLoaded(modId = object.get("mod_loaded").getAsString())) {
                return;
            }
            class_6903 ops = this.getProvider().method_57093((DynamicOps)JsonOps.INSTANCE);
            Backpack backpack = (Backpack)Backpack.CODEC.parse((DynamicOps)ops, (Object)object).getOrThrow(s -> {
                Constants.LOG.error("An error occurred when parsing the backpack '{}'", location);
                return new JsonParseException(s);
            });
            backpack.setup((class_2960)location);
            backpacks.put((class_2960)location, backpack);
        });
        BackpackManager.instance().updateBackpacks(backpacks);
    }
}

