/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.impl.DummyChallenge;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class Backpack {
    public static final class_9139<class_2540, Backpack> STREAM_CODEC = class_9139.method_56437((buf, backpack) -> {
        backpack.checkSetup();
        buf.method_10812(backpack.id);
        buf.method_52964(backpack.challenge.isPresent());
    }, Backpack::new);
    public static final class_9139<class_2540, List<Backpack>> LIST_STREAM_CODEC = STREAM_CODEC.method_56433(class_9135.method_56374(class_2371::method_37434));
    public static final Codec<Backpack> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Challenge.CODEC.optionalFieldOf("unlock_challenge").forGetter(backpack -> backpack.challenge)).apply((Applicative)builder, Backpack::new));
    private final Optional<Challenge> challenge;
    private class_2960 id;
    private String translationKey;
    private boolean setup = false;

    public Backpack(Optional<Challenge> challenge) {
        this.challenge = challenge;
    }

    public Backpack(class_2540 buf) {
        class_2960 id = buf.method_10810();
        this.setup(id);
        this.challenge = buf.readBoolean() ? Optional.of(DummyChallenge.INSTANCE) : Optional.empty();
    }

    public Optional<Challenge> getChallenge() {
        return this.challenge;
    }

    public class_2960 getId() {
        this.checkSetup();
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isUnlocked(class_1657 player) {
        return UnlockManager.getTracker(player).map(tracker -> tracker.isUnlocked(this.id)).orElse(false) != false || this.challenge.isEmpty() || (Boolean)Config.SERVER.backpack.unlockAllCosmetics.get() != false;
    }

    @Nullable
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return this.challenge.map(c -> c.createProgressTracker(backpackId)).orElse(null);
    }

    public void setup(class_2960 id) {
        if (!this.setup) {
            this.id = id;
            this.translationKey = "backpack.%s.%s".formatted(id.method_12836(), id.method_12832());
            this.setup = true;
        }
    }

    protected void checkSetup() {
        if (!this.setup) {
            throw new RuntimeException("Backpack is not setup");
        }
    }
}

