/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.IMovedAccess;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IEntityEvent;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1263;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1361;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3989;
import net.minecraft.class_5575;

public class WanderingTraderEvents {
    public static final class_2561 WANDERING_BAG_TRANSLATION = class_2561.method_43471((String)"backpack.backpacked.wandering_bag");

    public static void init() {
        EntityEvents.JOIN_LEVEL.register((IFrameworkEvent)((IEntityEvent.JoinLevel)WanderingTraderEvents::onEntityJoinLevel));
        PlayerEvents.START_TRACKING_ENTITY.register((IFrameworkEvent)((IPlayerEvent.StartTrackingEntity)WanderingTraderEvents::onStartTracking));
        TickEvents.START_LIVING_ENTITY.register((IFrameworkEvent)((ITickEvent.StartLivingEntity)WanderingTraderEvents::onTickLivingEntity));
    }

    private static void onEntityJoinLevel(class_1297 entity, class_1937 level, boolean disk) {
        if (!entity.method_37908().method_8608() && entity instanceof class_3989) {
            class_3989 trader = (class_3989)entity;
            if (((Boolean)Config.SERVER.wanderingTrader.enableBackpack.get()).booleanValue()) {
                TraderPickpocketing.get((class_1297)trader).ifPresent(data -> {
                    if (!data.isInitialized()) {
                        boolean equipped = trader.method_37908().field_9229.method_43048(((Integer)Config.SERVER.wanderingTrader.spawnWithBackpackChance.get()).intValue()) == 0;
                        data.setBackpackEquipped(equipped);
                        data.setInitialized();
                    }
                });
                WanderingTraderEvents.patchTraderAiGoals(trader);
            }
        }
    }

    private static void onStartTracking(class_1297 entity, class_1657 player) {
        if (entity.method_5864() != class_1299.field_17713) {
            return;
        }
        class_3989 trader = (class_3989)entity;
        TraderPickpocketing.get((class_1297)trader).ifPresent(data -> {
            if (data.isBackpackEquipped()) {
                Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncVillagerBackpack(entity.method_5628()));
            }
        });
    }

    private static void onTickLivingEntity(class_1309 entity) {
        class_1937 level = entity.method_37908();
        if (level.method_8608() || entity.method_5864() != class_1299.field_17713) {
            return;
        }
        class_3989 trader = (class_3989)entity;
        if (trader.method_20506() > 0) {
            trader.method_20507(trader.method_20506() - 1);
        }
        TraderPickpocketing.get((class_1297)entity).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            Map<class_1657, Long> detectedPlayers = data.getDetectedPlayers();
            List<class_1657> newDetectedPlayers = WanderingTraderEvents.findDetectedPlayers((class_1309)trader);
            newDetectedPlayers.forEach(player -> detectedPlayers.put((class_1657)player, level.method_8510()));
            detectedPlayers.entrySet().removeIf(WanderingTraderEvents.createForgetPlayerPredicate(trader, level));
            data.getDislikedPlayers().entrySet().removeIf(entry -> level.method_8510() - (Long)entry.getValue() > (long)((Integer)Config.SERVER.wanderingTrader.challenge.dislikeCooldown.get()).intValue());
        });
    }

    public static boolean onInteract(class_1297 target, class_1657 player) {
        class_1937 level = target.method_37908();
        if (!level.method_8608() && target instanceof class_3989) {
            class_3989 trader = (class_3989)target;
            if (!((Boolean)Config.SERVER.wanderingTrader.challenge.dislikedPlayersCanTrade.get()).booleanValue() && TraderPickpocketing.get((class_1297)trader).map(data -> data.isBackpackEquipped() && data.isDislikedPlayer(player)).orElse(false).booleanValue()) {
                trader.method_20507(20);
                level.method_43129(null, (class_1297)trader, class_3417.field_15008, class_3419.field_15254, 1.0f, 1.5f);
                return true;
            }
        }
        return false;
    }

    private static List<class_1657> findDetectedPlayers(class_1309 entity) {
        return entity.method_37908().method_18023((class_5575)class_1299.field_6097, entity.method_5829().method_1014(WanderingTraderEvents.getMaxDetectionDistance()), player -> WanderingTraderEvents.isPlayerInLivingEntityVision(entity, player) && WanderingTraderEvents.isPlayerSeenByLivingEntity(entity, player, WanderingTraderEvents.getMaxDetectionDistance()) || !player.method_18276() && WanderingTraderEvents.isPlayerMoving(player));
    }

    private static Predicate<Map.Entry<class_1657, Long>> createForgetPlayerPredicate(class_3989 trader, class_1937 world) {
        return entry -> !((class_1657)entry.getKey()).method_5805() || (double)((class_1657)entry.getKey()).method_5739((class_1297)trader) > WanderingTraderEvents.getMaxDetectionDistance() * 2.0 || world.method_8510() - (Long)entry.getValue() > (long)((Integer)Config.SERVER.wanderingTrader.challenge.timeToForgetPlayer.get()).intValue() && (double)((class_1657)entry.getKey()).method_5739((class_1297)trader) >= (Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get();
    }

    private static boolean isPlayerInLivingEntityVision(class_1309 entity, class_1657 player) {
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        class_243 between = entity.method_19538().method_1020(player.method_19538());
        float angle = (float)Math.toDegrees(class_3532.method_15349((double)between.field_1350, (double)between.field_1352)) - 90.0f;
        return class_3532.method_15356((float)(entity.field_6241 + 180.0f), (float)angle) <= 90.0f;
    }

    private static boolean isPlayerSeenByLivingEntity(class_1309 entity, class_1657 player, double distance) {
        class_243 playerEyePos;
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        if (entity.method_37908() != player.method_37908() || (double)entity.method_5739((class_1297)player) > distance) {
            return false;
        }
        class_243 livingEyePos = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321());
        if (WanderingTraderEvents.performRayTrace(livingEyePos, playerEyePos = new class_243(player.method_23317(), player.method_23320(), player.method_23321()), (class_1297)entity).method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        class_243 playerLegPos = new class_243(player.method_23317(), player.method_23318() + 0.5, player.method_23321());
        return WanderingTraderEvents.performRayTrace(livingEyePos, playerLegPos, (class_1297)entity).method_17783() == class_239.class_240.field_1333;
    }

    private static boolean isPlayerInvisible(class_1657 player) {
        return player.method_6059(class_1294.field_5905) && player.method_18396() <= 0.0f && StreamSupport.stream(player.method_5877().spliterator(), false).allMatch(class_1799::method_7960) && Services.BACKPACK.getBackpackStack(player).method_7960();
    }

    private static class_3965 performRayTrace(class_243 start, class_243 end, class_1297 source) {
        return source.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, source));
    }

    private static boolean isPlayerMoving(class_1657 player) {
        return ((IMovedAccess)player).backpacked$Moved();
    }

    public static void openBackpack(class_3989 trader, class_3222 openingPlayer) {
        TraderPickpocketing.get((class_1297)trader).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (data.getDetectedPlayers().containsKey(openingPlayer)) {
                trader.method_20507(20);
                trader.method_5988().method_19615(openingPlayer.method_5836(1.0f));
                trader.method_37908().method_43129(null, (class_1297)trader, class_3417.field_15008, class_3419.field_15254, 1.0f, 1.5f);
                trader.method_37908().method_18023((class_5575)class_1299.field_17714, trader.method_5829().method_1014(((Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get()).doubleValue()), entity -> true).forEach(llama -> llama.method_5980((class_1309)openingPlayer));
                ((class_3218)trader.method_37908()).method_14199((class_2394)class_2398.field_11231, trader.method_23317(), trader.method_23320(), trader.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                data.addDislikedPlayer((class_1657)openingPlayer, trader.method_37908().method_8510());
                return;
            }
            if (WanderingTraderEvents.generateBackpackLoot(trader, data)) {
                // empty if block
            }
            Services.BACKPACK.openBackpackScreen(openingPlayer, (class_1263)trader.method_35199(), 8, 1, false, WANDERING_BAG_TRANSLATION);
            openingPlayer.method_37908().method_43128((class_1657)openingPlayer, trader.method_23317(), trader.method_23318() + 1.0, trader.method_23321(), (class_3414)class_3417.field_14581.comp_349(), class_3419.field_15248, 0.15f, 1.0f);
        });
    }

    private static boolean generateBackpackLoot(class_3989 trader, TraderPickpocketing data) {
        if (!data.isLootSpawned()) {
            int size = trader.method_35199().method_5439();
            int reserved = size / 4;
            int count = trader.method_37908().field_9229.method_43048(Math.max(reserved, 1)) + (size - reserved);
            List randomSlotIndexes = IntStream.range(0, size).boxed().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(randomSlotIndexes);
            class_1916 offers = trader.method_8264();
            for (int i = 0; i < size; ++i) {
                if (!((Boolean)Config.SERVER.wanderingTrader.challenge.generateEmeraldsOnly.get()).booleanValue() && i < count) {
                    class_1914 offer = (class_1914)offers.get(trader.method_37908().field_9229.method_43048(offers.size()));
                    class_1799 loot = offer.method_8250().method_7972();
                    loot.method_7939(class_3532.method_15340((int)(loot.method_7947() * (trader.method_37908().field_9229.method_43048(((Integer)Config.SERVER.wanderingTrader.challenge.maxLootMultiplier.get()).intValue()) + 1)), (int)0, (int)loot.method_7914()));
                    trader.method_35199().method_5447(((Integer)randomSlotIndexes.get(i)).intValue(), loot);
                    continue;
                }
                class_1799 stack = new class_1799((class_1935)class_1802.field_8687, trader.method_37908().field_9229.method_43048(((Integer)Config.SERVER.wanderingTrader.challenge.maxEmeraldStack.get()).intValue()) + 1);
                trader.method_35199().method_5447(((Integer)randomSlotIndexes.get(i)).intValue(), stack);
            }
            data.setLootSpawned();
            return true;
        }
        return false;
    }

    private static void patchTraderAiGoals(class_3989 trader) {
        class_1355 selector = Services.ENTITY.getGoalSelector((class_1308)trader);
        trader.method_47825(goal -> goal instanceof class_1361);
        selector.method_6277(2, (class_1352)new LootAtDetectedPlayerGoal(trader));
        selector.method_6277(9, (class_1352)new PickpocketLookAtPlayerGoal((class_1308)trader, class_1657.class, 3.0f, 1.0f));
    }

    private static double getMaxDetectionDistance() {
        return (Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get();
    }

    private static class LootAtDetectedPlayerGoal
    extends class_1361 {
        private final class_3989 trader;

        public LootAtDetectedPlayerGoal(class_3989 trader) {
            super((class_1308)trader, class_1657.class, ((Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get()).floatValue() * 2.0f, 1.0f);
            this.trader = trader;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            super.method_6264();
            if (this.trader.method_6065() == null && this.field_6484 instanceof class_1657) {
                TraderPickpocketing data = TraderPickpocketing.get((class_1297)this.trader).orElse(null);
                return data != null && data.isBackpackEquipped() && data.getDetectedPlayers().containsKey((class_1657)this.field_6484);
            }
            return false;
        }

        public boolean method_6266() {
            if (this.field_6484 instanceof class_1657 && (double)this.field_6484.method_5739((class_1297)this.trader) <= (double)((Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get()).floatValue() * 2.0) {
                TraderPickpocketing data = TraderPickpocketing.get((class_1297)this.trader).orElse(null);
                return data != null && data.getDetectedPlayers().containsKey((class_1657)this.field_6484);
            }
            return false;
        }

        public void method_6269() {
            class_1937 class_19372 = this.trader.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_19372 = this.field_6484;
                if (class_19372 instanceof class_1657) {
                    class_1657 player = (class_1657)class_19372;
                    if (TraderPickpocketing.get((class_1297)this.trader).map(data -> data.isDislikedPlayer(player)).orElse(false).booleanValue()) {
                        serverLevel.method_14199((class_2394)class_2398.field_11231, this.trader.method_23317(), this.trader.method_23320(), this.trader.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                        serverLevel.method_43129(null, (class_1297)this.trader, class_3417.field_15008, class_3419.field_15254, 1.0f, 1.5f);
                    }
                }
            }
        }

        public void method_6268() {
            if (this.field_6484 instanceof class_1657 && WanderingTraderEvents.isPlayerSeenByLivingEntity((class_1309)this.trader, (class_1657)this.field_6484, (Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get() * 2.0)) {
                this.trader.method_5988().method_20248(this.field_6484.method_23317(), this.field_6484.method_23320(), this.field_6484.method_23321());
            }
        }
    }

    private static class PickpocketLookAtPlayerGoal
    extends class_1361 {
        public PickpocketLookAtPlayerGoal(class_1308 entity, Class<? extends class_1309> entityClass, float distance, float probability) {
            super(entity, entityClass, distance, probability);
        }

        public boolean method_6264() {
            if (TraderPickpocketing.get((class_1297)this.field_6486).map(TraderPickpocketing::isBackpackEquipped).orElse(false).booleanValue()) {
                return false;
            }
            return super.method_6264();
        }
    }
}

