/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.backpack.value.source;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.value.source.BaseSource;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public record WaveformSource(Waveform waveform, double wavelength, double amplitude, double phase) implements BaseSource
{
    public static final BaseSource.Type TYPE = new BaseSource.Type(class_2960.method_60655((String)"backpacked", (String)"waveform"), (MapCodec<? extends BaseSource>)RecordCodecBuilder.mapCodec(builder -> builder.group((App)Waveform.CODEC.fieldOf("waveform").forGetter(o -> o.waveform), (App)Codec.DOUBLE.fieldOf("wavelength").orElse((Object)2.0).forGetter(o -> o.wavelength), (App)Codec.DOUBLE.fieldOf("amplitude").orElse((Object)1.0).forGetter(o -> o.amplitude), (App)Codec.DOUBLE.fieldOf("phase").orElse((Object)0.0).forGetter(o -> o.phase)).apply((Applicative)builder, WaveformSource::new)));

    @Override
    public BaseSource.Type type() {
        return TYPE;
    }

    @Override
    public double apply(BackpackRenderContext context) {
        double time = (float)context.animationTick() + context.partialTick();
        return this.waveform.function.apply(time, this.wavelength, this.amplitude, this.phase);
    }

    public static enum Waveform implements class_3542
    {
        SINE("sine", (time, wavelength, amplitude, phase) -> amplitude * (double)class_3532.method_15374((float)((float)((6.2831854820251465 * time - phase) / wavelength)))),
        SQUARE("square", (time, wavelength, amplitude, phase) -> class_3532.method_15367((double)(time - phase), (double)wavelength) < wavelength / 2.0 ? amplitude : -amplitude),
        TRIANGLE("triangle", (time, wavelength, amplitude, phase) -> 2.0 * amplitude / 3.1415927410125732 * Math.asin(class_3532.method_15374((float)((float)((6.2831854820251465 * time - phase) / wavelength))))),
        SAWTOOTH("sawtooth", (time, wavelength, amplitude, phase) -> 2.0 * amplitude / 3.1415927410125732 * Math.atan(Math.tan((float)((6.2831854820251465 * time - phase) / (2.0 * wavelength)))));

        public static final class_3542.class_7292<Waveform> CODEC;
        private final String name;
        private final WaveformFunction function;

        private Waveform(String name, WaveformFunction function) {
            this.name = name;
            this.function = function;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Waveform::values);
        }
    }

    @FunctionalInterface
    public static interface WaveformFunction {
        public double apply(double var1, double var3, double var5, double var7);
    }
}

