/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CheckBox;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.BackpackProperties;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1087;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_811;
import net.minecraft.class_9331;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CustomiseBackpackScreen
extends class_437 {
    public static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"backpacked", (String)"textures/gui/customise_backpack.png");
    private static final class_2561 SHOW_EFFECTS_TOOLTIP = class_2561.method_43471((String)"backpacked.button.show_effects.tooltip");
    private static final class_2561 SHOW_WITH_ELYTRA_TOOLTIP = class_2561.method_43471((String)"backpacked.button.show_with_elytra.tooltip");
    private static final class_2561 SHOW_ENCHANTMENT_GLINT = class_2561.method_43471((String)"backpacked.button.show_enchantment_glint.tooltip");
    private static final class_2561 LOCKED = class_2561.method_43471((String)"backpacked.gui.locked").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private final class_1799 displayStack = new class_1799((class_1935)ModItems.BACKPACK.get());
    private final int windowWidth;
    private final int windowHeight;
    private int windowLeft;
    private int windowTop;
    private float windowRotationX = 35.0f;
    private float windowRotationY = 10.0f;
    private boolean windowGrabbed;
    private boolean scrollGrabbed;
    private int mouseClickedX;
    private int mouseClickedY;
    private class_4185 resetButton;
    private class_4185 saveButton;
    private CheckBox showEnchantmentGlintButton;
    private CheckBox showWithElytraButton;
    private CheckBox showEffectsButton;
    private BackpackProperties displayBackpack = null;
    private final List<BackpackModelEntry> models;
    private int scroll;

    public CustomiseBackpackScreen(Map<class_2960, class_2561> progressMap) {
        super((class_2561)class_2561.method_43471((String)"backpacked.title.customise_backpack"));
        this.windowWidth = 201;
        this.windowHeight = 166;
        Comparator<BackpackModelEntry> compareUnlock = Comparator.comparing(e -> !e.backpack.isUnlocked((class_1657)class_310.method_1551().field_1724));
        Comparator<BackpackModelEntry> compareLabel = Comparator.comparing(e -> e.label.getString());
        List models = ClientRegistry.instance().getBackpacks().stream().map(backpack -> new BackpackModelEntry((ClientBackpack)backpack, progressMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toList());
        this.models = ImmutableList.copyOf(models);
    }

    protected void method_25426() {
        super.method_25426();
        if (this.displayBackpack == null) {
            this.displayBackpack = this.getCurrentBackpackProperties();
        }
        this.windowLeft = (this.field_22789 - this.windowWidth) / 2;
        this.windowTop = (this.field_22790 - this.windowHeight) / 2;
        this.resetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"backpacked.button.reset"), onPress -> {
            this.displayBackpack = this.displayBackpack.setModel(BackpackManager.getDefaultOrFallbackCosmetic());
        }).method_46433(this.windowLeft + 7, this.windowTop + 114).method_46437(71, 20).method_46431());
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"backpacked.button.save"), onPress -> Network.getPlay().sendToServer((Object)new MessageBackpackCosmetics(this.displayBackpack))).method_46433(this.windowLeft + 7, this.windowTop + 137).method_46437(71, 20).method_46431());
        this.showEnchantmentGlintButton = (CheckBox)this.method_37063((class_364)new CheckBox(this.windowLeft + 133, this.windowTop + 6, class_5244.field_39003, onPress -> {
            this.displayBackpack = this.displayBackpack.setShowEnchantmentGlint(!this.displayBackpack.showEnchantmentGlint());
        }));
        this.showEnchantmentGlintButton.method_47400(class_7919.method_47407((class_2561)SHOW_ENCHANTMENT_GLINT));
        this.showWithElytraButton = (CheckBox)this.method_37063((class_364)new CheckBox(this.windowLeft + 160, this.windowTop + 6, class_5244.field_39003, onPress -> {
            this.displayBackpack = this.displayBackpack.setShowWithElytra(!this.displayBackpack.showWithElytra());
        }));
        this.showWithElytraButton.method_47400(class_7919.method_47407((class_2561)SHOW_WITH_ELYTRA_TOOLTIP));
        this.showEffectsButton = (CheckBox)this.method_37063((class_364)new CheckBox(this.windowLeft + 186, this.windowTop + 6, class_5244.field_39003, onPress -> {
            this.displayBackpack = this.displayBackpack.setShowEffects(!this.displayBackpack.showEffects());
        }));
        this.showEffectsButton.method_47400(class_7919.method_47407((class_2561)SHOW_EFFECTS_TOOLTIP));
        class_1799 backpack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!backpack.method_7960()) {
            this.showEnchantmentGlintButton.setChecked(this.displayBackpack.showEnchantmentGlint());
            this.showWithElytraButton.setChecked(this.displayBackpack.showWithElytra());
            this.showEffectsButton.setChecked(this.displayBackpack.showEffects());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.resetButton.field_22763 = !this.displayBackpack.model().equals((Object)BackpackManager.getDefaultCosmetic());
        this.saveButton.field_22763 = this.needsToSave();
    }

    private boolean needsToSave() {
        BackpackProperties properties = this.getCurrentBackpackProperties();
        return !this.displayBackpack.equals(properties);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        this.updateButtons();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(graphics, mouseX, mouseY, partialTick);
        graphics.method_25302(GUI_TEXTURE, this.windowLeft, this.windowTop, 0, 0, this.windowWidth, this.windowHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        BackpackModelEntry entry;
        int startIndex;
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_51439(this.field_22793, this.field_22785, this.windowLeft + 8, this.windowTop + 6, 0x404040, false);
        if (this.field_22787.field_1724 != null) {
            graphics.method_44379(this.windowLeft + 8, this.windowTop + 18, this.windowLeft + 77, this.windowTop + 110);
            this.renderPlayer(graphics, this.windowLeft + 42, this.windowTop + this.windowHeight / 2, mouseX, mouseY, (class_1657)this.field_22787.field_1724);
            graphics.method_44380();
        }
        boolean canScroll = this.models.size() > 7;
        int scroll = (canScroll ? this.scroll : 0) + (this.scrollGrabbed ? mouseY - this.mouseClickedY : 0);
        scroll = class_3532.method_15340((int)scroll, (int)0, (int)123);
        graphics.method_25302(GUI_TEXTURE, this.windowLeft + 181, this.windowTop + 18 + scroll, 201 + (!canScroll ? 12 : 0), 0, 12, 15);
        for (int i = startIndex = (int)((double)Math.max(0, this.models.size() - 7) * class_3532.method_15350((double)(((double)scroll + 15.0) / 123.0), (double)0.0, (double)1.0)); i < this.models.size() && i < startIndex + 7; ++i) {
            this.drawBackpackItem(graphics, this.windowLeft + 82, this.windowTop + 17 + (i - startIndex) * 20, mouseX, mouseY, partialTick, this.models.get(i));
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1 && !(entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((class_1657)this.field_22787.field_1724)) {
            graphics.method_51447(this.field_22793, entry.getUnlockTooltip(), mouseX, mouseY);
        }
    }

    private void drawBackpackItem(class_332 graphics, int x, int y, int mouseX, int mouseY, float partialTick, BackpackModelEntry entry) {
        boolean unlocked = entry.getBackpack().isUnlocked((class_1657)this.field_22787.field_1724);
        boolean selected = unlocked && entry.getCosmeticId().equals((Object)this.displayBackpack.model());
        boolean hovered = unlocked && !selected && ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 97, 20);
        int offset = (unlocked ? 0 : 60) + (selected ? 20 : 0) + (hovered ? 40 : 0);
        graphics.method_25302(GUI_TEXTURE, x, y, 0, 166 + offset, 97, 20);
        int color = selected ? 4226832 : (hovered ? 0xFFFF80 : (unlocked ? 6839882 : 5119004));
        graphics.method_51439(this.field_22793, entry.getLabel(), x + 20, y + 6, color, false);
        CustomiseBackpackScreen.drawBackpackInGui(this.field_22787, graphics, this.displayStack, entry.getBackpack(), x + 10, y + 10, partialTick);
    }

    public static void drawBackpackInGui(class_310 mc, class_332 graphics, class_1799 stack, ClientBackpack backpack, int x, int y, float partialTick) {
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416((float)x, (float)y, 150.0f);
        pose.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pose.method_22905(16.0f, 16.0f, 16.0f);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        meta.guiDisplay().ifPresent(transform -> transform.method_23075(false, pose));
        meta.renderer().ifPresentOrElse(renderer -> {
            BackpackRenderContext context = new BackpackRenderContext(pose, (class_4597)graphics.method_51450(), 0xF000F0, stack, backpack, (class_1309)mc.field_1724, partialTick, mc.field_1724.field_6012, model -> {
                mc.method_1480().method_23179(stack, class_811.field_4315, false, pose, (class_4597)graphics.method_51450(), 0xF000F0, class_4608.field_21444, model);
                graphics.method_51452();
            });
            pose.method_22903();
            renderer.forEach(function -> function.apply(context));
            pose.method_22909();
        }, () -> {
            class_1087 model = mc.method_1554().method_4742(backpack.getBaseModel());
            mc.method_1480().method_23179(stack, class_811.field_4315, false, pose, (class_4597)graphics.method_51450(), 0xF000F0, class_4608.field_21444, model);
            graphics.method_51452();
        });
        pose.method_22909();
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int displayIndex;
        int startIndex;
        int actualIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140) && (actualIndex = (startIndex = (int)((double)Math.max(0, this.models.size() - 7) * class_3532.method_15350((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0))) + (displayIndex = (mouseY - this.windowTop - 17) / 20)) >= 0 && actualIndex < this.models.size()) {
            return actualIndex;
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140)) {
            BackpackModelEntry entry;
            int hoveredIndex;
            if (button == 0 && (hoveredIndex = this.getHoveredIndex((int)mouseX, (int)mouseY)) != -1 && (entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((class_1657)this.field_22787.field_1724)) {
                this.displayBackpack = this.displayBackpack.setModel(entry.getCosmeticId());
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 8, this.windowTop + 18, 69, 92)) {
            if (!this.windowGrabbed && button == 0) {
                this.windowGrabbed = true;
                this.mouseClickedX = (int)mouseX;
                this.mouseClickedY = (int)mouseY;
                return true;
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 181, this.windowTop + 18 + this.scroll, 12, 15) && !this.scrollGrabbed && button == 0) {
            this.scrollGrabbed = true;
            this.mouseClickedY = (int)mouseY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.windowGrabbed && button == 0) {
            this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
            this.windowRotationY = (float)((double)this.windowRotationY + (mouseY - (double)this.mouseClickedY));
            this.windowGrabbed = false;
        }
        if (this.scrollGrabbed && button == 0) {
            this.scroll = (int)((double)this.scroll + (mouseY - (double)this.mouseClickedY));
            this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)123);
            this.scrollGrabbed = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 112, 140)) {
            int startIndex = (int)((double)Math.max(0, this.models.size() - 7) * class_3532.method_15350((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0));
            int newIndex = startIndex - (int)Math.signum(deltaY);
            this.scrollToIndex(newIndex);
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void scrollToIndex(int index) {
        this.scroll = (int)(123.0 * ((double)index / (double)Math.max(this.models.size() - 7, 1)));
        this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)123);
    }

    private BackpackProperties getCurrentBackpackProperties() {
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        return this.getBackpackProperties(stack);
    }

    private BackpackProperties getBackpackProperties(class_1799 stack) {
        return (BackpackProperties)stack.method_57825((class_9331)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)BackpackProperties.DEFAULT);
    }

    private void setLocalBackpackProperties(BackpackProperties properties) {
        class_1799 stack = Services.BACKPACK.getBackpackStack((class_1657)this.field_22787.field_1724);
        if (!stack.method_7960()) {
            stack.method_57379((class_9331)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)properties);
        }
    }

    private void renderPlayer(class_332 graphics, int x, int y, int mouseX, int mouseY, class_1657 player) {
        Quaternionf playerRotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraRotation = new Quaternionf();
        cameraRotation.mul((Quaternionfc)class_7833.field_40713.rotationDegrees(this.windowRotationY + (float)(this.windowGrabbed ? mouseY - this.mouseClickedY : 0)));
        cameraRotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(this.windowRotationX + (float)(this.windowGrabbed ? mouseX - this.mouseClickedX : 0)));
        playerRotation.mul((Quaternionfc)cameraRotation);
        float origBodyRot = player.field_6283;
        float origBodyRotOld = player.field_6220;
        float origYaw = player.method_36454();
        float origYawOld = player.field_5982;
        float origPitch = player.method_36455();
        float origPitchOld = player.field_6004;
        float origHeadYaw = player.field_6241;
        float origHeadYawOld = player.field_6259;
        player.field_6283 = 0.0f;
        player.field_6220 = 0.0f;
        player.method_36456(0.0f);
        player.field_5982 = 0.0f;
        player.method_36457(15.0f);
        player.field_6004 = 15.0f;
        player.field_6241 = player.method_36454();
        player.field_6259 = player.method_36454();
        BackpackProperties originalProperties = this.getCurrentBackpackProperties();
        this.setLocalBackpackProperties(this.displayBackpack);
        float entityScale = player.method_55693();
        float renderScale = 70.0f / entityScale;
        Vector3f box = new Vector3f(0.0f, player.method_17682() / 2.0f + entityScale * 0.0625f, 0.0f);
        class_490.method_48472((class_332)graphics, (float)x, (float)y, (float)renderScale, (Vector3f)box, (Quaternionf)playerRotation, (Quaternionf)cameraRotation, (class_1309)player);
        this.setLocalBackpackProperties(originalProperties);
        player.field_6283 = origBodyRot;
        player.field_6220 = origBodyRotOld;
        player.method_36456(origYaw);
        player.field_5982 = origYawOld;
        player.method_36457(origPitch);
        player.field_6004 = origPitchOld;
        player.field_6241 = origHeadYaw;
        player.field_6259 = origHeadYawOld;
        this.setLocalBackpackProperties(originalProperties);
    }

    private static class BackpackModelEntry {
        private final class_2960 cosmeticId;
        private final ClientBackpack backpack;
        private final class_2561 label;
        private final List<class_5481> unlockTooltip;

        public BackpackModelEntry(ClientBackpack backpack, Map<class_2960, class_2561> progressMap) {
            this.cosmeticId = backpack.getId();
            this.backpack = backpack;
            this.label = class_2561.method_43471((String)backpack.getTranslationKey());
            class_5250 unlockMessage = class_2561.method_43471((String)(backpack.getTranslationKey() + ".unlock"));
            ArrayList<class_5481> list = new ArrayList<class_5481>(class_310.method_1551().field_1772.method_1728((class_5348)unlockMessage, 150));
            list.add(0, class_2477.method_10517().method_30934((class_5348)LOCKED));
            if (progressMap.containsKey(backpack.getId())) {
                class_5250 component = progressMap.get(backpack.getId()).method_27662().method_27692(class_124.field_1054);
                list.add(class_2477.method_10517().method_30934((class_5348)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
        }

        public class_2960 getCosmeticId() {
            return this.cosmeticId;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        public List<class_5481> getUnlockTooltip() {
            return this.unlockTooltip;
        }

        public ClientBackpack getBackpack() {
            return this.backpack;
        }
    }
}

