/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ClientRegistry {
    private static ClientRegistry instance;
    private Map<class_2960, ClientBackpack> backpacks = new HashMap<class_2960, ClientBackpack>();
    private Map<class_2960, ModelMeta> modelMetaMap = new HashMap<class_2960, ModelMeta>();

    public static ClientRegistry instance() {
        if (instance == null) {
            instance = new ClientRegistry();
        }
        return instance;
    }

    public void updateBackpacks(List<Backpack> backpacks) {
        this.backpacks.clear();
        backpacks.forEach(backpack -> this.backpacks.put(backpack.getId(), new ClientBackpack((Backpack)backpack)));
    }

    @Nullable
    public ClientBackpack getBackpack(class_2960 id) {
        return this.backpacks.get(id);
    }

    @Nullable
    public ClientBackpack getBackpackOrDefault(class_2960 id) {
        ClientBackpack backpack = this.backpacks.get(id);
        if (backpack != null) {
            return backpack;
        }
        return this.backpacks.get(BackpackManager.getDefaultOrFallbackCosmetic());
    }

    public List<ClientBackpack> getBackpacks() {
        return ImmutableList.copyOf(this.backpacks.values());
    }

    public void updateModelMeta(Map<class_2960, ModelMeta> map) {
        this.modelMetaMap = map;
    }

    public ModelMeta getModelMeta(Backpack backpack) {
        return this.modelMetaMap.getOrDefault(backpack.getId(), ModelMeta.DEFAULT);
    }
}

