/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.blockentity.IOptionalStorage;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.BlockEntityUtil;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends class_2586
implements IOptionalStorage {
    private class_1799 backpack = class_1799.field_8037;
    private class_1277 inventory = null;

    public ShelfBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ShelfBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.SHELF.get(), pos, state);
    }

    @Override
    @Nullable
    public class_1277 getInventory() {
        return this.inventory;
    }

    public class_1799 getBackpackWithContents() {
        class_1799 stack = this.backpack.method_7972();
        if (!stack.method_7960()) {
            this.copyInventoryToStack(stack);
        }
        return stack;
    }

    public class_1269 interact(class_1657 player) {
        if (player.method_18276()) {
            if (!this.shelveBackpack(player)) {
                return class_1269.field_5814;
            }
        } else if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.openBackpackInventory(serverPlayer);
        }
        return class_1269.field_5812;
    }

    private boolean shelveBackpack(class_1657 player) {
        Optional<class_1799> optional = Services.BACKPACK.getStackInBackpackSlot(player);
        if (optional.isEmpty()) {
            return false;
        }
        class_1799 stack = optional.get();
        if (stack.method_7909() instanceof BackpackItem || stack.method_7960() && !this.backpack.method_7960()) {
            class_1799 shelvedBackpack = this.backpack.method_7972();
            this.copyInventoryToStack(shelvedBackpack);
            this.backpack = stack.method_7972();
            Services.BACKPACK.setBackpackStack(player, shelvedBackpack);
            boolean removed = this.backpack.method_7960();
            float soundPitch = removed ? 0.75f : 1.0f;
            this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.ITEM_BACKPACK_PLACE.get(), class_3419.field_15245, 1.0f, soundPitch);
            this.updateInventory(false);
            BlockEntityUtil.sendUpdatePacket(this);
            this.method_5431();
            return true;
        }
        if (!stack.method_7960()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.backpacked.occupied_back_slot"), true);
            return false;
        }
        return true;
    }

    private void openBackpackInventory(class_3222 player) {
        this.getBackpackInventory().ifPresent(inventory -> this.getBackpackItem().ifPresent(backpackItem -> {
            class_2561 title = this.backpack.method_57826(class_9334.field_49631) ? this.backpack.method_7964() : BackpackItem.BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            Services.BACKPACK.openBackpackScreen(player, (class_1263)inventory, cols, rows, false, title);
        }));
    }

    private void copyInventoryToStack(class_1799 stack) {
        if (!stack.method_7960()) {
            this.getBackpackInventory().ifPresent(inventory -> stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)inventory.method_54454())));
        }
    }

    private Optional<class_1277> getBackpackInventory() {
        if (this.backpack.method_7960()) {
            return Optional.empty();
        }
        if (this.inventory != null && this.inventory.method_5439() != this.getBackpackSize()) {
            this.updateInventory(true);
        }
        return Optional.ofNullable(this.inventory);
    }

    private void updateInventory(boolean resized) {
        if (!this.backpack.method_7960()) {
            class_1277 oldInventory = this.inventory;
            this.inventory = new ShelfContainer(this.getBackpackSize());
            class_9288 contents = (class_9288)this.backpack.method_57825(class_9334.field_49622, (Object)class_9288.field_49334);
            contents.method_57492(this.inventory.method_54454());
            this.backpack.method_57381(class_9334.field_49622);
            if (resized && oldInventory != null) {
                InventoryHelper.mergeInventory(oldInventory, this.inventory, this.field_11863, class_243.method_24953((class_2382)this.field_11867));
            }
        } else {
            this.inventory = null;
        }
    }

    private void loadBackpackItems(class_7225.class_7874 provider, class_2487 compound) {
        if (compound.method_10573("Items", 9)) {
            InventoryHelper.loadAllItems(provider, compound.method_10554("Items", 10), this.inventory, this.field_11863, class_243.method_24953((class_2382)this.field_11867));
        }
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.backpack = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)tag.method_10562("Backpack"));
        ShelfContainer shelfContainer = this.inventory = this.backpack.method_7960() ? null : new ShelfContainer(this.getBackpackSize());
        if (this.inventory != null) {
            class_1262.method_5429((class_2487)tag, (class_2371)this.inventory.method_54454(), (class_7225.class_7874)provider);
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566("Backpack", this.backpack.method_57375(provider));
        if (this.inventory != null) {
            class_1262.method_5426((class_2487)tag, (class_2371)this.inventory.method_54454(), (class_7225.class_7874)provider);
        }
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        tag.method_10566("Backpack", this.backpack.method_57375(provider));
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_1799 getBackpack() {
        return this.backpack;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)ShelfBlock.field_11177);
    }

    private Optional<BackpackItem> getBackpackItem() {
        if (this.backpack.method_7909() instanceof BackpackItem) {
            return Optional.of((BackpackItem)this.backpack.method_7909());
        }
        return Optional.empty();
    }

    private int getBackpackSize() {
        return this.getBackpackItem().map(item -> item.getRowCount() * item.getColumnCount()).orElse(0);
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        return !BackpackSlot.isBannedItem(stack);
    }

    public class ShelfContainer
    extends class_1277 {
        public ShelfContainer(int size) {
            super(size);
        }

        public void method_5431() {
            super.method_5431();
            ShelfBlockEntity.this.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return ShelfBlockEntity.this.inventory == this && !ShelfBlockEntity.this.backpack.method_7960() && !ShelfBlockEntity.this.field_11865;
        }
    }
}

