/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.config.ServerConfig;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    private static Map<class_6862<class_1299<?>>, Relation> RELATION_TAG_CACHE = null;
    private static final Map<String, TeamMatcher> TEAM_MATCHERS = new LinkedHashMap<String, TeamMatcher>();

    public static Relation getRelation(class_1657 attacker, class_1297 target) {
        Object tameable;
        class_1309 owner;
        ServerConfig config = BetterCombatMod.config;
        if (attacker == target) {
            return config.player_relation_to_self_and_pets;
        }
        if (target instanceof class_6025 && (owner = (tameable = (class_6025)target).method_35057()) != null) {
            return TargetHelper.getRelation(attacker, (class_1297)owner);
        }
        if (target instanceof class_1530) {
            return Relation.NEUTRAL;
        }
        for (TeamMatcher matcher : TEAM_MATCHERS.values()) {
            TeamRelation relation = matcher.getRelation((class_1297)attacker, target);
            if (relation == null) continue;
            return relation.areTeammates() ? (relation.friendlyFireAllowed() ? config.player_relation_to_teammates : Relation.FRIENDLY) : Relation.HOSTILE;
        }
        class_6880 targetTypeEntry = class_7923.field_41177.method_47983((Object)target.method_5864());
        class_2960 id = ((class_5321)targetTypeEntry.method_40230().get()).method_29177();
        Relation mappedRelation = config.player_relations.get(id.toString());
        if (mappedRelation != null) {
            return mappedRelation;
        }
        for (Map.Entry<class_6862<class_1299<?>>, Relation> entry : TargetHelper.getRelationTagsCache().entrySet()) {
            if (!targetTypeEntry.method_40220(entry.getKey())) continue;
            return entry.getValue();
        }
        if (target instanceof class_1296) {
            return Relation.coalesce(config.player_relation_to_passives, Relation.HOSTILE);
        }
        if (target instanceof class_1588) {
            return Relation.coalesce(config.player_relation_to_hostiles, Relation.HOSTILE);
        }
        return Relation.coalesce(config.player_relation_to_other, Relation.HOSTILE);
    }

    private static Map<class_6862<class_1299<?>>, Relation> getRelationTagsCache() {
        if (RELATION_TAG_CACHE == null) {
            RELATION_TAG_CACHE = new HashMap();
            for (Map.Entry<String, Relation> entrySet : BetterCombatMod.config.player_relation_tags.entrySet()) {
                String tagString = entrySet.getKey();
                Relation relation = entrySet.getValue();
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)tagString));
                RELATION_TAG_CACHE.put(tag, relation);
            }
        }
        return RELATION_TAG_CACHE;
    }

    public static void registerTeamMatcher(String name, TeamMatcher matcher) {
        TEAM_MATCHERS.put(name, matcher);
    }

    public static boolean isAttackableMount(class_1297 entity) {
        if (entity instanceof class_1588 || TargetHelper.isEntityHostileVehicle(entity.method_5477().getString())) {
            return true;
        }
        return BetterCombatMod.config.allow_attacking_mount;
    }

    public static boolean isEntityHostileVehicle(String entityName) {
        ServerConfig config = BetterCombatMod.config;
        return config.hostile_player_vehicles != null && config.hostile_player_vehicles.length > 0 && Arrays.asList(config.hostile_player_vehicles).contains(entityName);
    }

    public static boolean isHitAllowed(boolean isDirect, Relation relation) {
        if (isDirect) {
            return relation != Relation.FRIENDLY;
        }
        return relation == Relation.HOSTILE;
    }

    static {
        TargetHelper.registerTeamMatcher("vanilla", (entity1, entity2) -> {
            class_268 team1 = entity1.method_5781();
            class_268 team2 = entity2.method_5781();
            if (team1 == null || team2 == null) {
                return null;
            }
            boolean friendlyFire = team1.method_1205();
            return new TeamRelation(entity1.method_5722(entity2), friendlyFire);
        });
    }

    public static enum Relation {
        FRIENDLY,
        NEUTRAL,
        HOSTILE;


        public static Relation coalesce(Relation value, Relation fallback) {
            if (value != null) {
                return value;
            }
            return fallback;
        }
    }

    public static interface TeamMatcher {
        @Nullable
        public TeamRelation getRelation(class_1297 var1, class_1297 var2);
    }

    public record TeamRelation(boolean areTeammates, boolean friendlyFireAllowed) {
    }
}

