/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.compat;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.Optional;
import net.bettercombat.Platform;
import net.bettercombat.logic.TargetHelper;
import net.minecraft.class_1657;

public class FTBTeamsCompat {
    public static void init() {
        if (Platform.isModLoaded("ftbteams")) {
            TargetHelper.registerTeamMatcher("ftb", (attack, target) -> {
                if (attack instanceof class_1657) {
                    class_1657 attackerPlayer = (class_1657)attack;
                    if (target instanceof class_1657) {
                        class_1657 targetPlayer = (class_1657)target;
                        if (attackerPlayer.method_37908().method_8608()) {
                            return FTBTeamsCompat.checkClientTeamRelation(attackerPlayer, targetPlayer);
                        }
                        return FTBTeamsCompat.checkServerTeamRelation(attackerPlayer, targetPlayer);
                    }
                }
                return null;
            });
        }
    }

    private static TargetHelper.TeamRelation checkClientTeamRelation(class_1657 attackerPlayer, class_1657 targetPlayer) {
        if (!FTBTeamsAPI.api().isClientManagerLoaded()) {
            return null;
        }
        ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
        Optional attackerKnownPlayerOpt = manager.getKnownPlayer(attackerPlayer.method_5667());
        Optional targetKnownPlayerOpt = manager.getKnownPlayer(targetPlayer.method_5667());
        if (attackerKnownPlayerOpt.isEmpty() || targetKnownPlayerOpt.isEmpty()) {
            return null;
        }
        KnownClientPlayer attackerKnownPlayer = (KnownClientPlayer)attackerKnownPlayerOpt.get();
        KnownClientPlayer targetKnownPlayer = (KnownClientPlayer)targetKnownPlayerOpt.get();
        if (attackerKnownPlayer.teamId().equals(targetKnownPlayer.teamId())) {
            return new TargetHelper.TeamRelation(true, false);
        }
        return null;
    }

    private static TargetHelper.TeamRelation checkServerTeamRelation(class_1657 attackerPlayer, class_1657 targetPlayer) {
        if (!FTBTeamsAPI.api().isManagerLoaded()) {
            return null;
        }
        TeamManager manager = FTBTeamsAPI.api().getManager();
        if (manager.arePlayersInSameTeam(attackerPlayer.method_5667(), targetPlayer.method_5667())) {
            return new TargetHelper.TeamRelation(true, false);
        }
        return null;
    }
}

