/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundCompostItemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockLandPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundStonecutterUsedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundVillagerWorkPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPayload;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1584;
import net.minecraft.class_1646;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_8170;
import org.joml.Vector3f;

public class ClientPacketHandlers {
    private static final List<class_2248> MASON_STONECUTTER_USE_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10552, class_2246.field_10153, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474);
    private static final List<class_1767> COMMON_SHEPHERD_WOOL_COLORS = List.of(class_1767.field_7952, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957);

    public static void handle(class_638 level, ClientBoundEntityFellPayload payload) {
        class_1297 class_12972 = level.method_8469(payload.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, payload.y(), payload.distance(), payload.fallDamage(), ClientPacketHandlers.getEntityFellConfig(payload));
        }
    }

    public static void handle(class_638 level, ClientBoundEntitySpawnSprintingDustCloudsPayload payload) {
        class_1297 class_12972 = level.method_8469(payload.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            int ySpeedModifier = 5;
            if (livingEntity instanceof class_1584) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (class_1937)level, livingEntity.method_59922(), ySpeedModifier);
        }
    }

    public static void handle(class_638 level, ClientBoundSpawnSnoreParticlePayload payload) {
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.method_8406((class_2394)ModParticles.SNORING.get(), payload.x(), payload.y(), payload.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(class_638 level, ClientBoundBlockDestroyEffectsPayload payload) {
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(payload)) {
            class_2338 pos = payload.pos();
            class_2680 state = class_2248.method_9531((int)payload.stateId());
            class_2498 soundType = state.method_26231();
            level.method_31595(pos, state);
            level.method_45446(pos, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundXPBottleEffectsPayload payload) {
        int i;
        class_2338 pos = payload.pos();
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        class_5819 random = level.method_8409();
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA) {
            level.method_20290(2002, pos, class_1844.method_8062((class_6880)class_1847.field_8991));
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ENTITIES.xpBottleParticlesDensity.get(); ++i) {
                double d = random.method_43058() * 4.0;
                double d1 = random.method_43058() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.method_8406((class_2394)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.field_1352 + xPower * 0.1, vec3.field_1351 + 0.3, vec3.field_1350 + zPower * 0.1, xPower, 0.01 + random.method_43058() * 0.5, zPower);
            }
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8436)), vec3.field_1352, vec3.field_1351, vec3.field_1350, random.method_43059() * 0.15, random.method_43058() * 0.2, random.method_43059() * 0.15);
            }
            level.method_45446(pos, class_3417.field_14839, class_3419.field_15254, 1.0f, random.method_43057() * 0.1f + 0.9f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundFallingBlockLandPayload payload) {
        class_2338 pos = payload.pos();
        class_2680 state = class_2248.method_9531((int)payload.stateId());
        class_2248 block = state.method_26204();
        if (ModConfigs.BLOCKS.fallingBlocks.landSound && !(block instanceof class_2199)) {
            class_2498 soundType = state.method_26231();
            Util.playClientSound(pos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        }
        if (ModConfigs.BLOCKS.fallingBlocks.landDust && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)block)) {
            class_5819 random = level.method_8409();
            int color = ClientPacketHandlers.getFallingBlockDustColor(level, block, state, pos);
            class_2390 options = new class_2390(new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f), 1.0f);
            for (int i = 0; i < 25; ++i) {
                boolean b = random.method_43056();
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.method_8406((class_2394)options, (double)pos.method_10263() + 0.5 + (b ? 0.55 * (double)xSign : MathUtil.nextNonAbsDouble(random, 0.55)), (double)pos.method_10264() + MathUtil.nextDouble(random, 0.3), (double)pos.method_10260() + 0.5 + (!b ? 0.55 * (double)zSign : MathUtil.nextNonAbsDouble(random, 0.55)), b ? (double)(50 * xSign) : 0.0, 0.3, !b ? (double)(50 * zSign) : 0.0);
            }
        }
    }

    public static void handle(class_638 level, ClientBoundCompostItemPayload payload) {
        if (ModConfigs.BLOCKS.compostingItemParticles && (!payload.wasFarmer() || ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles)) {
            class_5819 random = level.method_8409();
            ParticleSpawnUtil.spawnCompostParticles((class_1937)level, payload.pos(), (class_2394)new class_2392(class_2398.field_11218, payload.stack()), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
        }
    }

    public static void handle(class_638 level, ClientBoundStonecutterUsedPayload payload) {
        class_2338 pos = payload.pos();
        ParticleSpawnUtil.spawnStonecutterParticles((class_1937)level, payload.stack(), pos, level.method_8320(pos));
    }

    public static void handle(class_638 level, ClientBoundVillagerWorkPayload payload) {
        block13: {
            class_2680 state;
            class_2338 pos;
            class_5819 random;
            int professionLevel;
            class_3852 profession;
            block16: {
                block15: {
                    block14: {
                        if (!ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles) {
                            return;
                        }
                        class_1297 entity = level.method_8469(payload.villagerId());
                        if (!(entity instanceof class_1646)) break block13;
                        class_1646 villager = (class_1646)entity;
                        class_3850 villagerData = villager.method_7231();
                        profession = villagerData.method_16924();
                        professionLevel = villagerData.method_16925();
                        random = level.method_8409();
                        pos = payload.pos();
                        state = level.method_8320(pos);
                        if (profession != class_3852.field_17059) break block14;
                        if (!ModConfigs.BLOCKS.cauldronUseParticles) {
                            return;
                        }
                        double fluidHeight = Util.getCauldronFillHeight(state);
                        class_2394 particle = Util.getCauldronParticle(state);
                        if (!(fluidHeight > 0.0) || particle == null) break block13;
                        for (int i = 0; i < 16; ++i) {
                            level.method_8406(particle, (double)pos.method_10263() + random.method_43058(), (double)pos.method_10264() + fluidHeight, (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
                        }
                        break block13;
                    }
                    if (profession != class_3852.field_17065) break block15;
                    ParticleSpawnUtil.spawnGrindstoneUsedParticles((class_1937)level, pos, state, random);
                    break block13;
                }
                if (profession != class_3852.field_17064) break block16;
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break block13;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (class_1937)level);
                break block13;
            }
            if (profession == class_3852.field_17061) {
                ParticleSpawnUtil.spawnStonecutterParticles((class_1937)level, new class_1799((class_1935)MASON_STONECUTTER_USE_BLOCKS.get(random.method_43048(MASON_STONECUTTER_USE_BLOCKS.size()))), pos, state);
            } else if (profession == class_3852.field_17063) {
                IntegerParticleOptions particle = new IntegerParticleOptions(ModParticles.SHEEP_FLUFF.get(), class_1472.method_6634((class_1767)ClientPacketHandlers.getColorForShepherdWoolFluff(professionLevel, random)));
                for (int i = 0; i < 10; ++i) {
                    level.method_8406((class_2394)particle, (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random), random.method_43058(), MathUtil.nextNonAbsDouble(random));
                }
            } else if (profession == class_3852.field_17058) {
                for (int i = 0; i < 8; ++i) {
                    level.method_8406((class_2394)ModParticles.CHICKEN_FEATHER.get(), (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.1));
                    level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8145)), (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random, 0.25), MathUtil.nextDouble(random, 0.25), MathUtil.nextNonAbsDouble(random, 0.25));
                }
            } else if ((profession == class_3852.field_17053 || profession == class_3852.field_17052) && state.method_28498((class_2769)class_2741.field_12548) && !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                class_2248 block = state.method_26204();
                class_2680 litState = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true));
                TickerManager.schedule(10, () -> block.method_9496(litState, (class_1937)level, pos, random));
                for (int i = 0; i < 2; ++i) {
                    block.method_9496(litState, (class_1937)level, pos, random);
                }
            }
        }
    }

    private static class_1767 getColorForShepherdWoolFluff(int professionLevel, class_5819 random) {
        if (professionLevel >= 2 && random.method_43058() < 0.5) {
            return class_1767.values()[random.method_43048(class_1767.values().length)];
        }
        return COMMON_SHEPHERD_WOOL_COLORS.get(random.method_43048(COMMON_SHEPHERD_WOOL_COLORS.size()));
    }

    private static int getFallingBlockDustColor(class_638 level, class_2248 block, class_2680 state, class_2338 pos) {
        class_8170 brushableBlock;
        class_2248 turnsIntoBlock;
        if (block instanceof class_2346) {
            class_2346 fallingBlock = (class_2346)block;
            return fallingBlock.method_10130(state, (class_1922)level, pos);
        }
        if (block instanceof class_8170 && (turnsIntoBlock = (brushableBlock = (class_8170)block).method_49810()) != block) {
            return ClientPacketHandlers.getFallingBlockDustColor(level, turnsIntoBlock, state, pos);
        }
        return class_310.method_1551().method_1505().method_1691(state, (class_1937)level, pos);
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundEntityFellPayload.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPayload.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPayload.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPayload.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }
}

