/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.configs.entities.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.BooleanParticleOptions;
import einstein.subtle_effects.tickers.entity_tickers.DrowningTicker;
import einstein.subtle_effects.tickers.entity_tickers.EntityCauldronTicker;
import einstein.subtle_effects.tickers.entity_tickers.EntityFireTicker;
import einstein.subtle_effects.tickers.entity_tickers.EntityTickerManager;
import einstein.subtle_effects.tickers.entity_tickers.FrostyBreathTicker;
import einstein.subtle_effects.tickers.entity_tickers.HeartbeatTicker;
import einstein.subtle_effects.tickers.entity_tickers.HumanoidPotionRingTicker;
import einstein.subtle_effects.tickers.entity_tickers.IronGolemTicker;
import einstein.subtle_effects.tickers.entity_tickers.ItemRarityTicker;
import einstein.subtle_effects.tickers.entity_tickers.MinecartSparksTicker;
import einstein.subtle_effects.tickers.entity_tickers.MobSkullShaderTicker;
import einstein.subtle_effects.tickers.entity_tickers.SlimeTrailTicker;
import einstein.subtle_effects.tickers.entity_tickers.StomachGrowlingTicker;
import einstein.subtle_effects.tickers.entity_tickers.WitchPotionRingTicker;
import einstein.subtle_effects.tickers.entity_tickers.sleeping.BatSleepingTicker;
import einstein.subtle_effects.tickers.entity_tickers.sleeping.CatSleepingTicker;
import einstein.subtle_effects.tickers.entity_tickers.sleeping.FoxSleepingTicker;
import einstein.subtle_effects.tickers.entity_tickers.sleeping.PlayerSleepingTicker;
import einstein.subtle_effects.tickers.entity_tickers.sleeping.SleepingTicker;
import einstein.subtle_effects.tickers.entity_tickers.sleeping.VillagerSleepingTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1451;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1543;
import net.minecraft.class_1589;
import net.minecraft.class_1621;
import net.minecraft.class_1640;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3988;
import net.minecraft.class_4019;
import net.minecraft.class_4770;
import net.minecraft.class_5418;
import net.minecraft.class_5819;
import net.minecraft.class_8170;

public class ModEntityTickers {
    private static final Predicate<class_1297> LOCAL_PLAYER = entity -> entity.equals((Object)class_310.method_1551().field_1724);

    public static void init() {
        EntityTickerManager.register(entity -> true, EntityCauldronTicker::new);
        EntityTickerManager.register(entity -> !(entity instanceof class_1538), EntityFireTicker::new);
        EntityTickerManager.register(entity -> entity instanceof class_1309, ModEntityTickers::getSleepingTicker);
        EntityTickerManager.register(entity -> entity instanceof class_1688 && ModConfigs.ENTITIES.minecartSparksDisplayType != ModEntityConfigs.MinecartSparksDisplayType.OFF, MinecartSparksTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.stomachGrowlingThreshold.get() > 0), StomachGrowlingTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> ModConfigs.GENERAL.mobSkullShaders), MobSkullShaderTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.heartBeatingThreshold.get() > 0), HeartbeatTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isHumanoid(entity, !entity.method_37908().method_27983().equals(class_1937.field_25180)) && ModConfigs.ENTITIES.humanoids.drowningBubblesDisplayType.isEnabled(), DrowningTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isHumanoid(entity, !entity.method_37908().method_27983().equals(class_1937.field_25180)) && ModConfigs.ENTITIES.humanoids.frostyBreath.displayType.isEnabled(), FrostyBreathTicker::new);
        EntityTickerManager.register(entity -> entity.method_5864().equals(class_1299.field_6069) && ModConfigs.ENTITIES.slimeTrails, entity -> new SlimeTrailTicker<class_1621>((class_1621)entity, ModParticles.SLIME_TRAIL));
        EntityTickerManager.register(entity -> entity.method_5864().equals(class_1299.field_6102) && ModConfigs.ENTITIES.magmaCubeTrails, entity -> new SlimeTrailTicker<class_1589>((class_1589)entity, ModParticles.MAGMA_CUBE_TRAIL));
        EntityTickerManager.register(entity -> entity.method_5864().equals(class_1299.field_6147) && ModConfigs.ENTITIES.ironGolemCrackParticles, IronGolemTicker::new);
        EntityTickerManager.register(entity -> entity instanceof class_1542 && ModConfigs.ENTITIES.itemRarity.particlesDisplayType != ItemRarityConfigs.DisplayType.OFF, ItemRarityTicker::new);
        EntityTickerManager.register(entity -> entity instanceof class_1640 && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), WitchPotionRingTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isNPC(entity, true) && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), entity -> new HumanoidPotionRingTicker<class_1309>((class_1309)entity));
        EntityTickerManager.registerSimple(entity -> entity instanceof class_1657 && ModConfigs.ENTITIES.dustClouds.playerRunning, true, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.method_8520(entity.method_24515())) {
                return;
            }
            class_1657 player = (class_1657)entity;
            if (ModConfigs.ENTITIES.dustClouds.playerRunningRequiresSpeed && !player.method_6059(class_1294.field_5904)) {
                return;
            }
            if (player.method_27298() && player.method_24828() && !player.method_6115() && random.method_43056()) {
                level.method_8406((class_2394)ModParticles.SMALL_DUST_CLOUD.get(), entity.method_23322(1.0), entity.method_23318() + Math.max(Math.min((double)random.method_43057(), 0.3), 0.2), entity.method_23325(1.0), 0.0, random.method_43058(), 0.0);
            }
        });
        EntityTickerManager.registerSimple(entity -> entity instanceof class_1540 && ModConfigs.BLOCKS.fallingBlocks.fallingDust, false, (entity, level, random) -> {
            class_2680 state;
            class_2248 block;
            class_1540 fallingBlock = (class_1540)entity;
            float fallDistance = fallingBlock.field_6017;
            int startDistance = (Integer)ModConfigs.BLOCKS.fallingBlocks.fallingDustStartDistance.get();
            if (fallDistance <= (float)startDistance) {
                return;
            }
            if (!fallingBlock.method_24828() && !fallingBlock.method_5740() && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)(block = (state = fallingBlock.method_6962()).method_26204()))) {
                double size = startDistance > 0 ? (fallDistance <= (float)startDistance + (float)startDistance / 3.0f * 2.0f ? 0.5 : 1.0) : 1.0;
                for (int i = 0; i < (size == 1.0 ? 2 : 1); ++i) {
                    class_2680 class_26802;
                    if (block instanceof class_8170) {
                        class_8170 brushableBlock = (class_8170)block;
                        class_26802 = brushableBlock.method_49810().method_9564();
                    } else {
                        class_26802 = state;
                    }
                    level.method_8406((class_2394)new class_2388(class_2398.field_11206, class_26802), entity.method_23322(size), entity.method_23318() + 0.05, entity.method_23325(size), 0.0, 0.0, 0.0);
                }
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6068, false, () -> (Double)ModConfigs.ENTITIES.snowballTrailDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.snowballTrailDensity)) {
                class_243 deltaMovement = entity.method_18798();
                level.method_8406((class_2394)ModParticles.SNOWBALL_TRAIL.get(), entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), deltaMovement.field_1352 * 0.5, deltaMovement.field_1351, deltaMovement.field_1350 * 0.5);
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6082, false, () -> ModConfigs.ENTITIES.enderPearlTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.method_8406((class_2394)class_2398.field_11214, entity.method_23322(2.0), entity.method_23319(), entity.method_23325(2.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_38384, true, () -> (Double)ModConfigs.ENTITIES.allayMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.allayMagicDensity)) {
                level.method_8406((class_2394)ModParticles.ALLAY_MAGIC.get(), entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6059, true, () -> (Double)ModConfigs.ENTITIES.vexMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.vexMagicDensity)) {
                level.method_8406((class_2394)new BooleanParticleOptions(ModParticles.VEX_MAGIC.get(), entity.method_7176()), entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_40116, true, () -> ModConfigs.ENTITIES.dustClouds.mobRunning, (entity, level, random) -> {
            if (entity.method_45361() && entity.method_24828()) {
                for (int i = 0; i < 10; ++i) {
                    ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig((class_1309)entity, level, random, 5);
                }
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6129, false, () -> ModConfigs.ENTITIES.improvedDragonFireballTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.method_8406((class_2394)class_2398.field_11216, entity.method_23322(2.0), entity.method_23319(), entity.method_23325(2.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6136, false, () -> ModConfigs.ENTITIES.commandBlockMinecartParticles != CommandBlockSpawnType.OFF, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.commandBlockMinecartParticles.canTick() && random.method_43048(10) == 0) {
                ParticleSpawnUtil.spawnCmdBlockParticles(level, entity.method_19538().method_1031(0.0, (double)(-(entity.method_7514() - 8)) / 16.0 + 0.4266666666666667, 0.0), random, (direction, relativePos) -> true);
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6063, false, () -> ModConfigs.ENTITIES.explosives.tntSparks, (entity, level, random) -> level.method_8406((class_2394)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.method_23322(0.5), entity.method_23323(1.0), entity.method_23325(0.5), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01)));
        EntityTickerManager.registerSimple(class_1299.field_6063, false, () -> (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get() > 0, (entity, level, random) -> {
            if (random.method_43048(10) == 0) {
                int density = (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get();
                if (density == 1) {
                    level.method_8406((class_2394)class_2398.field_11240, entity.method_23317(), entity.method_23323(1.1), entity.method_23321(), 0.0, 0.0, 0.0);
                    return;
                }
                for (int i = 0; i < density; ++i) {
                    level.method_8406((class_2394)class_2398.field_11240, entity.method_23322(0.7), entity.method_23319(), entity.method_23325(0.7), 0.0, 0.0, 0.0);
                }
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6110, false, () -> ModConfigs.ENTITIES.endCrystalParticles, (entity, level, random) -> {
            if (level.method_8320(entity.method_24515()).method_26204() instanceof class_4770 || random.method_43048(3) == 0) {
                level.method_8406((class_2394)ModParticles.END_CRYSTAL.get(), entity.method_23322(1.0), entity.method_23319() + MathUtil.nextNonAbsDouble(random), entity.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6135, false, () -> ModConfigs.ENTITIES.spectralArrowParticles, (entity, level, random) -> {
            if (random.method_43048(3) == 0) {
                level.method_8406((class_2394)Util.GLOWSTONE_DUST_PARTICLES, entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6046, true, () -> ModConfigs.ENTITIES.explosives.creeperSparks, (entity, level, random) -> {
            if (entity.method_7000()) {
                for (int i = 0; i < 3; ++i) {
                    level.method_8406((class_2394)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                }
            }
        });
        EntityTickerManager.registerSimple(class_1299.field_6046, true, () -> ModConfigs.ENTITIES.explosives.creeperSmoke.isEnabled(), (entity, level, random) -> {
            if (entity.method_7000()) {
                level.method_8406(ModConfigs.ENTITIES.explosives.creeperSmoke.getParticle().get(), entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
            }
        });
        EntityTickerManager.registerSimple(entity -> entity instanceof class_1309 && entity.method_32316() && ModConfigs.ENTITIES.freezingSnowFlakes, false, (entity, level, random) -> {
            if (entity.method_40071() || entity.method_32312() > 0 || entity.method_55667().method_27852(class_2246.field_27878)) {
                level.method_8406((class_2394)ModParticles.FREEZING.get(), entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        });
    }

    public static boolean shouldSpawn(class_5819 random, ValidatedDouble chanceConfig) {
        return (double)Math.min(random.method_43057(), 1.0f) < (Double)chanceConfig.get();
    }

    private static SleepingTicker<?> getSleepingTicker(class_1309 entity) {
        class_1309 class_13092 = entity;
        Objects.requireNonNull(class_13092);
        class_1309 class_13093 = class_13092;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3988.class, class_1657.class, class_1420.class, class_1451.class, class_4019.class}, (Object)class_13093, n)) {
            case 0 -> {
                class_3988 villager = (class_3988)class_13093;
                yield new VillagerSleepingTicker(villager);
            }
            case 1 -> {
                class_1657 player = (class_1657)class_13093;
                yield new PlayerSleepingTicker(player);
            }
            case 2 -> {
                class_1420 bat = (class_1420)class_13093;
                yield new BatSleepingTicker(bat);
            }
            case 3 -> {
                class_1451 cat = (class_1451)class_13093;
                yield new CatSleepingTicker(cat);
            }
            case 4 -> {
                class_4019 fox = (class_4019)class_13093;
                yield new FoxSleepingTicker(fox);
            }
            default -> new SleepingTicker(entity);
        };
    }

    private static boolean isHumanoid(class_1297 entity, boolean includePiglins) {
        return entity instanceof class_1657 || ModEntityTickers.isNPC(entity, includePiglins) || entity instanceof class_1640;
    }

    private static boolean isNPC(class_1297 entity, boolean includePiglins) {
        return entity instanceof class_3988 || entity instanceof class_1543 || includePiglins && entity instanceof class_5418;
    }
}

