/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.NamedReloadListener;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class MobSkullShaderReloadListener
extends class_4309
implements NamedReloadListener {
    public static final String DIRECTORY = "subtle_effects/mob_skull_shaders";
    public static final Map<class_2960, MobSkullShaderData> MOB_SKULL_SHADERS = new HashMap<class_2960, MobSkullShaderData>();

    public MobSkullShaderReloadListener() {
        super(Util.GSON, DIRECTORY);
    }

    protected void apply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, MobSkullShaderData> dataMap = new HashMap<class_2960, MobSkullShaderData>();
        MOB_SKULL_SHADERS.clear();
        resources.forEach((id, element) -> MobSkullShaderData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, element).resultOrPartial(error -> SubtleEffects.LOGGER.error("Failed to decode mob skull shader with ID {} - Error: {}", id, error)).ifPresent(shaderData -> dataMap.put((class_2960)id, (MobSkullShaderData)shaderData)));
        MobSkullShaderReloadListener.load(manager, dataMap);
    }

    private static void load(class_3300 manager, Map<class_2960, MobSkullShaderData> dataMap) {
        dataMap.forEach((location, shaderData) -> {
            class_1792 item = shaderData.stackHolder().item();
            if (item.equals(class_1802.field_8162)) {
                SubtleEffects.LOGGER.error("Item in Mob Skull Shader '{}' can not be air", location);
                return;
            }
            class_2960 shaderId = shaderData.shaderId();
            if (manager.method_14486(shaderId).isEmpty()) {
                SubtleEffects.LOGGER.error("Could not find post shader with ID '{}' for Mob Skull Shader: '{}'", (Object)shaderId, location);
                return;
            }
            MOB_SKULL_SHADERS.put((class_2960)location, (MobSkullShaderData)shaderData);
        });
    }

    @Override
    public class_2960 getId() {
        return SubtleEffects.loc("mob_skull_shaders");
    }
}

