/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModPayloads;
import einstein.subtle_effects.tickers.FlameGeyserTicker;
import einstein.subtle_effects.tickers.TickerManager;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static boolean DISPLAY_PARTICLE_COUNT = false;
    private static class_1937 LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModPayloads.initClientHandlers();
        ModEntityTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticles.init();
    }

    public static void clientTick(class_310 minecraft, class_1937 level) {
        class_746 player = minecraft.field_1724;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                TickerManager.clear(level);
                BiomeParticleManager.clear();
                FlameGeyserTicker.ACTIVE_GEYSERS.clear();
                FlameGeyserTicker.INACTIVE_GEYSERS.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.method_1493() || level.method_54719().method_54754()) {
            return;
        }
        if (DISPLAY_PARTICLE_COUNT) {
            player.method_7353((class_2561)class_2561.method_43469((String)"ui.subtle_effects.hud.particle_count", (Object[])new Object[]{minecraft.field_1713.method_3052()}), true);
        }
        BiomeParticleManager.tickBiomeParticles(level, (class_1657)player);
        TickerManager.tick();
        HAS_CLEARED = false;
    }

    public static <T extends class_2172> void registerClientCommands(CommandDispatcher<T> dispatcher, class_7157 buildContext) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$0(minecraft, (class_1657)player, arg_0));
        RequiredArgumentBuilder particlesCountEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$1((class_1657)player, arg_0));
        LiteralArgumentBuilder particlesCount = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"count").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$2((class_1657)player, arg_0))).then((ArgumentBuilder)particlesCountEnabled);
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear)).then((ArgumentBuilder)particlesCount);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$3((class_1657)player, arg_0));
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static int toggleParticleCount(class_1657 player, boolean enabled) {
        DISPLAY_PARTICLE_COUNT = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(player, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.count." + enabledString + ".success"));
        return 1;
    }

    private static class_5250 getMsgTranslation(String string) {
        return class_2561.method_43471((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(class_1657 player, class_2561 component) {
        if (player != null) {
            player.method_43496(component);
        }
    }

    private static /* synthetic */ int lambda$registerClientCommands$3(class_1657 player, CommandContext context) throws CommandSyntaxException {
        TickerManager.clear(player.method_37908());
        SubtleEffectsClient.sendSystemMsg(player, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
        return 1;
    }

    private static /* synthetic */ int lambda$registerClientCommands$2(class_1657 player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, true);
    }

    private static /* synthetic */ int lambda$registerClientCommands$1(class_1657 player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, BoolArgumentType.getBool((CommandContext)context, (String)"enabled"));
    }

    private static /* synthetic */ int lambda$registerClientCommands$0(class_310 minecraft, class_1657 player, CommandContext context) throws CommandSyntaxException {
        minecraft.field_1713.method_48015();
        SubtleEffectsClient.sendSystemMsg(player, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
        return 1;
    }
}

