/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedGameRulesProvider;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class CrabEggBlock
extends class_2248 {
    private static final class_265 SMALL_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final class_265 LARGE_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final class_2758 HATCH = class_2741.field_12530;
    public static final class_2758 EGGS = class_2741.field_12509;

    public CrabEggBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HATCH, (Comparable)Integer.valueOf(0))).method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!entity.method_21749()) {
            this.tryBreakEgg(world, state, pos, entity, 100);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!(entity instanceof class_1642)) {
            this.tryBreakEgg(world, state, pos, entity, 3);
        }
        super.method_9554(world, state, pos, entity, fallDistance);
    }

    private void tryBreakEgg(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, int inverseChance) {
        class_3218 serverLevel;
        if (state.method_27852((class_2248)FriendsAndFoesBlocks.CRAB_EGG.get()) && level instanceof class_3218 && this.canBreaksEgg(serverLevel = (class_3218)level, entity) && level.method_8409().method_43048(inverseChance) == 0) {
            this.breakEgg(level, pos, state);
        }
    }

    private void breakEgg(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8396(null, pos, class_3417.field_14687, class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
        int i = (Integer)state.method_11654((class_2769)EGGS);
        if (i <= 1) {
            world.method_22352(pos, false);
        } else {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            world.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43287((class_2680)state));
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.shouldHatchProgress((class_1937)world, pos) && CrabEggBlock.isSuitableBelow((class_1922)world, pos)) {
            int i = (Integer)state.method_11654((class_2769)HATCH);
            if (i < 2) {
                world.method_8396(null, pos, class_3417.field_15109, class_3419.field_15245, 0.7f, 0.9f + random.method_43057() * 0.2f);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                world.method_8396(null, pos, class_3417.field_14902, class_3419.field_15245, 0.7f, 0.9f + random.method_43057() * 0.2f);
                world.method_8650(pos, false);
                for (int j = 0; j < (Integer)state.method_11654((class_2769)EGGS); ++j) {
                    world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                    CrabEntity crab = (CrabEntity)((class_1299)FriendsAndFoesEntityTypes.CRAB.get()).method_5883((class_1937)world);
                    crab.method_5614(-24000);
                    VersionedEntity.moveTo((class_1297)crab, (double)pos.method_10263() + 0.3 + (double)j * 0.2, pos.method_10264(), (double)pos.method_10260() + 0.3, 0.0f, 0.0f);
                    crab.setHome(crab.getNewHome());
                    world.method_8649((class_1297)crab);
                }
            }
        }
    }

    public static boolean isSuitableBelow(class_1922 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26164(FriendsAndFoesTags.CRAB_BURROW_SPOT_BLOCKS);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (CrabEggBlock.isSuitableBelow((class_1922)world, pos) && !world.method_8608()) {
            world.method_20290(2005, pos, 0);
        }
    }

    private boolean shouldHatchProgress(class_1937 world, class_2338 blockPos) {
        float f = world.method_30274(1.0f);
        return f > 0.0f && world.method_8409().method_43057() < f;
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, state, blockEntity, stack);
        this.breakEgg(world, pos, state);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return !context.method_8046() && context.method_8041().method_31574(this.method_8389()) && (Integer)state.method_11654((class_2769)EGGS) < 4 || super.method_9616(state, context);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        return blockState.method_27852((class_2248)this) ? (class_2680)blockState.method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.method_11654((class_2769)EGGS) + 1))) : super.method_9605(ctx);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Integer)state.method_11654((class_2769)EGGS) > 1 ? LARGE_SHAPE : SMALL_SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HATCH, EGGS});
    }

    private boolean canBreaksEgg(class_3218 world, class_1297 entity) {
        if (!(entity instanceof CrabEntity) && !(entity instanceof class_1420)) {
            if (!(entity instanceof class_1309)) {
                return false;
            }
            return entity instanceof class_1657 || VersionedGameRulesProvider.getBoolean(world, VersionedGameRulesProvider.MOB_GRIEFING);
        }
        return false;
    }
}

