/*
 * Decompiled with CFR 0.152.
 */
package fuzs.respawninganimals.handler;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.respawninganimals.RespawningAnimals;
import fuzs.respawninganimals.init.ModRegistry;
import fuzs.respawninganimals.mixin.accessor.EntityTypeAccessor;
import fuzs.respawninganimals.mixin.accessor.MobCategoryAccessor;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5138;
import net.minecraft.class_5483;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AnimalSpawningHandler {
    private static final Set<class_3730> PERSISTENT_SPAWN_TYPES = Set.of(class_3730.field_16474, class_3730.field_16466, class_3730.field_16461, class_3730.field_16473);

    public static void onLevelLoad(MinecraftServer server, class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            AnimalSpawningHandler.setCreatureAttributes(level.method_8450());
        }
    }

    public static void setCreatureAttributes(class_1928 gameRules) {
        boolean persistentAnimals = gameRules.method_8355(ModRegistry.PERSISTENT_ANIMALS_GAME_RULE);
        ((MobCategoryAccessor)MobCategoryAccessor.class.cast(class_1311.field_6294)).respawninganimals$setIsPersistent(persistentAnimals);
        ((MobCategoryAccessor)MobCategoryAccessor.class.cast(class_1311.field_6294)).respawninganimals$setMax(persistentAnimals ? 10 : gameRules.method_8356(ModRegistry.ANIMAL_MOB_CAP_GAME_RULE));
    }

    public static EventResult onCheckMobDespawn(class_1308 mob, class_3218 level) {
        class_1657 player;
        if (AnimalSpawningHandler.isAllowedToDespawn(mob, level.method_8450()) && (player = mob.method_37908().method_18460((class_1297)mob, -1.0)) != null) {
            int despawnDistance;
            double distanceToSqr = player.method_5858((class_1297)mob);
            if (distanceToSqr > (double)((despawnDistance = mob.method_5864().method_5891().method_27919()) * despawnDistance)) {
                return EventResult.ALLOW;
            }
            int noDespawnDistance = mob.method_5864().method_5891().method_27920();
            if (mob.method_6131() > 600 && mob.method_59922().method_43048(800) == 0 && distanceToSqr > (double)(noDespawnDistance * noDespawnDistance)) {
                return EventResult.ALLOW;
            }
            return EventResult.DENY;
        }
        return EventResult.PASS;
    }

    public static boolean isAllowedToDespawn(class_1308 mob, @Nullable class_1928 gameRules) {
        if (AnimalSpawningHandler.isAnimalDespawningAllowed(mob.method_5864(), gameRules, mob.method_5864().method_5891())) {
            class_3730 spawnType = CommonAbstractions.INSTANCE.getMobSpawnType(mob);
            return spawnType != null && !PERSISTENT_SPAWN_TYPES.contains(spawnType);
        }
        return false;
    }

    public static boolean isAnimalDespawningAllowed(class_1299<?> entityType, @Nullable class_1928 gameRules, class_1311 mobCategory) {
        if (gameRules != null && gameRules.method_8355(ModRegistry.PERSISTENT_ANIMALS_GAME_RULE)) {
            return false;
        }
        if (entityType.method_20210(ModRegistry.PERSISTENT_ANIMALS_ENTITY_TYPE_TAG)) {
            return false;
        }
        return mobCategory == class_1311.field_6294;
    }

    public static EventResult onEntityLoad(class_1297 entity, class_3218 level) {
        AnimalSpawningHandler.setPersistenceForPersistentAnimal(entity);
        return EventResult.PASS;
    }

    private static void setPersistenceForPersistentAnimal(class_1297 entity) {
        class_1308 mob;
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5864().method_5891() == class_1311.field_6294 && !mob.method_5947() && !AnimalSpawningHandler.isAllowedToDespawn(mob, null)) {
            mob.method_5971();
        }
    }

    public static EventResult onEntitySpawn(class_1297 entity, class_3218 level, @Nullable class_3730 mobSpawnType) {
        if (entity instanceof class_1308) {
            if (mobSpawnType == class_3730.field_16472) {
                AnimalSpawningHandler.applyCorrectMobCategory(entity.method_5864());
                if (AnimalSpawningHandler.isAnimalDespawningAllowed(entity.method_5864(), level.method_8450(), class_1311.field_6294)) {
                    return EventResult.INTERRUPT;
                }
            }
            AnimalSpawningHandler.setPersistenceForPersistentAnimal(entity);
        }
        return EventResult.PASS;
    }

    private static void applyCorrectMobCategory(class_1299<?> entityType) {
        if (entityType.method_5891() != class_1311.field_6294) {
            class_2960 resourceLocation = class_7923.field_41177.method_10221(entityType);
            Optional<String> issues = ModLoaderEnvironment.INSTANCE.getModContainer(resourceLocation.method_12836()).map(modContainer -> (String)modContainer.getContactTypes().get("issues"));
            String modName = ModLoaderEnvironment.INSTANCE.getModContainer(resourceLocation.method_12836()).map(ModContainer::getDisplayName).orElse(resourceLocation.method_12836());
            RespawningAnimals.LOGGER.warn("Mismatched spawn type for {}! Mob is registered as {}, but spawning as {}. Report this to the author of {}" + issues.map(s -> " at " + s).orElse("") + ".", (Object)resourceLocation, (Object)entityType.method_5891(), (Object)class_1311.field_6294, (Object)modName);
            ((EntityTypeAccessor)entityType).respawninganimals$setCategory(class_1311.field_6294);
        }
    }

    public static void onGatherPotentialSpawns(class_3218 level, class_5138 structureManager, class_2794 chunkGenerator, class_1311 mobCategory, class_2338 blockPos, List<class_5483.class_1964> mobs) {
        if (mobCategory == class_1311.field_6294) {
            Iterator<class_5483.class_1964> iterator = mobs.iterator();
            while (iterator.hasNext()) {
                class_5483.class_1964 spawnerData = iterator.next();
                AnimalSpawningHandler.applyCorrectMobCategory(spawnerData.field_9389);
                if (AnimalSpawningHandler.isAnimalDespawningAllowed(spawnerData.field_9389, level.method_8450(), class_1311.field_6294)) continue;
                iterator.remove();
            }
        }
    }
}

