/*
 * Decompiled with CFR 0.152.
 */
package fuzs.respawninganimals.handler;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.respawninganimals.handler.AnimalSpawningHandler;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5146;
import net.minecraft.class_6025;
import net.minecraft.class_9817;

public class AnimalPersistenceHandler {
    private static final List<Predicate<class_1308>> TICK_PREDICATES = Lists.newArrayList();

    public static void onEndEntityTick(class_1297 entity) {
        class_1308 mob;
        if (entity instanceof class_1308 && !(mob = (class_1308)entity).method_5947() && AnimalSpawningHandler.isAllowedToDespawn(mob, mob.method_37908().method_8450())) {
            for (Predicate<class_1308> mobPredicate : TICK_PREDICATES) {
                if (!mobPredicate.test(mob)) continue;
                mob.method_5971();
                break;
            }
        }
    }

    public static EventResult onAnimalTame(class_1429 animal, class_1657 player) {
        AnimalPersistenceHandler.setPersistenceForVolatileAnimal((class_1297)animal);
        return EventResult.PASS;
    }

    public static EventResult onStartRiding(class_1937 level, class_1297 rider, class_1297 vehicle) {
        if (rider instanceof class_1657) {
            AnimalPersistenceHandler.setPersistenceForVolatileAnimal(vehicle);
        }
        return EventResult.PASS;
    }

    private static void setPersistenceForVolatileAnimal(class_1297 entity) {
        class_1308 mob;
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5864().method_5891() == class_1311.field_6294 && !mob.method_5947() && AnimalSpawningHandler.isAllowedToDespawn(mob, entity.method_37908().method_8450())) {
            mob.method_5971();
        }
    }

    static {
        TICK_PREDICATES.add(mob -> {
            class_1429 animal;
            return mob instanceof class_1429 && (animal = (class_1429)mob).method_6479();
        });
        TICK_PREDICATES.add(class_9817::method_60953);
        TICK_PREDICATES.add(mob -> {
            class_6025 ownable;
            return mob instanceof class_6025 && (ownable = (class_6025)mob).method_6139() != null;
        });
        TICK_PREDICATES.add(mob -> {
            class_5146 saddleable;
            return mob instanceof class_5146 && (saddleable = (class_5146)mob).method_6725();
        });
    }
}

