/*
 * Decompiled with CFR 0.152.
 */
package com.threads;

import com.threads.Config;
import com.threads.ThreadList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ThreadsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadsManager.class);
    private static final Config CONFIG = new Config().init();

    public ThreadsManager() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.onWorldLoad());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.onWorldUnLoad());
    }

    private void onWorldLoad() {
        this.setPriority(ThreadList.RENDER, CONFIG.renderThreadPriority());
        this.setPriority(ThreadList.SERVER, CONFIG.serverThreadPriority());
        this.setPriority(ThreadList.SOUND_ENGINE, CONFIG.soundEngineThreadPriority());
        this.applyForEveryThread(CONFIG.everyOtherThreadPriority());
    }

    private void onWorldUnLoad() {
        for (ThreadList thread : ThreadList.values()) {
            this.resetPriority(thread);
        }
    }

    public void reload() {
        CONFIG.reload();
        this.setPriority(ThreadList.RENDER, CONFIG.renderThreadPriority());
        this.setPriority(ThreadList.SERVER, CONFIG.serverThreadPriority());
        this.setPriority(ThreadList.SOUND_ENGINE, CONFIG.soundEngineThreadPriority());
        this.applyForEveryThread(CONFIG.everyOtherThreadPriority());
    }

    private void setPriority(ThreadList thread, int priority) {
        thread.thread().ifPresent(v -> {
            int value = v.getPriority();
            v.setPriority(priority);
            if (CONFIG.debug()) {
                LOGGER.info("Set priority from {} to {} for {}.", new Object[]{value, priority, v.getName()});
            }
        });
    }

    private void resetPriority(ThreadList thread) {
        thread.thread().ifPresent(v -> v.setPriority(thread.defaultPriority()));
    }

    private void applyForEveryThread(int priority) {
        if (priority < 1) {
            return;
        }
        ArrayList<String> blacklist = new ArrayList<String>(List.of(CONFIG.threadBlacklist()));
        blacklist.addAll(Stream.of(ThreadList.values()).filter(t -> t.thread().isPresent()).map(t -> t.thread().get().getName()).toList());
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (blacklist.contains(thread.getName())) continue;
            thread.setPriority(priority);
            if (!CONFIG.debug()) continue;
            LOGGER.info("Changed priority for {} to {}.", (Object)thread.getName(), (Object)priority);
        }
    }
}

