/*
 * Decompiled with CFR 0.152.
 */
package com.threads;

import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public enum ThreadList {
    RENDER("Render thread", 5, 10),
    SERVER("Server thread", 5, 8),
    SOUND_ENGINE("Sound engine", new int[0]);

    private final Supplier<Thread> thread = () -> Thread.getAllStackTraces().keySet().stream().filter(v -> v.getName().equals(name)).findFirst().orElse(null);
    private final int defaultPriority;

    private ThreadList(String name, int ... priorities) {
        this.defaultPriority = Runtime.getRuntime().availableProcessors() <= 4 && priorities.length > 0 ? priorities[0] : (priorities.length > 1 ? priorities[1] : 5);
    }

    public Optional<Thread> thread() {
        return Optional.ofNullable(this.thread.get());
    }

    public int defaultPriority() {
        return this.defaultPriority;
    }
}

