/*
 * Decompiled with CFR 0.152.
 */
package com.threads;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.threads.ThreadList;
import com.threads.Threads;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Config {
    private int renderThreadPriority = ThreadList.RENDER.defaultPriority();
    private int serverThreadPriority = ThreadList.SERVER.defaultPriority();
    private int soundEngineThreadPriority = ThreadList.SOUND_ENGINE.defaultPriority();
    private int everyOtherThreadPriority;
    private String[] threadBlacklist = new String[0];
    private boolean debug;

    public int renderThreadPriority() {
        return this.renderThreadPriority;
    }

    public int serverThreadPriority() {
        return this.serverThreadPriority;
    }

    public int soundEngineThreadPriority() {
        return this.soundEngineThreadPriority;
    }

    public int everyOtherThreadPriority() {
        return this.everyOtherThreadPriority;
    }

    public String[] threadBlacklist() {
        return this.threadBlacklist;
    }

    public boolean debug() {
        return this.debug;
    }

    public Config init() {
        try {
            if (!Threads.CONFIG_FILE.toFile().exists()) {
                Files.write(Threads.CONFIG_FILE, Threads.GSON.toJson((Object)new Config()).getBytes(), new OpenOption[0]);
            }
            return Config.fromJson(Threads.GSON, Threads.CONFIG_FILE);
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
            return new Config();
        }
    }

    public void reload() {
        try {
            Config config = Config.fromJson(Threads.GSON, Threads.CONFIG_FILE);
            this.renderThreadPriority = config.renderThreadPriority;
            this.serverThreadPriority = config.serverThreadPriority;
            this.soundEngineThreadPriority = config.soundEngineThreadPriority;
            this.everyOtherThreadPriority = config.everyOtherThreadPriority;
            this.threadBlacklist = config.threadBlacklist;
            this.debug = config.debug;
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                Files.write(Threads.CONFIG_FILE, Threads.GSON.toJson((Object)new Config()).getBytes(), new OpenOption[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private static Config fromJson(Gson gson, Path path) throws JsonSyntaxException, IOException {
        JsonObject json = (JsonObject)gson.fromJson(Files.readString(path), JsonObject.class);
        Config config = new Config();
        config.renderThreadPriority = Math.clamp((long)json.get("renderThreadPriority").getAsInt(), 1, 10);
        config.serverThreadPriority = Math.clamp((long)json.get("serverThreadPriority").getAsInt(), 1, 10);
        config.soundEngineThreadPriority = Math.clamp((long)json.get("soundEngineThreadPriority").getAsInt(), 1, 10);
        config.everyOtherThreadPriority = Math.clamp((long)json.get("everyOtherThreadPriority").getAsInt(), 0, 10);
        config.threadBlacklist = (String[])json.get("threadBlacklist").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toArray(String[]::new);
        config.debug = json.get("debug").getAsBoolean();
        return config;
    }
}

