/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items;

import de.ambertation.wunderlib.math.Bounds;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2633;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3748;
import net.minecraft.class_3751;
import net.minecraft.class_3785;
import net.minecraft.class_5000;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.interfaces.AirSelectionItem;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.ui.ColorUtil;

public class DebugDataItem
extends class_1792
implements ItemModelProvider,
AirSelectionItem {
    public static final class_2960 DEFAULT_ICON = class_2960.method_60656((String)"stick");
    protected final DebugInteraction interaction;
    protected final class_2960 icon;
    public final boolean placeInAir;

    public static class_1269 fillStructureEntityBounds(class_1838 useOnContext, class_2586 entity, BlockStatePredicate predicate, class_2680 newState, boolean floodFill) {
        if (entity instanceof class_2633) {
            class_2633 e = (class_2633)entity;
            if (floodFill) {
                DebugDataItem.floodFillStructureEntityBounds(useOnContext, e, predicate, newState);
            } else {
                DebugDataItem.fillStructureEntityBounds(useOnContext, e, predicate, newState);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public static void fillStructureEntityBounds(class_1838 useOnContext, class_2633 entity, BlockStatePredicate predicate, class_2680 newState) {
        class_1937 level = useOnContext.method_8045();
        class_2382 size = entity.method_11349();
        class_2338 pos = useOnContext.method_8037().method_10081((class_2382)entity.method_11359());
        for (int x = 0; x < size.method_10263(); ++x) {
            for (int y = 0; y < size.method_10264(); ++y) {
                for (int z = 0; z < size.method_10260(); ++z) {
                    class_2338 blockPos = pos.method_10069(x, y, z);
                    class_2680 state = level.method_8320(blockPos);
                    if (!predicate.test(state)) continue;
                    level.method_8652(blockPos, newState, 18);
                }
            }
        }
    }

    public static void floodFillStructureEntityBounds(class_1838 useOnContext, class_2633 entity, BlockStatePredicate predicate, class_2680 newState) {
        Bounds bounds = Bounds.of((class_2338)useOnContext.method_8037().method_10081((class_2382)entity.method_11359()), (class_2382)entity.method_11349());
        DebugDataItem.floodFillStructureEntityBounds(useOnContext.method_8045(), bounds, bounds.max.toBlockPos(), entity, predicate, newState, new HashSet<class_2338>());
    }

    private static void floodFillStructureEntityBounds(class_1937 level, Bounds bounds, class_2338 pos, class_2633 entity, BlockStatePredicate predicate, class_2680 newState, Set<class_2338> visited) {
        if (!bounds.isInside(pos)) {
            return;
        }
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        if (predicate.test(level.method_8320(pos))) {
            level.method_8652(pos, newState, 18);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.method_10084(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.method_10074(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.method_10095(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.method_10078(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.method_10072(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.method_10067(), entity, predicate, newState, visited);
        }
    }

    public DebugDataItem(DebugEntityInteraction interaction, boolean placeInAir, class_2960 icon) {
        this((DebugInteraction)interaction, placeInAir, icon);
    }

    public DebugDataItem(DebugInteraction interaction, boolean placeInAir, class_2960 icon) {
        super(new class_1792.class_1793().method_24359().method_7889(1));
        this.interaction = interaction;
        this.icon = icon == null ? DEFAULT_ICON : icon;
        this.placeInAir = placeInAir;
    }

    @Override
    public boolean renderAirSelection() {
        return this.placeInAir;
    }

    public boolean method_7886(class_1799 itemStack) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 resourceLocation) {
        return ModelsHelper.createItemModel(this.icon);
    }

    @Override
    public class_1269 method_7884(class_1838 useOnContext) {
        if (!useOnContext.method_8036().method_7338()) {
            return class_1269.field_5814;
        }
        return this.interaction.use(useOnContext);
    }

    public static void message(class_1657 player, String text) {
        DebugDataItem.message(player, text, ColorUtil.GRAY);
    }

    public static void message(class_1657 player, String text, int color) {
        DebugDataItem.message(player, (class_2561)class_2561.method_43470((String)text).method_27696(class_2583.field_24360.method_36139(color)));
    }

    public static void message(class_1657 player, class_2561 component) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            sp.method_43502(component, true);
        }
    }

    public boolean method_7885(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        return AirSelectionItem.super.useOnAir(level, player, interactionHand);
    }

    public static DebugDataItem forLootTable(class_5321<class_52> table, class_1792 icon) {
        class_2960 iconId = class_7923.field_41178.method_10221((Object)icon);
        return new DebugDataItem((player, entity, ctx) -> {
            class_2487 tag = entity.method_38244((class_7225.class_7874)player.method_56673());
            tag.method_10551("LootTableSeed");
            tag.method_10551("Items");
            tag.method_10582("LootTable", table.method_29177().toString());
            entity.method_58691(tag, (class_7225.class_7874)player.method_56673());
            DebugDataItem.message(player, "Did set Loot Table to " + table.toString());
            return class_1269.field_5812;
        }, false, iconId);
    }

    public static DebugDataItem forSpawner(Supplier<class_2487> tag, class_1792 icon) {
        class_2960 iconId = class_7923.field_41178.method_10221((Object)icon);
        return new DebugDataItem((player, entity, ctx) -> {
            if (entity instanceof class_2636) {
                entity.method_58691((class_2487)tag.get(), (class_7225.class_7874)player.method_56673());
                DebugDataItem.message(player, "Did set Data to " + tag.toString());
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }, false, iconId);
    }

    public static DebugDataItem forSteetJigSaw(String modID, class_5321<class_3785> pool, class_1792 icon) {
        return DebugDataItem.forJigsaw(pool == null ? class_5468.field_26254 : pool, class_2960.method_60655((String)modID, (String)"street"), class_3751.class_4991.field_23330, null, null, icon);
    }

    public static DebugDataItem forHouseEntranceJigSaw(String modID, class_5321<class_3785> pool, class_1792 icon) {
        return DebugDataItem.forJigsaw(pool == null ? class_5468.field_26254 : pool, pool == null ? class_2960.method_60655((String)modID, (String)"building_entrance") : class_2960.method_60655((String)modID, (String)"street_entrance"), pool == null ? class_2960.method_60655((String)modID, (String)"street_entrance") : class_2960.method_60655((String)modID, (String)"building_entrance"), class_3751.class_4991.field_23330, null, null, icon);
    }

    public static DebugDataItem forDecorationJigSaw(String modID, class_5321<class_3785> pool, class_1792 icon) {
        return DebugDataItem.forJigsaw(pool == null ? class_5468.field_26254 : pool, pool == null ? class_2960.method_60655((String)modID, (String)"side") : class_2960.method_60655((String)modID, (String)"side_street"), pool == null ? class_2960.method_60655((String)modID, (String)"side_street") : class_2960.method_60655((String)modID, (String)"side"), class_3751.class_4991.field_23330, null, null, icon);
    }

    public static DebugDataItem forStreetDecorationJigSaw(String modID, class_5321<class_3785> pool, class_1792 icon) {
        return DebugDataItem.forJigsaw(pool == null ? class_5468.field_26254 : pool, pool == null ? class_2960.method_60655((String)modID, (String)"bottom") : class_2960.method_60655((String)modID, (String)"bottom_street"), pool == null ? class_2960.method_60655((String)modID, (String)"bottom_street") : class_2960.method_60655((String)modID, (String)"bottom"), class_3751.class_4991.field_23329, null, pool == null ? class_5000.field_23384 : class_5000.field_23388, icon);
    }

    public static DebugDataItem forJigsaw(class_5321<class_3785> pool, class_2960 connector, class_3751.class_4991 type, class_2680 finalState, class_5000 forceOrientation, class_1792 icon) {
        return DebugDataItem.forJigsaw(pool, connector, connector, type, finalState, forceOrientation, icon);
    }

    public static DebugDataItem forJigsaw(class_5321<class_3785> pool, class_2960 name, class_2960 target, class_3751.class_4991 type, class_2680 finalState, class_5000 forceOrientation, class_1792 icon) {
        class_2960 iconId = class_7923.field_41178.method_10221((Object)icon);
        return new DebugDataItem(ctx -> {
            class_1657 player = ctx.method_8036();
            class_1937 level = ctx.method_8045();
            class_2338 pos = ctx.method_8037();
            class_2680 state = level.method_8320(pos);
            class_2586 entity = level.method_8321(pos);
            class_2680 targetState = finalState;
            if (!(entity instanceof class_3751)) {
                if (targetState == null) {
                    targetState = state.method_26215() ? class_2246.field_10369.method_9564() : state;
                }
                state = class_2246.field_16540.method_9564();
                level.method_8652(pos, state, 18);
                entity = level.method_8321(pos);
                DebugDataItem.message(player, "Created JigSaw at " + pos.toString());
            }
            if (entity instanceof class_3751) {
                class_3751 e = (class_3751)entity;
                state = forceOrientation == null ? PlaceCommand.setJigsawOrientation(class_3751.class_4991.field_23329 != type, player, pos, state) : (class_2680)state.method_11657((class_2769)class_3748.field_23262, (Comparable)forceOrientation);
                level.method_8652(pos, state, 18);
                if (pool != null) {
                    e.method_16379(name);
                }
                if (pool != null) {
                    e.method_16378(target);
                }
                if (pool != null) {
                    e.method_26398(pool);
                }
                if (targetState != null) {
                    e.method_16377(class_2259.method_9685((class_2680)targetState));
                }
                e.method_26396(type);
                DebugDataItem.message(player, "Did update Jigsaw at " + pos.toString());
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }, true, iconId);
    }

    public static interface BlockStatePredicate {
        public boolean test(class_2680 var1);
    }

    public static interface DebugInteraction {
        public class_1269 use(class_1838 var1);
    }

    public static interface DebugEntityInteraction
    extends DebugInteraction {
        @Override
        default public class_1269 use(class_1838 useOnContext) {
            class_2586 entity = useOnContext.method_8045().method_8321(useOnContext.method_8037());
            if (entity != null) {
                return this.use(useOnContext.method_8036(), entity, useOnContext);
            }
            return class_1269.field_5814;
        }

        public class_1269 use(class_1657 var1, class_2586 var2, class_1838 var3);
    }
}

