/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.mixin;

import com.hidoni.transmog.TransmogUtils;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.config.TooltipDetailLevel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public class ItemStackMixin {
    @Unique
    private static final String[] TRANSLATION_KEYS_TO_REMOVE = new String[]{"item.modifiers.*", "attribute.modifier.*", "item.unbreakable", "item.canBreak", "item.canPlace", "item.durability", "item.nbt_tags", "item.disabled", "item.components"};

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void addTransmogTooltipToItemStack(class_1792.class_9635 tooltipContext, class_1657 player, class_1836 tooltipFlag, CallbackInfoReturnable<List<class_2561>> cir) {
        class_1799 thisStack = (class_1799)this;
        if (Config.tooltipDetailLevel == TooltipDetailLevel.NONE || thisStack.method_57826(class_9334.field_50074) || thisStack.method_57826(class_9334.field_49638)) {
            return;
        }
        if (TransmogUtils.isItemStackTransmogged(thisStack)) {
            class_1799 appearanceStack = TransmogUtils.getAppearanceItemStack(thisStack, true);
            List originalItemLines = (List)cir.getReturnValue();
            originalItemLines.add(class_2561.method_43471((String)"transmog.transmog_description").method_27692(class_124.field_1076));
            originalItemLines.addAll(ItemStackMixin.getTransmogTooltipLines(tooltipContext, player, tooltipFlag, appearanceStack));
        }
    }

    @Unique
    @NotNull
    private static List<class_2561> getTransmogTooltipLines(class_1792.class_9635 tooltipContext, class_1657 player, class_1836 tooltipFlag, class_1799 appearanceStack) {
        List<class_5250> components;
        if (TransmogUtils.isHiddenItem(appearanceStack)) {
            components = List.of(class_2561.method_43471((String)"transmog.transmog_hidden").method_27692(class_124.field_1076));
        } else if (Config.tooltipDetailLevel == TooltipDetailLevel.MINIMAL) {
            components = new ArrayList<class_5250>(List.of(class_2561.method_43473().method_10852(appearanceStack.method_7909().method_7864(appearanceStack)).method_27692(appearanceStack.method_7932().method_58413())));
            if (tooltipFlag.method_8035()) {
                components.add(class_2561.method_43470((String)class_7923.field_41178.method_10221((Object)appearanceStack.method_7909()).toString()).method_27692(class_124.field_1063));
            }
        } else {
            components = new ArrayList<class_2561>(appearanceStack.method_7950(tooltipContext, player, tooltipFlag).stream().filter(ItemStackMixin::keepComponent).toList());
            if (((class_2561)components.getLast()).equals((Object)class_5244.field_39003)) {
                components.removeLast();
            }
        }
        return components;
    }

    @Unique
    private static boolean keepComponent(class_2561 component) {
        if (!(component instanceof class_5250)) {
            return true;
        }
        class_5250 mutableComponent = (class_5250)component;
        String[] stringArray = mutableComponent.method_10851();
        if (stringArray instanceof class_2588) {
            class_2588 translatableContents = (class_2588)stringArray;
            for (String translationKey : TRANSLATION_KEYS_TO_REMOVE) {
                if (translationKey.endsWith("*") && translatableContents.method_11022().startsWith(translationKey.replace("*", ""))) {
                    return false;
                }
                if (!translatableContents.method_11022().equals(translationKey)) continue;
                return false;
            }
        }
        for (class_2561 sibling : mutableComponent.method_10855()) {
            if (ItemStackMixin.keepComponent(sibling)) continue;
            return false;
        }
        return true;
    }
}

