/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.defaultcomponents.data;

import com.awakenedredstone.defaultcomponents.data.DefaultComponentData;
import com.awakenedredstone.defaultcomponents.mixin.DataPackContentsAccessor;
import com.awakenedredstone.defaultcomponents.mixin.TagEntryAccessor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3497;
import net.minecraft.class_3505;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Default Components Data Parser");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_6903<JsonElement> ops;

    public DefaultComponentLoader(class_7225.class_7874 registryWrapper) {
        super(GSON, "default_components");
        this.ops = registryWrapper.method_57093((DynamicOps)JsonOps.INSTANCE);
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"default_components", (String)"default_components");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, ComponentManipulation> newPrepared = HashMap.newHashMap(prepared.size());
        prepared.forEach((identifier, jsonElement) -> {
            ComponentManipulation component = (ComponentManipulation)ComponentManipulation.CODEC.parse(this.ops, jsonElement).getOrThrow();
            newPrepared.put((class_2960)identifier, component);
        });
        profiler.method_16065();
        profiler.method_15396("default_components");
        this.compute(newPrepared, manager, profiler);
        profiler.method_15407();
        profiler.method_16066();
    }

    protected void compute(Map<class_2960, ComponentManipulation> prepared, class_3300 manager, class_3695 profiler) {
        profiler.method_15396("data compute");
        HashMap<class_2960, ComponentManipulation> perItem = HashMap.newHashMap(0);
        HashMap global = HashMap.newHashMap(0);
        ArrayList tags = new ArrayList(0);
        profiler.method_15396("tag gathering");
        Optional<Map> perhapsTagMap = ((DataPackContentsAccessor)DefaultComponentData.INSTANCE.dataPackContents).getRegistryTagManager().method_40096().stream().filter(registryTags -> registryTags.comp_328().equals(class_7924.field_41197)).map(class_3505.class_6863::comp_329).findFirst();
        if (perhapsTagMap.isEmpty()) {
            throw new IllegalStateException("Failed to get tag data, unable modify components for the tag items");
        }
        Map tagMap = perhapsTagMap.get();
        profiler.method_15407();
        profiler.method_15396("entry sorting");
        ArrayList<Map.Entry<class_2960, ComponentManipulation>> entries = new ArrayList<Map.Entry<class_2960, ComponentManipulation>>(prepared.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        entries.sort(Map.Entry.comparingByValue());
        profiler.method_15407();
        profiler.method_15396("map building");
        for (Map.Entry entry : entries) {
            class_2960 identifier = (class_2960)entry.getKey();
            ComponentManipulation componentMap = (ComponentManipulation)entry.getValue();
            if (componentMap.target().isPresent()) {
                Either<WildcardEntry, class_3497> entryEither = componentMap.target().get();
                entryEither.map(wildcardEntry -> {
                    String id = wildcardEntry.modId();
                    if (global.containsKey(id)) {
                        throw new UnsupportedOperationException("Tried to register wildcard component override " + wildcardEntry.getWildcard() + " twice!");
                    }
                    global.compute(id, (ignored, componentManipulation) -> componentMap.merge((ComponentManipulation)componentManipulation));
                    return null;
                }, tagEntry -> {
                    TagEntryAccessor accessor = (TagEntryAccessor)tagEntry;
                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)accessor.getId());
                    if (accessor.isTag()) {
                        if (tags.contains(tagKey.comp_327())) {
                            throw new UnsupportedOperationException("Tried to register tag component override " + String.valueOf(tagKey.comp_327()) + " twice!");
                        }
                        profiler.method_15396("tag items");
                        Optional<Collection> optional = Optional.ofNullable((Collection)tagMap.get(tagKey.comp_327()));
                        if (optional.isPresent()) {
                            for (class_6880 entry : optional.get()) {
                                Optional entryKey = entry.method_40230();
                                entryKey.ifPresent(itemRegistryKey -> {
                                    perItem.compute(itemRegistryKey.method_29177(), (ignored, componentManipulation) -> componentMap.merge((ComponentManipulation)componentManipulation));
                                    tags.add(tagKey.comp_327());
                                });
                            }
                        } else {
                            LOGGER.warn("Failed to find tag {}, skipping", (Object)tagKey.comp_327());
                        }
                        profiler.method_15407();
                    } else {
                        perItem.compute(tagKey.comp_327(), (ignored, componentManipulation) -> componentMap.merge((ComponentManipulation)componentManipulation));
                    }
                    return null;
                });
                continue;
            }
            if (class_7923.field_41178.method_10250(identifier)) {
                perItem.compute(identifier, (ignored, componentManipulation) -> componentMap.merge((ComponentManipulation)componentManipulation));
                continue;
            }
            LOGGER.warn("Skipping invalid item {}", (Object)identifier);
        }
        profiler.method_15407();
        DefaultComponentData.INSTANCE.dataPackContents = null;
        DefaultComponentData.INSTANCE.itemComponents = Map.copyOf(perItem);
        DefaultComponentData.INSTANCE.modComponents = Map.copyOf(global);
        profiler.method_15396("applying");
        DefaultComponentData.INSTANCE.modifyItems();
        profiler.method_15407();
        profiler.method_15407();
    }

    public record ComponentManipulation(Optional<Either<WildcardEntry, class_3497>> target, Optional<Map<class_9331<?>, Object>> additions, Optional<List<class_9331<?>>> removals) implements Comparable<ComponentManipulation>
    {
        public static final ComponentManipulation EMPTY = new ComponentManipulation(Optional.empty(), Optional.empty(), Optional.empty());
        public static final Codec<class_9331<?>> COMPONENT_CODEC = Codec.STRING.flatXmap(id -> {
            class_2960 identifier = class_2960.method_12829((String)id);
            class_9331 componentType = (class_9331)class_7923.field_49658.method_10223(identifier);
            if (componentType == null) {
                return DataResult.error(() -> "No component with type: '" + String.valueOf(identifier) + "'");
            }
            return componentType.method_57877() ? DataResult.error(() -> "'" + String.valueOf(identifier) + "' is not a persistent component") : DataResult.success((Object)componentType);
        }, type -> {
            class_2960 identifier = class_7923.field_49658.method_10221(type);
            return identifier == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(type)) : DataResult.success((Object)identifier.toString());
        });
        public static final Codec<ComponentManipulation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(WildcardEntry.CODEC, (Codec)class_3497.field_39265).optionalFieldOf("target").forGetter(ComponentManipulation::target), (App)Codec.dispatchedMap(COMPONENT_CODEC, component -> component.method_57876()).optionalFieldOf("add").forGetter(ComponentManipulation::additions), (App)class_9331.field_49600.listOf().optionalFieldOf("remove").forGetter(ComponentManipulation::removals)).apply((Applicative)instance, ComponentManipulation::new));
        public static final class_9139<class_9129, ComponentManipulation> PACKET_CODEC = new class_9139<class_9129, ComponentManipulation>(){

            public void encode(class_9129 buf, ComponentManipulation payload) {
                Map<class_9331, Object> additions = payload.additions().orElse(Map.of());
                buf.method_53002(additions.size());
                additions.forEach((type, value) -> {
                    class_9331.field_49601.encode((Object)buf, type);
                    1.encodeComponent(buf, type, value);
                });
                List removals = payload.removals().orElse(List.of());
                buf.method_53002(removals.size());
                for (class_9331 removal : removals) {
                    class_9331.field_49601.encode((Object)buf, (Object)removal);
                }
            }

            public ComponentManipulation decode(class_9129 buf) {
                int additionCount = buf.readInt();
                HashMap<class_9331, Object> additions = HashMap.newHashMap(additionCount);
                for (int i = 0; i < additionCount; ++i) {
                    class_9331 type = (class_9331)class_9331.field_49601.decode((Object)buf);
                    Object value = type.method_57878().decode((Object)buf);
                    additions.put(type, value);
                }
                int removalCount = buf.readInt();
                ArrayList<class_9331> removals = new ArrayList<class_9331>(removalCount);
                for (int i = 0; i < removalCount; ++i) {
                    removals.add((class_9331)class_9331.field_49601.decode((Object)buf));
                }
                Optional<Object> add = additions.isEmpty() ? Optional.empty() : Optional.of(Map.copyOf(additions));
                Optional<Object> remove = removals.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(removals));
                return new ComponentManipulation(Optional.empty(), add, remove);
            }

            private static <T> void encodeComponent(class_9129 buf, class_9331<T> type, Object value) {
                type.method_57878().encode((Object)buf, value);
            }
        };

        public boolean isRemoved(class_9331<?> type) {
            return this.removals.isPresent() && this.removals.get().contains(type);
        }

        public <C extends class_9331<T>, T> void forEachAdded(BiConsumer<C, T> action) {
            if (this.additions().isPresent()) {
                this.additions().get().forEach((componentType, o) -> action.accept(componentType, o));
            }
        }

        public <C extends class_9331<?>> void forEachRemoved(Consumer<C> action) {
            if (this.removals().isPresent()) {
                this.removals().get().forEach(componentType -> action.accept(componentType));
            }
        }

        public ComponentManipulation merge(@Nullable ComponentManipulation other) {
            if (other == null) {
                return this;
            }
            Map newAdditions = other.additions().map(HashMap::new).orElse(HashMap.newHashMap(0));
            List newRemovals = other.removals().map(ArrayList::new).orElse(new ArrayList());
            this.additions.ifPresent(newAdditions::putAll);
            this.removals.ifPresent(newRemovals::addAll);
            return new ComponentManipulation(Optional.empty(), Optional.of(Map.copyOf(newAdditions)), Optional.of(List.copyOf(newRemovals)));
        }

        @Override
        public int compareTo(@NotNull ComponentManipulation o) {
            if (this.target().isEmpty() && o.target().isPresent()) {
                return 1;
            }
            if (this.target().isPresent() && o.target().isEmpty()) {
                return -1;
            }
            if (this.target().isPresent()) {
                if (this.target().get().left().isPresent() && o.target().get().right().isPresent()) {
                    return -1;
                }
                if (this.target().get().right().isPresent() && o.target().get().left().isPresent()) {
                    return 1;
                }
            }
            return 0;
        }
    }

    public record WildcardEntry(String modId) {
        public static final Codec<WildcardEntry> CODEC = Codec.STRING.comapFlatMap(wildcard -> {
            try {
                return DataResult.success((Object)WildcardEntry.splitOn(wildcard, ':'));
            }
            catch (class_151 e) {
                return DataResult.error(() -> "Not a valid wildcard: " + wildcard + " " + e.getMessage());
            }
        }, WildcardEntry::getWildcard).stable();

        public static WildcardEntry splitOn(String id, char delimiter) {
            int i = id.indexOf(delimiter);
            if (i > 0) {
                String modId = id.substring(0, i);
                String wildcard = id.substring(i + 1);
                if (wildcard.equals("*")) {
                    if (class_2960.method_20209((String)modId)) {
                        return new WildcardEntry(id.substring(0, i));
                    }
                    throw new class_151("Non [a-z0-9_.-] character in namespace of location: " + modId + ":" + wildcard);
                }
                throw new class_151("Non wildcard [*] character in path of location: " + modId + ":" + wildcard);
            }
            if (id.equals("*")) {
                return new WildcardEntry(id);
            }
            throw new class_151("Non wildcard [*] character in path of location: " + id);
        }

        public boolean isGeneric() {
            return this.modId.equals("*");
        }

        public String getWildcard() {
            return this.isGeneric() ? this.modId : this.modId + ":*";
        }
    }
}

