/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.defaultcomponents;

import com.awakenedredstone.defaultcomponents.data.DefaultComponentData;
import com.awakenedredstone.defaultcomponents.data.DefaultComponentLoader;
import com.awakenedredstone.defaultcomponents.network.DefaultComponentsPresentPayload;
import com.awakenedredstone.defaultcomponents.network.SyncPayload;
import com.awakenedredstone.defaultcomponents.util.ConcurrentWeakSet;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_8710;
import net.minecraft.class_9323;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponents
implements ModInitializer {
    public static final String MOD_ID = "default_components";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Default Components");
    public static final Set<GameProfile> MODDED_PLAYERS = new ConcurrentWeakSet<GameProfile>(0);

    public void onInitialize() {
        ResourceManagerHelper resourceManagerHelper = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        resourceManagerHelper.registerReloadListener(DefaultComponents.id(MOD_ID), DefaultComponentLoader::new);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (success) {
                try {
                    for (class_3222 player : server.method_3760().method_14571()) {
                        if (server.method_19466(player.method_7334())) continue;
                        ServerPlayNetworking.send((class_3222)player, (class_8710)DefaultComponentData.createSyncPayload());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to update default components", (Throwable)e);
                }
            }
        });
        PayloadTypeRegistry.playS2C().register(SyncPayload.ID, SyncPayload.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(DefaultComponentsPresentPayload.ID, DefaultComponentsPresentPayload.PACKET_CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (!server.method_19466(handler.method_32311().method_7334())) {
                sender.sendPacket((class_8710)DefaultComponentData.createSyncPayload());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(DefaultComponentsPresentPayload.ID, (payload, context) -> MODDED_PLAYERS.add(context.player().method_7334()));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"default-components").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Can not get handstack of a non player executor"));
                return 0;
            }
            class_5455.class_6890 registryManager = source.method_9211().method_30611();
            class_9323 components = source.method_44023().method_6047().method_7909().method_57347();
            LOGGER.info("{}", (Object)components);
            class_2520 nbtElement = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)registryManager.method_57093((DynamicOps)class_2509.field_11560), (Object)components).getOrThrow();
            source.method_9226(() -> class_2512.method_32270((class_2520)nbtElement), false);
            return 0;
        })).then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_2290 itemArgument = class_2287.method_9777((CommandContext)context, (String)"item");
            class_5455.class_6890 registryManager = source.method_9211().method_30611();
            class_9323 components = itemArgument.method_9785().method_57347();
            LOGGER.info("{}", (Object)components);
            class_2520 nbtElement = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)registryManager.method_57093((DynamicOps)class_2509.field_11560), (Object)components).getOrThrow();
            source.method_9226(() -> class_2512.method_32270((class_2520)nbtElement), false);
            return 0;
        }))));
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

