/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

public class RecipeCache {
    private final Entry<? extends class_9695, ? extends class_1860<?>>[] entries;
    private WeakReference<class_1863> cachedRecipeManager = new WeakReference<Object>(null);

    public RecipeCache(int size) {
        this.entries = new Entry[size];
    }

    public <I extends class_9695, T extends class_1860<I>> List<class_8786<T>> get(class_1937 level, class_3956<T> recipeType, I recipeInput) {
        if (recipeInput.method_59987()) {
            return List.of();
        }
        this.validateRecipeManager(level);
        for (int i = 0; i < this.entries.length; ++i) {
            Entry<class_9695, class_1860<?>> entry = this.entries[i];
            if (entry == null || !entry.matches(recipeInput)) continue;
            this.moveEntryToFront(i);
            return entry.recipes;
        }
        return this.compute(level, recipeType, recipeInput);
    }

    private void validateRecipeManager(class_1937 level) {
        class_1863 recipeManager = level.method_8433();
        if (recipeManager != this.cachedRecipeManager.get()) {
            this.cachedRecipeManager = new WeakReference<class_1863>(recipeManager);
            Arrays.fill(this.entries, null);
        }
    }

    private <I extends class_9695, T extends class_1860<I>> List<class_8786<T>> compute(class_1937 level, class_3956<T> recipeType, I recipeInput) {
        List list = level.method_8433().method_17877(recipeType, recipeInput, level);
        this.insert(recipeInput, list);
        return list;
    }

    private void moveEntryToFront(int index) {
        if (index > 0) {
            Entry<class_9695, class_1860<?>> entry = this.entries[index];
            System.arraycopy(this.entries, 0, this.entries, 1, index);
            this.entries[0] = entry;
        }
    }

    private <I extends class_9695, T extends class_1860<I>> void insert(I recipeInput, List<class_8786<T>> recipes) {
        Entry entry;
        class_2371 list = class_2371.method_10213((int)recipeInput.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            list.set(i, (Object)recipeInput.method_59984(i).method_46651(1));
        }
        System.arraycopy(this.entries, 0, this.entries, 1, this.entries.length - 1);
        if (recipeInput instanceof class_9694) {
            class_9694 craftingInput = (class_9694)recipeInput;
            entry = new CraftingEntry((class_2371<class_1799>)list, craftingInput.method_59991(), craftingInput.method_59992(), recipeInput.method_59983(), recipes);
        } else {
            entry = new Entry((class_2371<class_1799>)list, recipeInput.method_59983(), recipes);
        }
        this.entries[0] = entry;
    }

    static class Entry<I extends class_9695, T extends class_1860<I>> {
        private final class_2371<class_1799> key;
        private final int size;
        private final List<class_8786<T>> recipes;

        public Entry(class_2371<class_1799> list, int size, List<class_8786<T>> recipes) {
            this.key = list;
            this.size = size;
            this.recipes = recipes;
        }

        public boolean matches(class_9695 recipeInput) {
            if (this.size == recipeInput.method_59983()) {
                for (int i = 0; i < this.key.size(); ++i) {
                    if (class_1799.method_31577((class_1799)((class_1799)this.key.get(i)), (class_1799)recipeInput.method_59984(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    static class CraftingEntry<I extends class_9695, T extends class_1860<I>>
    extends Entry<I, T> {
        private final int width;
        private final int height;

        public CraftingEntry(class_2371<class_1799> list, int width, int height, int size, List<class_8786<T>> recipes) {
            super(list, size, recipes);
            this.width = width;
            this.height = height;
        }

        @Override
        public boolean matches(class_9695 recipeInput) {
            class_9694 craftingInput;
            if (recipeInput instanceof class_9694 && (craftingInput = (class_9694)recipeInput).method_59991() == this.width && craftingInput.method_59992() == this.height) {
                return super.matches(recipeInput);
            }
            return false;
        }
    }
}

