/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.network.MarketCategoriesMessage;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_8710;
import net.minecraft.class_8824;

public class MarketCategoryRegistry {
    private static final Codec<MarketCategory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_51397.fieldOf("icon").forGetter(MarketCategory::iconStack), (App)class_5699.field_33442.fieldOf("sortIndex").orElse((Object)0).forGetter(MarketCategory::sortIndex), (App)class_8824.field_46597.fieldOf("tooltip").forGetter(MarketCategory::tooltip)).apply((Applicative)instance, MarketCategoryImpl::new));
    public static final MarketCategoryRegistry INSTANCE = new MarketCategoryRegistry();
    private final Map<class_2960, MarketCategory> categories = new HashMap<class_2960, MarketCategory>();

    public void register(class_2960 id, MarketCategory category) {
        this.categories.put(id, category);
    }

    public Map<class_2960, MarketCategory> getAll() {
        return MarketCategoryRegistry.INSTANCE.categories;
    }

    public Optional<MarketCategory> get(class_2960 id) {
        return Optional.ofNullable(MarketCategoryRegistry.INSTANCE.categories.get(id));
    }

    public void clear() {
        this.categories.clear();
    }

    public void loadAdditionally(class_2960 id, BufferedReader reader) {
        Gson gson = new Gson();
        JsonElement json = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        MarketCategory category = (MarketCategory)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        this.register(id, category);
    }

    public void load(Map<class_2960, MarketCategory> categories) {
        this.categories.clear();
        categories.forEach(this::register);
    }

    public void onLogin(PlayerLoginEvent event) {
        Balm.getNetworking().sendTo((class_1657)event.getPlayer(), (class_8710)new MarketCategoriesMessage(this.categories));
    }
}

