/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.entity;

import java.util.Locale;
import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.block.entity.MarketBlockEntity;
import net.blay09.mods.farmingforblockheads.entity.MerchantGoal;
import net.blay09.mods.farmingforblockheads.sound.ModSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class MerchantEntity
extends class_1314 {
    private static final Random rand = new Random();
    private class_2338 marketPos;
    private class_2350 facing;
    private boolean spawnAnimationStarted;
    private boolean spawnDone;
    private SpawnAnimationType spawnAnimation = SpawnAnimationType.MAGIC;
    private class_2338 marketEntityPos;
    private int diggingAnimation;
    private class_2680 diggingBlockState;
    private class_2960 textureLocation;

    public MerchantEntity(class_1299<MerchantEntity> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1338((class_1314)this, class_1642.class, 8.0f, 0.6, 0.6));
        this.field_6201.method_6277(5, (class_1352)new MerchantGoal(this, 0.6));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1642.method_26940().method_26868(class_5134.field_23719, 0.5);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        MarketBlockEntity market = this.getMarketTileEntity();
        if (market != null) {
            Balm.getNetworking().openGui(player, (class_3908)market);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.marketPos != null) {
            compound.method_10544("MarketPos", this.marketPos.method_10063());
        }
        if (this.facing != null) {
            compound.method_10567("Facing", (byte)this.facing.method_10146());
        }
        compound.method_10556("SpawnDone", this.spawnDone);
        compound.method_10567("SpawnAnimation", (byte)this.spawnAnimation.ordinal());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (!this.method_16914()) {
            String merchantName = FarmingForBlockheadsConfig.getActive().getRandomMerchantName(rand);
            this.method_5665((class_2561)class_2561.method_43470((String)merchantName));
        }
        if (compound.method_10545("MarketPos")) {
            this.setMarket(class_2338.method_10092((long)compound.method_10537("MarketPos")), class_2350.method_10143((int)compound.method_10571("Facing")));
        }
        this.spawnDone = compound.method_10577("SpawnDone");
        this.spawnAnimation = SpawnAnimationType.values()[compound.method_10571("SpawnAnimation")];
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public boolean method_17326() {
        return true;
    }

    protected class_3414 method_5994() {
        return null;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15139;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15225;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 level = this.method_37908();
        if (!level.field_9236 && this.field_6012 % 20 == 0 && !this.isMarketValid()) {
            level.method_8421((class_1297)this, (byte)12);
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (!this.spawnDone && !this.spawnAnimationStarted) {
            this.spawnAnimationStarted = true;
            switch (this.spawnAnimation.ordinal()) {
                case 2: {
                    level.method_8421((class_1297)this, (byte)13);
                    break;
                }
                case 1: {
                    level.method_8421((class_1297)this, (byte)14);
                    break;
                }
                case 0: {
                    level.method_8421((class_1297)this, (byte)15);
                }
            }
        }
        if (this.diggingAnimation > 0) {
            --this.diggingAnimation;
            double posX = this.method_23317();
            double posY = this.method_23318();
            double posZ = this.method_23321();
            for (int i = 0; i < 4; ++i) {
                class_2680 diggingState = this.diggingBlockState != null ? this.diggingBlockState : class_2246.field_10566.method_9564();
                level.method_8406((class_2394)new class_2388(class_2398.field_11217, diggingState), posX, posY, posZ, Math.random() * 2.0 - 1.0, Math.random() * 4.0, Math.random() * 2.0 - 1.0);
                level.method_8406((class_2394)new class_2388(class_2398.field_11206, diggingState), posX, posY, posZ, (Math.random() - 0.5) * 0.5, Math.random() * 0.5, (Math.random() - 0.5) * 0.5);
            }
            if (this.diggingAnimation % 2 == 0) {
                level.method_8486(posX, posY, posZ, class_2498.field_11529.method_10596(), class_3419.field_15245, 0.2f, (float)(Math.random() + 0.5), false);
            }
        }
    }

    public void method_5711(byte id) {
        class_1937 level = this.method_37908();
        if (id == 12) {
            this.disappear();
        } else if (id == 13) {
            this.diggingBlockState = level.method_8320(this.method_24515().method_10074());
            this.diggingAnimation = 60;
        } else if (id == 14) {
            class_2338 pos = level.method_8598(class_2902.class_2903.field_13197, this.method_24515());
            level.method_8486((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), (class_3414)ModSounds.falling.get(), class_3419.field_15254, 0.2f, 1.0f, false);
        } else if (id == 15) {
            double posX = this.method_23317();
            double posY = this.method_23318();
            double posZ = this.method_23321();
            level.method_8486(posX + 0.5, posY + 1.0, posZ + 0.5, class_3417.field_15013, class_3419.field_15254, 0.2f, 1.0f, false);
            for (int i = 0; i < 50; ++i) {
                level.method_8406((class_2394)class_2398.field_11248, posX + 0.5, posY + 1.0, posZ + 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            }
            level.method_8406((class_2394)class_2398.field_11236, posX + 0.5, posY + 1.0, posZ + 0.5, 0.0, 0.0, 0.0);
        } else {
            super.method_5711(id);
        }
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        if (!this.spawnDone && damageSource == this.method_37908().method_48963().method_48827()) {
            double posX = this.method_23317();
            double posY = this.method_23318();
            double posZ = this.method_23321();
            this.method_37908().method_8486(posX, posY, posZ, this.method_6011(damageSource), class_3419.field_15254, 1.0f, 2.0f, false);
            this.spawnDone = true;
            return;
        }
        super.method_6074(damageSource, damageAmount);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData) {
        if (Math.random() < 0.001) {
            this.method_5665((class_2561)class_2561.method_43470((String)(Math.random() <= 0.5 ? "Pam" : "Blay")));
        } else {
            String merchantName = FarmingForBlockheadsConfig.getActive().getRandomMerchantName(rand);
            this.method_5665((class_2561)class_2561.method_43470((String)merchantName));
        }
        return super.method_5943(level, difficulty, mobSpawnType, spawnGroupData);
    }

    public boolean method_5931() {
        return false;
    }

    public boolean method_6109() {
        return FarmingForBlockheadsConfig.getActive().treatMerchantsLikeBabies;
    }

    public void setMarket(class_2338 marketPos, class_2350 facing) {
        this.marketPos = marketPos;
        this.marketEntityPos = marketPos.method_10093(facing.method_10153());
        this.facing = facing;
    }

    @Nullable
    public class_2338 getMarketEntityPosition() {
        return this.marketEntityPos;
    }

    public boolean isAtMarket() {
        return this.marketEntityPos != null && this.method_5707(class_243.method_24953((class_2382)this.marketEntityPos.method_10093(this.facing.method_10153()))) <= 1.0;
    }

    @Nullable
    private MarketBlockEntity getMarketTileEntity() {
        if (this.marketPos == null) {
            return null;
        }
        class_2586 tileEntity = this.method_37908().method_8321(this.marketPos);
        if (tileEntity instanceof MarketBlockEntity) {
            MarketBlockEntity market = (MarketBlockEntity)tileEntity;
            return market;
        }
        return null;
    }

    private boolean isMarketValid() {
        return this.marketPos != null && this.method_37908().method_8320(this.marketPos).method_26204() == ModBlocks.market;
    }

    public void setToFacingAngle() {
        float facingAngle = this.facing.method_10144();
        this.method_5710(facingAngle, 0.0f);
        this.method_5847(facingAngle);
        this.method_5636(facingAngle);
    }

    private void disappear() {
        double posX = this.method_23317();
        double posY = this.method_23318();
        double posZ = this.method_23321();
        class_1937 level = this.method_37908();
        level.method_8486(posX, posY, posZ, class_3417.field_15013, class_3419.field_15254, 1.0f, 1.0f, false);
        for (int i = 0; i < 50; ++i) {
            level.method_8406((class_2394)class_2398.field_11248, posX, posY + 1.0, posZ, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
        }
        level.method_8406((class_2394)class_2398.field_11236, posX, posY + 1.0, posZ, 0.0, 0.0, 0.0);
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public void setSpawnAnimation(SpawnAnimationType spawnAnimation) {
        this.spawnAnimation = spawnAnimation;
    }

    public int getDiggingAnimation() {
        return this.diggingAnimation;
    }

    public void method_5665(@Nullable class_2561 component) {
        super.method_5665(component);
        this.textureLocation = null;
    }

    @Nullable
    public class_2960 getTextureLocation() {
        class_2561 customName = this.method_5797();
        if (this.textureLocation == null && customName != null) {
            String normalizedName = customName.getString();
            normalizedName = normalizedName.replaceAll("[^A-Za-z0-9]", "_");
            normalizedName = normalizedName.toLowerCase(Locale.ENGLISH);
            this.textureLocation = class_2960.method_60655((String)"farmingforblockheads", (String)("textures/entity/merchant_" + normalizedName + ".png"));
        } else if (this.textureLocation != null && customName == null) {
            this.textureLocation = null;
        }
        return this.textureLocation;
    }

    public static enum SpawnAnimationType {
        MAGIC,
        FALLING,
        DIGGING;

    }
}

