/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.EnchantCalcConf;
import io.github.flemmli97.improvedmobs.config.EquipmentList;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9334;
import virtuoel.pehkui.api.ScaleTypes;

public class Utils {
    public static final Function<class_1297, class_2960> ENTITY_ID = e -> class_7923.field_41177.method_10221((Object)e.method_5864());
    public static final class_2960 ATTRIBUTE_ID = ImprovedMobs.modRes("attribute_modifiers");

    public static <T> boolean isInList(T entry, List<? extends String> list, boolean reverse, Function<T, class_2960> mapper) {
        if (reverse) {
            return !Utils.isInList(entry, list, false, mapper);
        }
        class_2960 res = mapper.apply(entry);
        return list.contains(res.method_12832()) || list.contains(res.toString());
    }

    public static boolean canHarvest(class_2680 block, class_1799 item) {
        if (Config.CommonConfig.ignoreHarvestLevel) {
            return true;
        }
        return item.method_7951(block) || !block.method_29291();
    }

    public static void equipArmor(class_1308 living, float difficulty) {
        if (Config.CommonConfig.baseEquipChance != 0.0f) {
            float time = difficulty * Config.CommonConfig.diffEquipAdd * 0.01f;
            if (living.method_59922().method_43057() < Config.CommonConfig.baseEquipChance + time) {
                for (class_1304 slot : class_1304.values()) {
                    boolean shouldAdd;
                    if (slot.method_5925() == class_1304.class_1305.field_6177) continue;
                    boolean bl = shouldAdd = slot == class_1304.field_6169 || Config.CommonConfig.baseEquipChanceAdd != 0.0f && living.method_59922().method_43057() < Config.CommonConfig.baseEquipChanceAdd + time;
                    if (!shouldAdd || !living.method_6118(slot).method_7960()) continue;
                    class_1799 equip = EquipmentList.getEquip(living, slot, difficulty);
                    if (living.method_59922().method_43057() < Config.CommonConfig.randomTrimChance) {
                        class_5455.class_6890 registryAccess = living.method_5682().method_30611();
                        Optional trim = registryAccess.method_33310(class_7924.field_42083).flatMap(r -> r.method_10240(living.method_59922()));
                        Optional pattern = living.method_5682().method_30611().method_33310(class_7924.field_42082).flatMap(r -> r.method_10240(living.method_59922()));
                        if (trim.isPresent() && pattern.isPresent()) {
                            equip.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)trim.get(), (class_6880)pattern.get()));
                        }
                    }
                    if (equip.method_7960()) continue;
                    if (!Config.CommonConfig.shouldDropEquip) {
                        living.method_5946(slot, -100.0f);
                    }
                    living.method_5673(slot, equip);
                }
            }
        }
    }

    public static void equipHeld(class_1308 living, float difficulty) {
        class_1799 stack;
        float add = difficulty * Config.CommonConfig.diffWeaponChance * 0.01f;
        if (Config.CommonConfig.baseWeaponChance != 0.0f && living.method_59922().method_43057() < Config.CommonConfig.baseWeaponChance + add && living.method_6047().method_7960()) {
            stack = EquipmentList.getEquip(living, class_1304.field_6173, difficulty);
            if (!Config.CommonConfig.shouldDropEquip) {
                living.method_5946(class_1304.field_6173, -100.0f);
            }
            living.method_5673(class_1304.field_6173, stack);
        }
        if (living instanceof class_5418) {
            return;
        }
        add = difficulty * Config.CommonConfig.diffItemChanceAdd * 0.01f;
        if (Config.CommonConfig.baseItemChance != 0.0f && living.method_59922().method_43057() < Config.CommonConfig.baseItemChance + add && living.method_6079().method_7960()) {
            stack = EquipmentList.getEquip(living, class_1304.field_6171, difficulty);
            if (!Config.CommonConfig.shouldDropEquip) {
                living.method_5946(class_1304.field_6171, -100.0f);
            }
            living.method_5673(class_1304.field_6171, stack);
        }
    }

    public static void enchantGear(class_1308 living, float difficulty) {
        EnchantCalcConf.Value val = Config.CommonConfig.enchantCalc.get(difficulty);
        if (val.max == 0) {
            return;
        }
        for (class_1304 entityequipmentslot : class_1304.values()) {
            class_1799 itemstack = living.method_6118(entityequipmentslot);
            if (itemstack.method_7942() || itemstack.method_7960() || !(living.method_59922().method_43057() < Config.CommonConfig.baseEnchantChance + difficulty * Config.CommonConfig.diffEnchantAdd * 0.01f)) continue;
            class_5455 registryAccess = living.method_56673();
            class_1890.method_8233((class_5819)living.method_59922(), (class_1799)itemstack, (int)class_3532.method_15395((class_5819)living.method_59922(), (int)val.min, (int)val.max), registryAccess.method_30530(class_7924.field_41265).method_40270().filter(r -> Config.CommonConfig.enchantWhitelist == Config.CommonConfig.enchantBlacklist.contains(r.method_40237().method_29177().toString())).map(r -> r));
        }
    }

    public static float getBlockStrength(class_1308 entityLiving, class_2680 state, class_1937 world, class_2338 pos) {
        float hardness = world.method_8320(pos).method_26214((class_1922)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        class_1799 main = entityLiving.method_6047();
        class_1799 off = entityLiving.method_6079();
        if (Utils.canHarvest(state, main)) {
            float offSpeed;
            float speed = Utils.getBreakSpeed(entityLiving, main, state);
            if (Utils.canHarvest(state, off) && (offSpeed = Utils.getBreakSpeed(entityLiving, off, state)) > speed) {
                speed = offSpeed;
            }
            return speed / hardness / 30.0f;
        }
        if (Utils.canHarvest(state, off)) {
            return Utils.getBreakSpeed(entityLiving, off, state) / hardness / 30.0f;
        }
        return Utils.getBreakSpeed(entityLiving, main, state) / hardness / 100.0f;
    }

    public static float getBreakSpeed(class_1308 entity, class_1799 stack, class_2680 state) {
        float f = stack.method_7924(state);
        if (f > 1.0f && entity.method_6127().method_45331(class_5134.field_51581)) {
            f += (float)entity.method_45325(class_5134.field_51581);
        }
        if (class_1292.method_5576((class_1309)entity)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)entity) + 1) * 0.2f;
        }
        if (entity.method_6059(class_1294.field_5901)) {
            switch (entity.method_6112(class_1294.field_5901).method_5578()) {
                case 0: {
                    f *= 0.3f;
                    break;
                }
                case 1: {
                    f *= 0.09f;
                    break;
                }
                case 2: {
                    f *= 0.0027f;
                    break;
                }
                default: {
                    f *= 8.1E-4f;
                }
            }
        }
        if (entity.method_5777(class_3486.field_15517) && entity.method_5996(class_5134.field_51576) != null) {
            f *= (float)entity.method_5996(class_5134.field_51576).method_6194();
        }
        if (!entity.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    public static void modifyAttr(class_1308 living, class_6880<class_1320> att, double value, double max, float difficulty, boolean multiply) {
        class_1324 inst = living.method_5996(att);
        if (inst == null || inst.method_6199(ATTRIBUTE_ID) != null) {
            return;
        }
        double oldValue = inst.method_6201();
        value *= (double)difficulty;
        if (multiply) {
            value = max <= 0.0 ? value : Math.min(value, max - 1.0);
            value = oldValue * value;
            if (att == class_5134.field_23716) {
                value = Config.CommonConfig.roundHP > 0.0 ? MathUtils.roundTo((double)value, (double)Config.CommonConfig.roundHP) : value;
            }
        } else {
            value = max <= 0.0 ? value : Math.min(value, max);
        }
        inst.method_26837(new class_1322(ATTRIBUTE_ID, value, class_1322.class_1323.field_6328));
    }

    public static void modifyScale(class_1308 living, float min, float max) {
        Random random = new Random();
        ScaleTypes.BASE.getScaleData((class_1297)living).setScaleTickDelay(20);
        ScaleTypes.BASE.getScaleData((class_1297)living).setTargetScale(random.nextFloat(min, max));
    }
}

