/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.CustomBlockCollision;
import io.github.flemmli97.improvedmobs.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_3726;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class PathFindingUtils {
    public static class_9 notFloatingNodeModifier(class_1308 mob, class_1922 getter, int x, int y, int z, int stepModifier, class_2350 dir, class_7 standingType, Function<class_2338, class_7> func, Function<class_238, Boolean> collision, Function<class_238, Boolean> collisionDefault, Function<class_2338, class_9> nodeGetter, Object2BooleanMap<Long> breakableMap) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        class_2680 state = getter.method_8320((class_2338)pos);
        if (breakableMap.computeIfAbsent((Object)class_2338.method_10064((int)x, (int)y, (int)z), p -> PathFindingUtils.canBreak(state, (class_2338)pos, mob))) {
            class_238 aabb = PathFindingUtils.createAABBForPos(getter, x, y, z, (double)mob.method_17681() / 2.0, mob.method_17682());
            if (stepModifier > 0 && !collisionDefault.apply(aabb.method_1012((double)(-dir.method_10148()), 0.0, (double)(-dir.method_10165()))).booleanValue()) {
                class_9 node = nodeGetter.apply((class_2338)pos.method_10103(x, y + 1, z));
                node.field_41 = class_7.field_12;
                node.field_43 = Math.max(0.0f, node.field_43);
                return node;
            }
            if (collision.apply(aabb.method_989(0.0, -1.0, 0.0)).booleanValue()) {
                return null;
            }
            class_9 node = nodeGetter.apply((class_2338)pos);
            node.field_41 = class_7.field_12;
            node.field_43 = Math.max(0.0f, node.field_43);
            class_7 below = func.apply((class_2338)pos.method_10103(x, y - 1, z));
            if (below == class_7.field_7) {
                int fall = 0;
                class_2338.class_2339 lower = new class_2338.class_2339(x, y, z);
                while (below == class_7.field_7) {
                    if (--y < mob.method_37908().method_31607()) {
                        return null;
                    }
                    if (fall++ >= mob.method_5850()) {
                        class_9 node2 = nodeGetter.apply((class_2338)lower.method_10103(x, y, z));
                        node2.field_41 = class_7.field_22;
                        node2.field_43 = -1.0f;
                        return node2;
                    }
                    below = func.apply((class_2338)lower.method_10103(x, y, z));
                    float mobPathingMalus = mob.method_5944(below);
                    if (below != class_7.field_7 && mobPathingMalus >= 0.0f) {
                        node = nodeGetter.apply((class_2338)lower.method_10103(x, y, z));
                        node.field_41 = below;
                        node.field_43 = Math.max(node.field_43, mobPathingMalus);
                        break;
                    }
                    if (!(mobPathingMalus < 0.0f)) continue;
                    return null;
                }
            }
            node.field_43 += 6.0f;
            return node;
        }
        if (stepModifier > 0) {
            class_2680 above = getter.method_8320((class_2338)pos.method_10103(x, y + 1, z));
            if (!breakableMap.computeIfAbsent((Object)class_2338.method_10064((int)x, (int)(y + 1), (int)z), p -> PathFindingUtils.canBreak(above, (class_2338)pos, mob))) {
                return null;
            }
            class_238 aabb = PathFindingUtils.createAABBForPos(getter, x, y + 1, z, (double)mob.method_17681() / 2.0, mob.method_17682());
            if (collision.apply(aabb).booleanValue()) {
                return null;
            }
            class_9 node = nodeGetter.apply((class_2338)pos.method_10103(x, y, z));
            node.field_43 = Math.max(0.0f, node.field_43);
            node.field_41 = class_7.field_12;
            node.field_43 += 6.0f;
            return node;
        }
        return null;
    }

    public static class_9 floatingNodeModifier(class_1308 mob, class_1922 getter, int x, int y, int z, Function<class_238, Boolean> collision, Function<class_2338, class_9> nodeGetter) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        class_2680 state = getter.method_8320((class_2338)pos);
        if (PathFindingUtils.canBreak(state, (class_2338)pos, mob)) {
            class_238 aabb = PathFindingUtils.createAABBForPos(getter, x, y, z, (double)mob.method_17681() / 2.0, mob.method_17682());
            if (collision.apply(aabb).booleanValue()) {
                return null;
            }
            class_9 node = nodeGetter.apply((class_2338)pos);
            node.field_41 = class_7.field_12;
            node.field_43 += 2.0f;
            return node;
        }
        return null;
    }

    public static boolean noCollision(class_1941 level, class_1297 entity, class_238 aABB) {
        Iterable shapes = () -> new CustomBlockCollision(level, entity, aABB);
        for (class_265 voxelShape : shapes) {
            if (voxelShape.method_1110()) continue;
            return false;
        }
        if (entity != null) {
            class_2784 worldBorder = level.method_8621();
            class_265 voxelShape2 = worldBorder.method_39459(entity, aABB) ? worldBorder.method_17903() : null;
            return voxelShape2 == null || !class_259.method_1074((class_265)voxelShape2, (class_265)class_259.method_1078((class_238)aABB), (class_247)class_247.field_16896);
        }
        return true;
    }

    public static class_238 createAABBForPos(class_1922 getter, int x, int y, int z, double widthHalf, double height) {
        double floor1 = class_14.method_60((class_1922)getter, (class_2338)new class_2338(x, y + 1, z));
        return new class_238((double)x - widthHalf + 0.5, floor1 + 0.001, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, height + floor1, (double)z + widthHalf + 0.5);
    }

    public static int createLadderNodeFor(int nodeID, class_9[] nodes, class_9 origin, Function<class_2338, class_9> nodeGetter, class_1922 getter, class_1308 mob) {
        class_9 node;
        class_2338.class_2339 pos = new class_2338.class_2339(origin.field_40, origin.field_39 + 1, origin.field_38);
        if (CrossPlatformStuff.INSTANCE.isLadder(getter.method_8320((class_2338)pos), (class_1309)mob, (class_2338)pos) && (node = nodeGetter.apply((class_2338)pos)) != null && !node.field_42) {
            node.field_43 = 0.0f;
            node.field_41 = class_7.field_12;
            if (nodeID + 1 < nodes.length) {
                nodes[nodeID++] = node;
            }
        }
        pos.method_10103(pos.method_10263(), pos.method_10264() - 2, pos.method_10260());
        if (CrossPlatformStuff.INSTANCE.isLadder(getter.method_8320((class_2338)pos), (class_1309)mob, (class_2338)pos) && (node = nodeGetter.apply((class_2338)pos)) != null && !node.field_42) {
            node.field_43 = 0.0f;
            node.field_41 = class_7.field_12;
            if (nodeID + 1 < nodes.length) {
                nodes[nodeID++] = node;
            }
        }
        return nodeID;
    }

    public static boolean canBreak(class_2338 pos, class_1308 entity) {
        return PathFindingUtils.canBreak(entity.method_37908().method_8320(pos), pos, entity);
    }

    private static boolean canBreak(class_2680 state, class_2338 pos, class_1308 entity) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (class_1922)entity.method_37908(), (class_1297)entity, class_3726.method_16195((class_1297)entity)) && (Utils.canHarvest(state, entity.method_6047()) || Utils.canHarvest(state, entity.method_6079()));
    }
}

