/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.improvedmobs.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BlockRestorationData
extends class_18 {
    private static final String ID = "ImprovedMobsRestoration";
    private static final class_18.class_8645<BlockRestorationData> FACTORY = new class_18.class_8645(BlockRestorationData::new, BlockRestorationData::new, class_4284.field_19212);
    private final Long2ObjectMap<Long2ObjectMap<SavedBlock>> toRestore = new Long2ObjectOpenHashMap();

    public BlockRestorationData() {
    }

    private BlockRestorationData(class_2487 tag, class_7225.class_7874 provider) {
        this.load(tag);
    }

    public static BlockRestorationData get(class_3218 level) {
        return (BlockRestorationData)level.method_17983().method_17924(FACTORY, ID);
    }

    public void restore(class_3218 level, class_2680 state, class_2338 pos, @Nullable class_1297 entity) {
        Long2ObjectMap chunk = (Long2ObjectMap)this.toRestore.computeIfAbsent(class_1923.method_37232((class_2338)pos), o -> new Long2ObjectOpenHashMap());
        SavedBlock current = (SavedBlock)chunk.get(pos.method_10063());
        if (current != null) {
            current.toDrop.forEach(stack -> class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack));
        }
        class_2586 blockEntity = state.method_31709() ? level.method_8321(pos) : null;
        List drops = class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)entity, (class_1799)class_1799.field_8037);
        chunk.put(pos.method_10063(), (Object)new SavedBlock(state, level.method_8510(), drops));
        this.method_80();
    }

    public void tick(class_3218 level) {
        LongArraySet toRemove = new LongArraySet();
        long time = level.method_8510();
        boolean particle = time % 5L == 0L;
        this.toRestore.forEach((arg_0, arg_1) -> this.lambda$tick$4(level, time, particle, (LongSet)toRemove, arg_0, arg_1));
        toRemove.forEach(arg_0 -> this.toRestore.remove(arg_0));
    }

    public void load(class_2487 data) {
        data.method_10541().forEach(chunk -> {
            Long2ObjectOpenHashMap blocksMap = new Long2ObjectOpenHashMap();
            class_2499 blocks = data.method_10554(chunk, 10);
            blocks.forEach(arg_0 -> BlockRestorationData.lambda$load$6((Long2ObjectMap)blocksMap, arg_0));
            this.toRestore.put(Long.parseLong(chunk), (Object)blocksMap);
        });
    }

    public class_2487 method_75(class_2487 data, class_7225.class_7874 provider) {
        this.toRestore.forEach((chunk, blocks) -> {
            class_2499 list = new class_2499();
            blocks.forEach((pos, d) -> {
                class_2487 blockSave = new class_2487();
                blockSave.method_10544("Pos", pos.longValue());
                blockSave.method_10566("State", (class_2520)class_2680.field_24734.encodeStart((DynamicOps)class_2509.field_11560, (Object)d.state).getOrThrow());
                blockSave.method_10544("Time", d.time);
                class_2499 stacks = new class_2499();
                d.toDrop.forEach(s -> stacks.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, s).getOrThrow())));
                blockSave.method_10566("Drops", (class_2520)stacks);
                list.add((Object)blockSave);
            });
            data.method_10566(String.valueOf(chunk), (class_2520)list);
        });
        return data;
    }

    private static /* synthetic */ void lambda$load$6(Long2ObjectMap blocksMap, class_2520 t) {
        class_2487 blockSave = (class_2487)t;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        blockSave.method_10554("Drops", 10).forEach(st -> stacks.add((class_1799)class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, st).getOrThrow()));
        blocksMap.put(blockSave.method_10537("Pos"), (Object)new SavedBlock((class_2680)class_2680.field_24734.parse((DynamicOps)class_2509.field_11560, (Object)blockSave.method_10580("State")).getOrThrow(), blockSave.method_10537("Time"), stacks));
    }

    private /* synthetic */ void lambda$tick$4(class_3218 level, long time, boolean particle, LongSet toRemove, Long chunk, Long2ObjectMap data) {
        class_1923 chunkPos = new class_1923(chunk.longValue());
        if (level.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            LongArraySet toRemoveBlocks = new LongArraySet();
            class_2818 levelChunk = level.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            data.forEach((arg_0, arg_1) -> BlockRestorationData.lambda$tick$3(levelChunk, time, level, (LongSet)toRemoveBlocks, particle, arg_0, arg_1));
            toRemoveBlocks.forEach(arg_0 -> ((Long2ObjectMap)data).remove(arg_0));
            if (data.isEmpty()) {
                toRemove.add(chunk.longValue());
            }
            if (!toRemoveBlocks.isEmpty()) {
                this.method_80();
            }
        }
    }

    private static /* synthetic */ void lambda$tick$3(class_2818 levelChunk, long time, class_3218 level, LongSet toRemoveBlocks, boolean particle, Long packedPos, SavedBlock replace) {
        class_2338 pos = class_2338.method_10092((long)packedPos);
        class_2680 current = levelChunk.method_8320(pos);
        if (current.method_26204() == class_2246.field_10124) {
            if (Math.abs(time - replace.time) > (long)Config.CommonConfig.restoreDelay) {
                level.method_8652(pos, replace.state, 3);
                toRemoveBlocks.add(packedPos.longValue());
            } else if (particle) {
                level.method_14199((class_2394)class_2390.field_11188, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            }
        } else {
            replace.toDrop.forEach(stack -> class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack));
            toRemoveBlocks.add(packedPos.longValue());
        }
    }

    public record SavedBlock(class_2680 state, long time, List<class_1799> toDrop) {
    }
}

