/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.mixin.pathfinding;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.mixinhelper.INodeBreakable;
import io.github.flemmli97.improvedmobs.utils.PathFindingUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9;
import net.minecraft.class_9316;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_14.class})
public abstract class GroundNodeMixin
extends class_8 {
    @Unique
    private final Object2BooleanMap<class_238> collisionBreakableCache = new Object2BooleanOpenHashMap();
    @Unique
    private final Object2BooleanMap<Long> breakableMap = new Object2BooleanOpenHashMap();
    @Shadow
    private Object2BooleanMap<class_238> field_25191;

    @ModifyVariable(method={"getNeighbors"}, at=@At(value="RETURN"), ordinal=0)
    private int addAdditionalPoints(int nodeCounts, class_9[] points, class_9 origin) {
        if (((INodeBreakable)((Object)this)).canClimbLadder()) {
            return PathFindingUtils.createLadderNodeFor(nodeCounts, points, origin, p -> this.method_27137((class_2338)p), (class_1922)this.field_49416.method_57621(), this.field_33);
        }
        return nodeCounts;
    }

    @Inject(method={"done"}, at={@At(value="RETURN")})
    private void clearStuff(CallbackInfo info) {
        this.collisionBreakableCache.clear();
        this.breakableMap.clear();
    }

    @Inject(method={"findAcceptedNode"}, at={@At(value="HEAD")}, cancellable=true)
    private void breakableNodes(int x, int y, int z, int steps, double groundY, class_2350 direction, class_7 PathType, CallbackInfoReturnable<class_9> info) {
        if (!((INodeBreakable)((Object)this)).canBreakBlocks()) {
            return;
        }
        class_9 node = PathFindingUtils.notFloatingNodeModifier(this.field_33, (class_1922)this.field_49416.method_57621(), x, y, z, steps, direction, PathType, pos -> this.method_31932(pos.method_10263(), pos.method_10264(), pos.method_10260()), aabb -> this.collisionBreakableCache.computeIfAbsent(aabb, object -> !PathFindingUtils.noCollision(this.field_49416.method_57621(), (class_1297)this.field_33, aabb)), aabb -> this.field_25191.computeIfAbsent(aabb, object -> !this.field_49416.method_57621().method_8587((class_1297)this.field_33, aabb)), p -> this.method_27137((class_2338)p), this.breakableMap);
        if (node != null) {
            info.setReturnValue((Object)node);
            info.cancel();
        }
    }

    @WrapOperation(method={"getPathTypeWithinMobBB"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/pathfinder/WalkNodeEvaluator;getPathType(Lnet/minecraft/world/level/pathfinder/PathfindingContext;III)Lnet/minecraft/world/level/pathfinder/PathType;")})
    private class_7 breakable(class_14 nodeEvaluator, class_9316 ctx, int x, int y, int z, Operation<class_7> original) {
        if (!((INodeBreakable)((Object)this)).canBreakBlocks()) {
            return (class_7)original.call(new Object[]{nodeEvaluator, ctx, x, y, z});
        }
        class_2338 pos = new class_2338(x, y, z);
        class_2680 state = ctx.method_57623(pos);
        if (this.breakableMap.computeIfAbsent((Object)class_2338.method_10064((int)x, (int)y, (int)z), l -> Config.CommonConfig.breakableBlocks.canBreak(state, pos, (class_1922)ctx.method_57621(), (class_1297)this.field_33, this.field_33 == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)this.field_33)))) {
            return class_7.field_12;
        }
        return (class_7)original.call(new Object[]{nodeEvaluator, ctx, x, y, z});
    }

    @Inject(method={"hasCollisions"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasNoBreakableCollisions(class_238 aabb, CallbackInfoReturnable<Boolean> info) {
        if (((INodeBreakable)((Object)this)).canBreakBlocks()) {
            info.setReturnValue((Object)this.collisionBreakableCache.computeIfAbsent((Object)aabb, object -> !PathFindingUtils.noCollision(this.field_49416.method_57621(), (class_1297)this.field_33, aabb)));
            info.cancel();
        }
    }

    @Shadow
    protected abstract class_7 method_31932(int var1, int var2, int var3);
}

