/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.fabric.config;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.config.BreakableBlocks;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.EntityItemConfig;
import io.github.flemmli97.improvedmobs.config.EntityModifyFlagConfig;
import io.github.flemmli97.improvedmobs.config.MobClassMapConfig;
import io.github.flemmli97.improvedmobs.fabric.config.ConfigLoader;
import io.github.flemmli97.tenshilib.common.config.CommentedJsonConfig;
import io.github.flemmli97.tenshilib.common.config.JsonConfig;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import org.apache.commons.lang3.tuple.Pair;

public final class ConfigSpecs {
    public static JsonConfig<CommentedJsonConfig> clientConfig;
    public static ClientConfigVals clientConfigSpecs;
    public static JsonConfig<CommentedJsonConfig> commonConfig;
    public static CommonConfigVals commonConfigSpecs;

    public static void initClientConfig() {
        Pair pair = CommentedJsonConfig.Builder.create((Path)FabricLoader.getInstance().getConfigDir().resolve("improvedmobs").resolve("client.json"), (int)1, ClientConfigVals::new);
        clientConfig = (JsonConfig)pair.getKey();
        clientConfigSpecs = (ClientConfigVals)pair.getValue();
    }

    public static void initCommonConfig() {
        Pair pair = CommentedJsonConfig.Builder.create((Path)FabricLoader.getInstance().getConfigDir().resolve("improvedmobs").resolve("common.json"), (int)1, CommonConfigVals::new);
        commonConfig = (JsonConfig)pair.getKey();
        commonConfigSpecs = (CommonConfigVals)pair.getValue();
    }

    public static final class ClientConfigVals {
        public final CommentedJsonConfig.IntVal guiX;
        public final CommentedJsonConfig.IntVal guiY;
        public final CommentedJsonConfig.CommentedVal<class_124> color;
        public final CommentedJsonConfig.DoubleVal scale;
        public final CommentedJsonConfig.CommentedVal<Boolean> showDifficulty;
        public final CommentedJsonConfig.CommentedVal<Config.DifficultyBarLocation> location;

        public ClientConfigVals(CommentedJsonConfig.Builder builder) {
            this.guiX = builder.defineInRange("Gui X", 5, 0, Integer.MAX_VALUE);
            this.guiY = builder.defineInRange("Gui Y", 5, 0, Integer.MAX_VALUE);
            this.color = builder.comment(new String[]{"Textformatting codes for the display of the difficulty"}).define("Difficulty color", (Object)class_124.field_1064);
            this.scale = builder.comment(new String[]{"Scaling of the difficulty text"}).defineInRange("Text Scale", 1.0, 0.0, Double.MAX_VALUE);
            this.showDifficulty = builder.comment(new String[]{"Show the the difficulty text"}).define("Show Difficulty", (Object)true);
            this.location = builder.comment(new String[]{"Relative location of the difficulty text in regards to the screen."}).define("Difficulty location", (Object)Config.DifficultyBarLocation.TOPLEFT);
            builder.registerReloadHandler(ConfigLoader::loadClient);
        }
    }

    public static final class CommonConfigVals {
        public final CommentedJsonConfig.CommentedVal<Boolean> enableDifficultyScaling;
        public final CommentedJsonConfig.IntVal difficultyDelay;
        public final CommentedJsonConfig.CommentedVal<Boolean> ignoreSpawner;
        public final CommentedJsonConfig.CommentedVal<List<String>> increaseHandler;
        public final CommentedJsonConfig.CommentedVal<Boolean> ignorePlayers;
        public final CommentedJsonConfig.CommentedVal<Boolean> shouldPunishTimeSkip;
        public final CommentedJsonConfig.CommentedVal<Boolean> friendlyFire;
        public final CommentedJsonConfig.CommentedVal<List<String>> petArmorBlackList;
        public final CommentedJsonConfig.CommentedVal<Boolean> petWhiteList;
        public final CommentedJsonConfig.CommentedVal<Boolean> doIMDifficulty;
        public final CommentedJsonConfig.CommentedVal<Config.DifficultyType> difficultyType;
        public final CommentedJsonConfig.CommentedVal<String> centerPos;
        public final CommentedJsonConfig.CommentedVal<List<String>> flagBlacklist;
        public final CommentedJsonConfig.CommentedVal<List<String>> entityBlacklist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobAttributeWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> armorMobWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> heldMobWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobListBreakWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobListUseWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobListLadderWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobListStealWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobListBoatWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> mobListFlyWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> targetVillagerWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> neutralAggroWhitelist;
        public final CommentedJsonConfig.CommentedVal<Boolean> pehkuiWhitelist;
        public final CommentedJsonConfig.CommentedVal<Config.IntegrationType> vanillaClamped;
        public final CommentedJsonConfig.DoubleVal vanillaClampedMax;
        public final CommentedJsonConfig.CommentedVal<Config.IntegrationType> useScalingHealthMod;
        public final CommentedJsonConfig.CommentedVal<Config.IntegrationType> usePlayerEXMod;
        public final CommentedJsonConfig.DoubleVal playerEXScale;
        public final CommentedJsonConfig.CommentedVal<Config.IntegrationType> useLevelZMod;
        public final CommentedJsonConfig.DoubleVal levelZScale;
        public final CommentedJsonConfig.CommentedVal<Boolean> varySizebyPehkui;
        public final CommentedJsonConfig.DoubleVal sizeMin;
        public final CommentedJsonConfig.DoubleVal sizeMax;
        public final CommentedJsonConfig.DoubleVal sizeChance;
        public final CommentedJsonConfig.CommentedVal<List<String>> breakableBlocks;
        public final CommentedJsonConfig.CommentedVal<Boolean> breakingAsBlacklist;
        public final CommentedJsonConfig.CommentedVal<Boolean> useBlockBreakSound;
        public final CommentedJsonConfig.DoubleVal breakerChance;
        public final CommentedJsonConfig.IntVal breakerInitCooldown;
        public final CommentedJsonConfig.IntVal breakerCooldown;
        public final CommentedJsonConfig.CommentedVal<Boolean> ignoreHarvestLevel;
        public final CommentedJsonConfig.IntVal restoreDelay;
        public final CommentedJsonConfig.CommentedVal<Boolean> idleBreak;
        public final CommentedJsonConfig.DoubleVal breakerSightIgnore;
        public final CommentedJsonConfig.DoubleVal breakSpeedBaseMod;
        public final CommentedJsonConfig.DoubleVal breakSpeedAdd;
        public final CommentedJsonConfig.DoubleVal stealerChance;
        public final CommentedJsonConfig.CommentedVal<List<String>> blackListedContainerBlocks;
        public final CommentedJsonConfig.CommentedVal<Boolean> breakTileEntities;
        public final CommentedJsonConfig.CommentedVal<List<String>> breakingItems;
        public final CommentedJsonConfig.DoubleVal neutralAggressiv;
        public final CommentedJsonConfig.CommentedVal<List<String>> autoTargets;
        public final CommentedJsonConfig.DoubleVal difficultyBreak;
        public final CommentedJsonConfig.DoubleVal difficultySteal;
        public final CommentedJsonConfig.DoubleVal guardianAIChance;
        public final CommentedJsonConfig.DoubleVal flyAIChance;
        public final CommentedJsonConfig.CommentedVal<Boolean> tntBlockDestruction;
        public final CommentedJsonConfig.DoubleVal genericSightIgnore;
        public final CommentedJsonConfig.CommentedVal<List<String>> equipmentModBlacklist;
        public final CommentedJsonConfig.CommentedVal<Boolean> equipmentModWhitelist;
        public final CommentedJsonConfig.CommentedVal<List<String>> itemuseBlacklist;
        public final CommentedJsonConfig.CommentedVal<Boolean> itemuseWhitelist;
        public final CommentedJsonConfig.CommentedVal<List<String>> entityItemConfig;
        public final CommentedJsonConfig.DoubleVal baseEquipChance;
        public final CommentedJsonConfig.DoubleVal baseEquipChanceAdd;
        public final CommentedJsonConfig.DoubleVal diffEquipAdd;
        public final CommentedJsonConfig.DoubleVal randomTrimChance;
        public final CommentedJsonConfig.DoubleVal baseWeaponChance;
        public final CommentedJsonConfig.DoubleVal diffWeaponChance;
        public final CommentedJsonConfig.DoubleVal baseEnchantChance;
        public final CommentedJsonConfig.DoubleVal diffEnchantAdd;
        public final CommentedJsonConfig.CommentedVal<List<String>> enchantCalc;
        public final CommentedJsonConfig.CommentedVal<List<String>> enchantBlacklist;
        public final CommentedJsonConfig.CommentedVal<Boolean> enchantWhitelist;
        public final CommentedJsonConfig.DoubleVal baseItemChance;
        public final CommentedJsonConfig.DoubleVal diffItemChanceAdd;
        public final CommentedJsonConfig.CommentedVal<Boolean> shouldDropEquip;
        public final CommentedJsonConfig.DoubleVal healthIncrease;
        public final CommentedJsonConfig.DoubleVal healthMax;
        public final CommentedJsonConfig.DoubleVal roundHP;
        public final CommentedJsonConfig.DoubleVal damageIncrease;
        public final CommentedJsonConfig.DoubleVal damageMax;
        public final CommentedJsonConfig.DoubleVal speedIncrease;
        public final CommentedJsonConfig.DoubleVal speedMax;
        public final CommentedJsonConfig.DoubleVal knockbackIncrease;
        public final CommentedJsonConfig.DoubleVal knockbackMax;
        public final CommentedJsonConfig.DoubleVal magicResIncrease;
        public final CommentedJsonConfig.DoubleVal magicResMax;
        public final CommentedJsonConfig.DoubleVal projectileIncrease;
        public final CommentedJsonConfig.DoubleVal projectileMax;
        public final CommentedJsonConfig.DoubleVal explosionIncrease;
        public final CommentedJsonConfig.DoubleVal explosionMax;

        public CommonConfigVals(CommentedJsonConfig.Builder builder) {
            this.enableDifficultyScaling = builder.comment(new String[]{"Disable/Enables the whole difficulty scaling of this mod. Requires a mc restart"}).define("Enable difficulty scaling", (Object)Config.CommonConfig.enableDifficultyScaling);
            this.difficultyDelay = builder.comment(new String[]{"Time in ticks for which the difficulty shouldnt increase at the beginning. One full minecraft day is 24000 ticks"}).defineInRange("Difficulty Delay", Config.CommonConfig.difficultyDelay, 0, Integer.MAX_VALUE);
            this.ignoreSpawner = builder.comment(new String[]{"If true ignores mobs from spawners"}).define("Ignore Spawner", (Object)Config.CommonConfig.ignoreSpawner);
            this.increaseHandler = builder.comment(new String[]{"Handles increase in difficulty regarding current difficulty.", "Format is <minimum current difficulty>-<increase every 2400 ticks>", "Example [\"0-0.01\",\"10-0.1\",\"30-0\"]", "So the difficulty increases by 0.01 every 2400 ticks (->0.1 per mc day since a mc day has 24000 ticks) till it reaches a difficulty of 10.", "Then it increases by 1 per mc day till it reaches 30 and then stops.", "If you want to use negative values use | instead of - as the delimiter."}).define("Difficulty Increase", Config.CommonConfig.increaseHandler.writeToString());
            this.ignorePlayers = builder.comment(new String[]{"Wether difficulty should only increase with at least one online players or not"}).define("Ignore Players", (Object)Config.CommonConfig.ignorePlayers);
            this.shouldPunishTimeSkip = builder.comment(new String[]{"If true will increase difficulty by the amount of time skipped. Else will only increase difficulty once."}).define("Punish Time Skip", (Object)Config.CommonConfig.shouldPunishTimeSkip);
            this.friendlyFire = builder.comment(new String[]{"Disable/Enable friendly fire for owned pets."}).define("FriendlyFire", (Object)Config.CommonConfig.friendlyFire);
            this.petArmorBlackList = builder.comment(new String[]{"Blacklist for pet you should't be able to give armor to. Pets from mods, which have custom armor already should be included here (for balancing reasons)."}).define("Pet Blacklist", Config.CommonConfig.petArmorBlackList);
            this.petWhiteList = builder.comment(new String[]{"Treat pet blacklist as whitelist"}).define("Pet Whitelist", (Object)Config.CommonConfig.petWhiteList);
            this.doIMDifficulty = builder.comment(new String[]{"Increase difficulty with time", "Here untill its back as a gamerule"}).define("Difficulty toggle", (Object)Config.CommonConfig.doIMDifficulty);
            this.difficultyType = builder.comment(new String[]{"How the difficulty at a position is calculated. Supported values are: ", "GLOBAL: Serverwide difficulty value", "PLAYERMAX: Maximum difficulty of players in a 256 radius around the position", "PLAYERMEAN: Average difficulty of players in a 256 radius around the position", "PLAYERSUM: Sum of difficulty of players in a 256 radius around the position. There is no upper limit for this so max difficulty can be higher than the limit! You crazy if you use this", "DISTANCE: Uses the distance to the position defined in Center Position to define the difficulty", "DISTANCESPAWN: Uses the distance to the world spawn to define the difficulty", "If the type is any of the distance types the functionality of Difficulty Increase is changed to the following where the 1. value is the minimum distance and the 2. is the difficulty that applies. ", "E.g. [\"0-0\",\"1000-5\"] translates to 0 difficulty between 0-1000 distance and 5 difficulty for distance >= 1000", "You can also define it as a triple x-y-z instead where z is the increase per block in for that area.", "E.g. [\"0-0-0.1\",\"1000-5-1\"] the difficulty increases between 0-1000 by 0.1 per block and >= 1000 by 1 per block with a starting value of 5"}).define("Difficulty type", (Object)Config.CommonConfig.difficultyType);
            this.centerPos = builder.comment(new String[]{"Position used for DISTANCE difficulty type"}).define("Center Position", (Object)Config.CommonConfig.centerPos.writeToString());
            this.entityBlacklist = builder.comment(new String[]{EntityModifyFlagConfig.use()}).define("Entity Configs", (Object)Lists.newArrayList((Object[])new String[]{"UNINITIALIZED"}));
            this.flagBlacklist = builder.comment(new String[]{"Any of the following ", EntityModifyFlagConfig.Flags.toggable().toString(), "added here will disable that feature completely.", "E.g. [\"GUARDIAN\"] will disable the guardian feature"}).define("Flag Blacklist", Config.CommonConfig.flagBlacklist);
            this.mobAttributeWhitelist = builder.comment(new String[]{"Treat ATTRIBUTES flags as whitelist"}).define("Attribute Whitelist", (Object)Config.CommonConfig.mobAttributeWhitelist);
            this.armorMobWhitelist = builder.comment(new String[]{"Treat ARMOR flags as whitelist"}).define("Armor Equip Whitelist", (Object)Config.CommonConfig.armorMobWhitelist);
            this.heldMobWhitelist = builder.comment(new String[]{"Treat HELDITEMS flags as whitelist"}).define("Held Equip Whitelist", (Object)Config.CommonConfig.heldMobWhitelist);
            this.mobListBreakWhitelist = builder.comment(new String[]{"Treat BLOCKBREAK flags as whitelist"}).define("Breaker Whitelist", (Object)Config.CommonConfig.mobListBreakWhitelist);
            this.mobListUseWhitelist = builder.comment(new String[]{"Treat USEITEM flags as whitelist"}).define("Use Flag Whitelist", (Object)Config.CommonConfig.mobListUseWhitelist);
            this.mobListLadderWhitelist = builder.comment(new String[]{"Treat LADDER flags as whitelist"}).define("Ladder Whitelist", (Object)Config.CommonConfig.mobListLadderWhitelist);
            this.mobListStealWhitelist = builder.comment(new String[]{"Treat STEAL flags as whitelist"}).define("Steal Whitelist", (Object)Config.CommonConfig.mobListStealWhitelist);
            this.mobListBoatWhitelist = builder.comment(new String[]{"Treat GUARDIAN flags as whitelist"}).define("Guardian Whitelist", (Object)Config.CommonConfig.mobListBoatWhitelist);
            this.mobListFlyWhitelist = builder.comment(new String[]{"Treat PARROT flags as whitelist"}).define("Phantom Whitelist", (Object)Config.CommonConfig.mobListFlyWhitelist);
            this.targetVillagerWhitelist = builder.comment(new String[]{"Treat TARGETVILLAGER flags as whitelist"}).define("Villager Whitelist", (Object)Config.CommonConfig.targetVillagerWhitelist);
            this.neutralAggroWhitelist = builder.comment(new String[]{"Treat NEUTRALAGGRO flags as whitelist"}).define("Neutral Aggro Whitelist", (Object)Config.CommonConfig.neutralAggroWhitelist);
            this.pehkuiWhitelist = builder.comment(new String[]{"Treat PEHKUI flags as whitelist (Needs pehkui installed)"}).define("Pehkui Whitelist", (Object)Config.CommonConfig.pehkuiWhitelist);
            this.vanillaClamped = builder.comment(new String[]{"Whether vanillas clamped regional difficulty should be used. ", "See https://minecraft.wiki/w/Difficulty#Clamped_regional_difficulty"}).define("Use Vanilla Difficulty", (Object)Config.CommonConfig.vanillaClamped);
            this.vanillaClampedMax = builder.comment(new String[]{"The max value for vanilla difficulty scaling. As clamped regional difficulty returns a value between 0 and 1", "Thus difficulty will be regional difficulty * max"}).defineInRange("Vanilla Max", (double)Config.CommonConfig.vanillaClampedMax, 0.0, Double.MAX_VALUE);
            this.useScalingHealthMod = builder.comment(new String[]{"Should the scaling health mods difficulty system be used instead of this ones. (Requires scaling health mod)"}).define("Use Scaling Health Mod", (Object)Config.CommonConfig.useScalingHealthMod);
            this.usePlayerEXMod = builder.comment(new String[]{"If true and playerEx is installed will use the level from playerEx as difficulty"}).define("Use Player EX Mod", (Object)Config.CommonConfig.usePlayerEXMod);
            this.playerEXScale = builder.comment(new String[]{"Scaling for playerEX integration"}).defineInRange("PlayerEX Scaling", (double)Config.CommonConfig.playerEXScale, 0.0, Double.MAX_VALUE);
            this.useLevelZMod = builder.comment(new String[]{"If true and LevelZ is installed will use the the total skill level from LevelZ as difficulty"}).define("Use LevelZ Mod", (Object)Config.CommonConfig.useLevelZMod);
            this.levelZScale = builder.comment(new String[]{"Scaling for LevelZ integration"}).defineInRange("LevelZ Scaling", (double)Config.CommonConfig.levelZScale, 0.0, Double.MAX_VALUE);
            this.varySizebyPehkui = builder.comment(new String[]{"Using pehkui to vary the size of mobs"}).define("Use pehkui Mod", (Object)Config.CommonConfig.varySizebyPehkui);
            this.sizeMax = builder.comment(new String[]{"The Max scale of mobs. Range [1.0,10], default 2.0"}).defineInRange("Max size Multiplier", (double)Config.CommonConfig.sizeMax, 1.0, 10.0);
            this.sizeMin = builder.comment(new String[]{"The Minimum scale of mobs. Range (0,1.0), default 0.5"}).defineInRange("Minimum size Multiplier", (double)Config.CommonConfig.sizeMin, 0.0, 1.0);
            this.sizeChance = builder.comment(new String[]{"Chance that a mob will be affected by size changes"}).defineInRange("Size Chance", (double)Config.CommonConfig.sizeChance, 0.0, 1.0);
            this.breakableBlocks = builder.comment(new String[]{"Whitelist for blocks, which can be actively broken. ", BreakableBlocks.use(), "Note: If you include common blocks (like grass blocks) the pathfinding can have undesirable results."}).define("Block Break Whitelist", Config.CommonConfig.breakableBlocks.writeToString());
            this.breakingAsBlacklist = builder.comment(new String[]{"Treat Block Whitelist as Blocklist"}).define("Breaklist as Blacklist", (Object)Config.CommonConfig.breakingAsBlacklist);
            this.useBlockBreakSound = builder.comment(new String[]{"Use the block breaking sound instead of a knocking sound"}).define("Sound", (Object)Config.CommonConfig.useBlockBreakSound);
            this.breakerChance = builder.comment(new String[]{"Chance for a mob to be able to break blocks"}).defineInRange("Breaker Chance", (double)Config.CommonConfig.breakerChance, 0.0, 1.0);
            this.breakerInitCooldown = builder.comment(new String[]{"Initial cooldown for block breaking mobs"}).defineInRange("Breaker Initial Cooldown", Config.CommonConfig.breakerInitCooldown, 0, Integer.MAX_VALUE);
            this.breakerCooldown = builder.comment(new String[]{"Cooldown for breaking blocks"}).defineInRange("Breaker Cooldown", Config.CommonConfig.breakerCooldown, 0, Integer.MAX_VALUE);
            this.ignoreHarvestLevel = builder.comment(new String[]{"By default mobs can only break the block they can harvest with the current tool they holding. Set this to true to disable that check (The block will not drop if they cant harvest it though!)."}).define("Ignore Harvest Check", (Object)Config.CommonConfig.ignoreHarvestLevel);
            this.restoreDelay = builder.comment(new String[]{"Blocks will be restored after x ticks being broken. If set to 0 will never restore", "This will not restore block entity data!"}).defineInRange("Restore delay", Config.CommonConfig.restoreDelay, 0, Integer.MAX_VALUE);
            this.idleBreak = builder.comment(new String[]{"If mobs should break blocks when not chasing a target"}).define("Idle Break", (Object)Config.CommonConfig.idleBreak);
            this.breakerSightIgnore = builder.comment(new String[]{"Chance a breaker mob to ignore line of sight"}).defineInRange("Breaker Sight Ignore", (double)Config.CommonConfig.breakerSightIgnore, 0.0, 1.0);
            this.breakSpeedBaseMod = builder.comment(new String[]{"A modifier to the breaking speed"}).defineInRange("Breaking Speed Base", (double)Config.CommonConfig.breakSpeedBaseMod, 0.0, Double.MAX_VALUE);
            this.breakSpeedAdd = builder.comment(new String[]{"Addition to breaking speed modifier based on difficulty.", "Final modifier is base + addition * difficulty"}).defineInRange("Breaking Speed Add", (double)Config.CommonConfig.breakSpeedAdd, 0.0, Double.MAX_VALUE);
            this.stealerChance = builder.comment(new String[]{"Chance for a mob to be able to steal items from inventory blocks"}).defineInRange("Stealer Chance", (double)Config.CommonConfig.stealerChance, 0.0, 1.0);
            this.blackListedContainerBlocks = builder.comment(new String[]{"List of blocks mobs shouldn't steal from. You can also add a modid to blacklist whole mods"}).define("Steal Block Blacklist", Config.CommonConfig.blackListedContainerBlocks);
            this.breakingItems = builder.comment(new String[]{"Items which will be given to mobs who can break blocks. Empty list = no items. Syntax: id;weight", "Note: Mobs can only break blocks if the tool they are holding can break the blocks"}).define("Breaking items", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:diamond_pickaxe;1", "minecraft:iron_axe;2"}));
            this.breakTileEntities = builder.comment(new String[]{"Should mobs be able to break block entities? Evaluated before the break list"}).define("Break BlockEntities", (Object)Config.CommonConfig.breakTileEntities);
            this.neutralAggressiv = builder.comment(new String[]{"Chance for neutral mobs to be aggressive"}).defineInRange("Neutral Aggressive Chance", (double)Config.CommonConfig.neutralAggressiv, 0.0, 1.0);
            this.autoTargets = builder.comment(new String[]{"List for of pairs containing which mobs auto target others. Syntax is " + MobClassMapConfig.use()}).define("Auto Target List", Config.CommonConfig.autoTargets.writeToString());
            this.difficultyBreak = builder.comment(new String[]{"Difficulty at which mobs are able to break blocks"}).defineInRange("Difficulty Break AI", (double)Config.CommonConfig.difficultyBreak, 0.0, Double.MAX_VALUE);
            this.difficultySteal = builder.comment(new String[]{"Difficulty at which mobs are able to steal items"}).defineInRange("Difficulty Steal AI", (double)Config.CommonConfig.difficultySteal, 0.0, Double.MAX_VALUE);
            this.guardianAIChance = builder.comment(new String[]{"Chance for mobs to be able to summon an aquatic mount"}).defineInRange("Guardian Chance", (double)Config.CommonConfig.guardianAIChance, 0.0, 1.0);
            this.flyAIChance = builder.comment(new String[]{"Chance for mobs to be able to summon a flying mount"}).defineInRange("Phantom Chance", (double)Config.CommonConfig.flyAIChance, 0.0, 1.0);
            this.tntBlockDestruction = builder.comment(new String[]{"Set this to true to allow tnt thrown by mobs to destroy blocks"}).define("TNT Block Destruction", (Object)Config.CommonConfig.tntBlockDestruction);
            this.genericSightIgnore = builder.comment(new String[]{"Chance for a mob to ignore line of sight", "This config ONLY affects villager target, neutral aggressive and auto targeting feature"}).defineInRange("Generic Sight Ignore", (double)Config.CommonConfig.genericSightIgnore, 0.0, 1.0);
            this.equipmentModBlacklist = builder.comment(new String[]{"Blacklist items from whole mods. Add modid to prevent items from that mod being equipped. (For individual items use the equipment.json)"}).define("Item Blacklist", Config.CommonConfig.equipmentModBlacklist);
            this.equipmentModWhitelist = builder.comment(new String[]{"Use blacklist as whitelist"}).define("Item Whitelist", (Object)Config.CommonConfig.equipmentModWhitelist);
            this.itemuseBlacklist = builder.comment(new String[]{"Blacklist for items mobs should never be able to use.", "Use as in using the item similar to players (e.g. shooting bows)"}).define("Item Use Blacklist", Config.CommonConfig.itemuseBlacklist);
            this.itemuseWhitelist = builder.comment(new String[]{"Turn the use blacklist into a whitelist"}).define("Item Use Whitelist", (Object)Config.CommonConfig.itemuseWhitelist);
            this.entityItemConfig = builder.comment(new String[]{"Blacklist for specific mobs and items they shouldnt use (e.g. skeletons already use bows)", EntityItemConfig.use()}).define("Entity Item Use Blacklist", Config.CommonConfig.entityItemConfig.writeToString());
            this.baseEquipChance = builder.comment(new String[]{"Base chance that a mob can have one piece of armor"}).defineInRange("Equipment Chance", (double)Config.CommonConfig.baseEquipChance, 0.0, 1.0);
            this.baseEquipChanceAdd = builder.comment(new String[]{"Base chance for each additional armor pieces"}).defineInRange("Additional Equipment Chance", (double)Config.CommonConfig.baseEquipChanceAdd, 0.0, 1.0);
            this.diffEquipAdd = builder.comment(new String[]{"Adds additional x*difficulty% to base equip chance"}).defineInRange("Equipment Addition", (double)Config.CommonConfig.diffEquipAdd, 0.0, Double.MAX_VALUE);
            this.randomTrimChance = builder.comment(new String[]{"Chance for an equipment to have a random armor trim"}).defineInRange("Armor Trim Chance", (double)Config.CommonConfig.randomTrimChance, 0.0, 1.0);
            this.baseWeaponChance = builder.comment(new String[]{"Chance for mobs to have a weapon"}).defineInRange("Weapon Chance", (double)Config.CommonConfig.baseWeaponChance, 0.0, 1.0);
            this.diffWeaponChance = builder.comment(new String[]{"Adds additional x*difficulty% to base weapon chance"}).defineInRange("Weapon Chance Add", (double)Config.CommonConfig.diffWeaponChance, 0.0, Double.MAX_VALUE);
            this.baseEnchantChance = builder.comment(new String[]{"Base chance for each armor pieces to get enchanted"}).defineInRange("Enchanting Chance", (double)Config.CommonConfig.baseEnchantChance, 0.0, 1.0);
            this.diffEnchantAdd = builder.comment(new String[]{"Adds additional x*difficulty% to base enchanting chance"}).defineInRange("Enchanting Addition", (double)Config.CommonConfig.diffEnchantAdd, 0.0, Double.MAX_VALUE);
            this.enchantCalc = builder.comment(new String[]{"Specify min and max enchanting levels according to difficulty. difficulty-minLevel-maxLevel"}).define("Enchanting Calc", Config.CommonConfig.enchantCalc.writeToString());
            this.enchantBlacklist = builder.comment(new String[]{"Blacklist enchantments from being applied to equipments"}).define("Enchanting Blacklist", Config.CommonConfig.enchantBlacklist);
            this.enchantWhitelist = builder.comment(new String[]{"Turn the enchant blacklist to a whitelist"}).define("Enchanting Whitelist", (Object)Config.CommonConfig.enchantWhitelist);
            this.baseItemChance = builder.comment(new String[]{"Chance for mobs to have an item in offhand"}).defineInRange("Item Equip Chance", (double)Config.CommonConfig.baseItemChance, 0.0, 1.0);
            this.diffItemChanceAdd = builder.comment(new String[]{"Adds additional x*difficulty% to base item chance"}).defineInRange("Item Chance add", (double)Config.CommonConfig.diffItemChanceAdd, 0.0, Double.MAX_VALUE);
            this.shouldDropEquip = builder.comment(new String[]{"Should mobs drop the armor equipped through this mod? Will not change drops if the mob obtained the armor through other means (e.g. vanilla)"}).define("Should drop equipment", (Object)Config.CommonConfig.shouldDropEquip);
            this.healthIncrease = builder.comment(new String[]{"Health will be multiplied by 1 + difficulty*0.016*x. Set to 0 to disable"}).defineInRange("Health Increase Multiplier", Config.CommonConfig.healthIncrease, 0.0, Double.MAX_VALUE);
            this.healthMax = builder.comment(new String[]{"Health will be multiplied by at maximum this. Set to 0 means no limit"}).defineInRange("Max Health Increase", Config.CommonConfig.healthMax, 0.0, Double.MAX_VALUE);
            this.roundHP = builder.comment(new String[]{"Round health to the nearest x. Set to 0 to disable"}).defineInRange("Round HP", Config.CommonConfig.roundHP, 0.0, Double.MAX_VALUE);
            this.damageIncrease = builder.comment(new String[]{"Damage will be multiplied by 1 + difficulty*0.008*x. Set to 0 to disable"}).defineInRange("Damage Increase Multiplier", Config.CommonConfig.damageIncrease, 0.0, Double.MAX_VALUE);
            this.damageMax = builder.comment(new String[]{"Damage will be multiplied by at maximum this. Set to 0 means no limit"}).defineInRange("Max Damage Increase", Config.CommonConfig.damageMax, 0.0, Double.MAX_VALUE);
            this.speedIncrease = builder.comment(new String[]{"Speed will be increased by difficulty*0.0008*x. Set to 0 to disable"}).defineInRange("Speed Increase", Config.CommonConfig.speedIncrease, 0.0, Double.MAX_VALUE);
            this.speedMax = builder.comment(new String[]{"Maximum increase in speed"}).defineInRange("Max Speed", Config.CommonConfig.speedMax, 0.0, 1.0);
            this.knockbackIncrease = builder.comment(new String[]{"Knockback will be increased by difficulty*0.002*x. Set to 0 to disable"}).defineInRange("Knockback Increase", Config.CommonConfig.knockbackIncrease, 0.0, Double.MAX_VALUE);
            this.knockbackMax = builder.comment(new String[]{"Maximum increase in knockback"}).defineInRange("Max Knockback", Config.CommonConfig.knockbackMax, 0.0, 1.0);
            this.magicResIncrease = builder.comment(new String[]{"Magic resistance will be increased by difficulty*0.0016*x. Set to 0 to disable"}).defineInRange("Magic Resistance Increase", (double)Config.CommonConfig.magicResIncrease, 0.0, Double.MAX_VALUE);
            this.magicResMax = builder.comment(new String[]{"Maximum increase in magic resistance. Magic reduction is percentage"}).defineInRange("Max Magic Resistance", (double)Config.CommonConfig.magicResMax, 0.0, 1.0);
            this.projectileIncrease = builder.comment(new String[]{"Projectile Damage will be multiplied by 1 + difficulty*0.008*x. Set to 0 to disable"}).defineInRange("Projectile Damage Increase", (double)Config.CommonConfig.projectileIncrease, 0.0, Double.MAX_VALUE);
            this.projectileMax = builder.comment(new String[]{"Projectile damage will be multiplied by maximum of this"}).defineInRange("Max Projectile Damage", (double)Config.CommonConfig.projectileMax, 0.0, Double.MAX_VALUE);
            this.explosionIncrease = builder.comment(new String[]{"Explosion Damage will be multiplied by 1 + difficulty*0.003*x. Set to 0 to disable"}).defineInRange("Explosion Damage Increase", (double)Config.CommonConfig.explosionIncrease, 0.0, Double.MAX_VALUE);
            this.explosionMax = builder.comment(new String[]{"Explosion damage will be multiplied by maximum of this"}).defineInRange("Max Explosion Damage", (double)Config.CommonConfig.explosionMax, 0.0, Double.MAX_VALUE);
            builder.registerReloadHandler(ConfigLoader::loadCommon);
        }
    }
}

