/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.events;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.ai.BlockBreakGoal;
import io.github.flemmli97.improvedmobs.ai.FlyRidingGoal;
import io.github.flemmli97.improvedmobs.ai.ItemUseGoal;
import io.github.flemmli97.improvedmobs.ai.LadderClimbGoal;
import io.github.flemmli97.improvedmobs.ai.StealGoal;
import io.github.flemmli97.improvedmobs.ai.WaterRidingGoal;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.DifficultyConfig;
import io.github.flemmli97.improvedmobs.config.EntityModifyFlagConfig;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import io.github.flemmli97.improvedmobs.mixin.NearestTargetGoalMixin;
import io.github.flemmli97.improvedmobs.mixin.TargetGoalAccessor;
import io.github.flemmli97.improvedmobs.mixinhelper.INodeBreakable;
import io.github.flemmli97.improvedmobs.mixinhelper.ISpawnReason;
import io.github.flemmli97.improvedmobs.network.PacketHandler;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.utils.EntityFlags;
import io.github.flemmli97.improvedmobs.utils.Utils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1410;
import net.minecraft.class_1412;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1686;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.server.MinecraftServer;

public class EventCalls {
    public static void worldJoin(class_3222 player, MinecraftServer server) {
        CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
        CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createConfigPacket(), player);
    }

    public static void tick(class_3218 level) {
        BlockRestorationData.get(level).tick(level);
        if (!Config.CommonConfig.enableDifficultyScaling) {
            return;
        }
        if (!Config.CommonConfig.difficultyType.increaseDifficulty) {
            if (level.method_8510() % 20L == 0L && level.method_27983() == class_1937.field_25179) {
                CrossPlatformStuff.INSTANCE.sendDifficultyData(DifficultyData.get(level.method_8503()), level.method_8503());
            }
            return;
        }
        if (level.method_27983() == class_1937.field_25179) {
            boolean shouldIncrease = (Config.CommonConfig.ignorePlayers || !level.method_8503().method_3760().method_14571().isEmpty()) && level.method_8532() > (long)Config.CommonConfig.difficultyDelay;
            DifficultyData data = DifficultyData.get(level.method_8503());
            if (Config.CommonConfig.shouldPunishTimeSkip) {
                long timeDiff = Math.abs(level.method_8532() - data.getPrevTime());
                if (timeDiff > 2400L) {
                    long i = timeDiff / 2400L;
                    if (timeDiff - i * 2400L > (i + 1L) * 2400L - timeDiff) {
                        ++i;
                    }
                    while (i > 0L) {
                        data.increaseDifficultyBy(current -> Float.valueOf(shouldIncrease && Config.CommonConfig.doIMDifficulty ? ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current.floatValue()).getRight()).start() : 0.0f), level.method_8532(), level.method_8503());
                        --i;
                    }
                }
            } else if (level.method_8532() - data.getPrevTime() > 2400L) {
                data.increaseDifficultyBy(current -> Float.valueOf(shouldIncrease && Config.CommonConfig.doIMDifficulty ? ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current.floatValue()).getRight()).start() : 0.0f), level.method_8532(), level.method_8503());
            }
        }
    }

    public static void onEntityLoad(class_1308 mob) {
        List<class_1299<?>> types;
        boolean hasVillagerTarget;
        boolean aggressive;
        boolean ignoreSight;
        if (mob.method_37908().field_9236 || mob instanceof RiddenSummonEntity) {
            return;
        }
        if (((ISpawnReason)mob).getSpawnReason() == class_3730.field_16469 && Config.CommonConfig.ignoreSpawner) {
            return;
        }
        EntityFlags flags = EntityFlags.get((class_1297)mob);
        boolean mobGriefing = mob.method_37908().method_8450().method_8355(class_1928.field_19388);
        float difficulty = DifficultyData.getDifficulty(mob.method_37908(), (class_1309)mob);
        if (flags.canBreakBlocks == EntityFlags.FlagType.UNDEF) {
            flags.canBreakBlocks = difficulty >= Config.CommonConfig.difficultyBreak && Config.CommonConfig.breakerChance != 0.0f && mob.method_59922().method_43057() < Config.CommonConfig.breakerChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.BLOCKBREAK, Config.CommonConfig.mobListBreakWhitelist) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        if (flags.canFly == EntityFlags.FlagType.UNDEF) {
            flags.canFly = mob.method_59922().method_43057() < Config.CommonConfig.flyAIChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.PARROT, Config.CommonConfig.mobListFlyWhitelist) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        EventCalls.applyAttributesAndItems(mob, difficulty);
        if (!Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.USEITEM, Config.CommonConfig.mobListUseWhitelist)) {
            mob.field_6201.method_6277(1, (class_1352)new ItemUseGoal(mob, 12.0f));
        }
        if (mob.method_59922().method_43057() < Config.CommonConfig.guardianAIChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.GUARDIAN, Config.CommonConfig.mobListBoatWhitelist) && !(((MobEntityMixin)mob).getTrueNavigator() instanceof class_1412) && !(mob instanceof class_1621)) {
            mob.field_6201.method_6277(6, (class_1352)new WaterRidingGoal(mob));
        }
        if (flags.canFly == EntityFlags.FlagType.TRUE && !(((MobEntityMixin)mob).getTrueNavigator() instanceof class_1407) && !(mob instanceof class_1621)) {
            mob.field_6201.method_6277(6, (class_1352)new FlyRidingGoal(mob));
        }
        if (!Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.LADDER, Config.CommonConfig.mobListLadderWhitelist) && !(mob.method_5942() instanceof class_1410)) {
            EntityFlags.get((class_1297)mob).ladderClimber = true;
            mob.field_6201.method_6277(4, (class_1352)new LadderClimbGoal(mob));
            ((INodeBreakable)mob.method_5942().method_6342()).setCanClimbLadder(true);
        }
        boolean villager = !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.TARGETVILLAGER, Config.CommonConfig.targetVillagerWhitelist);
        boolean bl = ignoreSight = mob.method_59922().method_43057() < Config.CommonConfig.genericSightIgnore;
        if (mob instanceof class_5354 && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.NEUTRALAGGRO, Config.CommonConfig.neutralAggroWhitelist)) {
            boolean bl2 = aggressive = Config.CommonConfig.neutralAggressiv != 0.0f && mob.method_59922().method_43057() < Config.CommonConfig.neutralAggressiv;
            if (aggressive) {
                mob.field_6185.method_6277(1, EventCalls.setNoLoS(mob, class_1657.class, ignoreSight, null));
            }
        } else {
            aggressive = true;
        }
        if (villager && aggressive && !(hasVillagerTarget = mob.field_6185.method_35115().stream().anyMatch(g -> {
            NearestTargetGoalMixin target;
            class_1352 patt0$temp;
            return g != null && (patt0$temp = g.method_19058()) instanceof NearestTargetGoalMixin && (target = (NearestTargetGoalMixin)patt0$temp).targetTypeClss() == class_3988.class;
        }))) {
            mob.field_6185.method_6277(3, EventCalls.setNoLoS(mob, class_3988.class, ignoreSight, null));
        }
        if ((types = Config.CommonConfig.autoTargets.get(class_7923.field_41177.method_10221((Object)mob.method_5864()))) != null) {
            mob.field_6185.method_6277(3, EventCalls.setNoLoS(mob, class_1309.class, ignoreSight, l -> types.contains(l.method_5864())));
        }
        if (mob instanceof class_1314) {
            class_1314 pathfinderMob = (class_1314)mob;
            if (difficulty >= Config.CommonConfig.difficultySteal && mobGriefing && Config.CommonConfig.stealerChance != 0.0f && mob.method_59922().method_43057() < Config.CommonConfig.stealerChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.STEAL, Config.CommonConfig.mobListStealWhitelist)) {
                pathfinderMob.field_6201.method_6277(5, (class_1352)new StealGoal(pathfinderMob));
            }
        }
        if (flags.canBreakBlocks == EntityFlags.FlagType.TRUE) {
            mob.field_6185.method_35115().forEach(g -> {
                if (g != null && g.method_19058() instanceof class_1400 && mob.method_59922().method_43057() < Config.CommonConfig.breakerSightIgnore) {
                    ((TargetGoalAccessor)g.method_19058()).setShouldCheckSight(false);
                    ((NearestTargetGoalMixin)g.method_19058()).getTargetEntitySelector().method_36627();
                }
            });
            if (mobGriefing) {
                ((INodeBreakable)mob.method_5942().method_6342()).setCanBreakBlocks(true);
                mob.field_6201.method_6277(1, (class_1352)new BlockBreakGoal(mob));
                if (mob.method_6079().method_7960()) {
                    class_1799 stack = Config.CommonConfig.getRandomBreakingItem(mob.method_59922());
                    if (!Config.CommonConfig.shouldDropEquip) {
                        mob.method_5946(class_1304.field_6171, -100.0f);
                    }
                    mob.method_5673(class_1304.field_6171, stack);
                }
            }
        }
    }

    private static <T extends class_1309> class_1400<T> setNoLoS(class_1308 e, Class<T> clss, boolean ignoreSight, Predicate<class_1309> pred) {
        class_1400 goal = pred == null ? new class_1400(e, clss, !ignoreSight) : new class_1400(e, clss, 10, !ignoreSight, false, pred);
        if (ignoreSight) {
            ((NearestTargetGoalMixin)goal).getTargetEntitySelector().method_36627();
        }
        return goal;
    }

    private static void applyAttributesAndItems(class_1308 living, float difficulty) {
        EntityFlags flags = EntityFlags.get((class_1297)living);
        if (!flags.modifyArmor) {
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.ARMOR, Config.CommonConfig.armorMobWhitelist)) {
                Utils.equipArmor(living, difficulty);
            }
            flags.modifyArmor = true;
        }
        if (!flags.modifyHeldItems) {
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.HELDITEMS, Config.CommonConfig.heldMobWhitelist)) {
                Utils.equipHeld(living, difficulty);
            }
            flags.modifyHeldItems = true;
        }
        if (!flags.enchantGear) {
            Utils.enchantGear(living, difficulty);
            flags.enchantGear = true;
        }
        if (!flags.modifyAttributes) {
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.ATTRIBUTES, Config.CommonConfig.mobAttributeWhitelist)) {
                if (Config.CommonConfig.healthIncrease != 0.0 && !Config.CommonConfig.useScalingHealthMod.enabled()) {
                    Utils.modifyAttr(living, (class_6880<class_1320>)class_5134.field_23716, Config.CommonConfig.healthIncrease * 0.016, Config.CommonConfig.healthMax, difficulty, true);
                    living.method_6033(living.method_6063());
                }
                if (Config.CommonConfig.damageIncrease != 0.0 && !Config.CommonConfig.useScalingHealthMod.enabled()) {
                    Utils.modifyAttr(living, (class_6880<class_1320>)class_5134.field_23721, Config.CommonConfig.damageIncrease * 0.008, Config.CommonConfig.damageMax, difficulty, true);
                }
                if (Config.CommonConfig.speedIncrease != 0.0) {
                    Utils.modifyAttr(living, (class_6880<class_1320>)class_5134.field_23719, Config.CommonConfig.speedIncrease * 8.0E-4, Config.CommonConfig.speedMax, difficulty, false);
                }
                if (Config.CommonConfig.knockbackIncrease != 0.0) {
                    Utils.modifyAttr(living, (class_6880<class_1320>)class_5134.field_23718, Config.CommonConfig.knockbackIncrease * 0.002, Config.CommonConfig.knockbackMax, difficulty, false);
                }
                if (Config.CommonConfig.magicResIncrease != 0.0f) {
                    EntityFlags.get((class_1297)living).magicRes = Math.min(Config.CommonConfig.magicResIncrease * 0.0016f * difficulty, Config.CommonConfig.magicResMax);
                }
                if (Config.CommonConfig.projectileIncrease != 0.0f) {
                    EntityFlags.get((class_1297)living).projMult = 1.0f + (Config.CommonConfig.projectileMax <= 0.0f ? Config.CommonConfig.projectileIncrease * 0.008f * difficulty : Math.min(Config.CommonConfig.projectileIncrease * 0.008f * difficulty, Config.CommonConfig.projectileMax - 1.0f));
                }
                if (Config.CommonConfig.explosionIncrease != 0.0f) {
                    EntityFlags.get((class_1297)living).explosionMult = 1.0f + (Config.CommonConfig.explosionMax <= 0.0f ? Config.CommonConfig.explosionIncrease * 0.003f * difficulty : Math.min(Config.CommonConfig.explosionIncrease * 0.003f * difficulty, Config.CommonConfig.explosionMax - 1.0f));
                }
            }
            flags.modifyAttributes = true;
        }
        if (Config.CommonConfig.varySizebyPehkui) {
            if (!flags.isVariedSize && living.method_59922().method_43057() < Config.CommonConfig.sizeChance && !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.PEHKUI, Config.CommonConfig.pehkuiWhitelist)) {
                Utils.modifyScale(living, Config.CommonConfig.sizeMin, Config.CommonConfig.sizeMax);
            }
            flags.isVariedSize = true;
        }
    }

    public static float hurtEvent(class_1309 entity, class_1282 source, float dmg) {
        if (source.method_48789(class_8103.field_42247) && source.method_5529() instanceof class_1588) {
            return dmg * EntityFlags.get((class_1297)source.method_5529()).projMult;
        }
        if (source.method_48789(class_8103.field_42249) && source.method_5529() instanceof class_1588) {
            return dmg * EntityFlags.get((class_1297)source.method_5529()).explosionMult;
        }
        if (entity instanceof class_1588 && source.method_48789(class_8103.field_42248)) {
            return dmg * (1.0f - EntityFlags.get((class_1297)entity).magicRes);
        }
        return dmg;
    }

    public static boolean onAttackEvent(class_1309 target, class_1282 damagesource) {
        if (!target.method_37908().field_9236) {
            class_1309 attacker;
            if (!Config.CommonConfig.friendlyFire && target instanceof class_1321) {
                class_1321 pet = (class_1321)target;
                if (damagesource.method_5529() != null && damagesource.method_5529() == pet.method_35057() && !damagesource.method_5529().method_5715()) {
                    return true;
                }
            }
            class_1297 source = damagesource.method_5529();
            if (target instanceof class_1657) {
                class_1297 direct = damagesource.method_5526();
                if (direct instanceof class_1680) {
                    EntityFlags flag = EntityFlags.get(direct);
                    if (flag.isThrownEntity) {
                        flag.isThrownEntity = false;
                        target.method_5643(damagesource, 0.001f);
                    }
                }
            } else if (source instanceof class_1309 && CrossPlatformStuff.INSTANCE.canDisableShield((attacker = (class_1309)source).method_6047(), target.method_6030(), target, attacker)) {
                EventCalls.triggerDisableShield(target);
            }
        }
        return false;
    }

    private static void triggerDisableShield(class_1309 target) {
        EntityFlags.get((class_1297)target).disableShield();
        target.method_6021();
        target.method_37908().method_8421((class_1297)target, (byte)30);
    }

    public static void openTile(class_1657 player, class_2338 pos) {
        class_2586 tile;
        if (!player.method_37908().field_9236 && !player.method_5715() && (tile = player.method_37908().method_8321(pos)) != null) {
            CrossPlatformStuff.INSTANCE.onPlayerOpen(tile);
        }
    }

    public static boolean equipPet(class_1657 player, class_1268 hand, class_1297 target) {
        class_1799 heldItem;
        class_1792 class_17922;
        class_6025 pet;
        class_1308 mob;
        if (hand == class_1268.field_5808 && target instanceof class_1308 && ((mob = (class_1308)target) instanceof class_6025 || mob.method_5864().method_20210(ImprovedMobs.ARMOR_EQUIPPABLE)) && !target.method_37908().field_9236 && player.method_5715() && !Utils.isInList(target, Config.CommonConfig.petArmorBlackList, Config.CommonConfig.petWhiteList, Utils.ENTITY_ID) && (!(mob instanceof class_6025) || player == (pet = (class_6025)mob).method_35057()) && (class_17922 = (heldItem = player.method_6047()).method_7909()) instanceof class_1738) {
            class_1738 armor = (class_1738)class_17922;
            class_1304 type = armor.method_7685();
            switch (type) {
                case field_6169: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6169);
                    break;
                }
                case field_6174: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6174);
                    break;
                }
                case field_6172: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6172);
                    break;
                }
                case field_6166: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6166);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static void equipPetItem(class_1657 player, class_1308 living, class_1799 stack, class_1304 slot) {
        class_1799 current = living.method_6118(slot);
        if (!current.method_7960() && !player.method_7337()) {
            class_1542 entityitem = new class_1542(living.method_37908(), living.method_23317(), living.method_23318(), living.method_23321(), current);
            entityitem.method_6975();
            living.method_37908().method_8649((class_1297)entityitem);
        }
        class_1799 copy = stack.method_7972();
        copy.method_7939(1);
        living.method_5673(slot, copy);
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
    }

    public static boolean projectileImpact(class_1676 projectile, class_239 hitResult) {
        class_3966 res;
        class_1297 thrower;
        return EntityFlags.get((class_1297)projectile).isThrownEntity && (thrower = projectile.method_24921()) instanceof class_1308 && !(projectile instanceof class_1686) && hitResult.method_17783() == class_239.class_240.field_1331 && !(res = (class_3966)hitResult).method_17782().equals((Object)((class_1308)thrower).method_5968());
    }

    public static void explosion(class_1927 explosion, class_1297 source, List<class_1297> affectedEntities) {
        if (source instanceof class_1541 && EntityFlags.get((class_1297)source).isThrownEntity) {
            class_1309 igniter;
            if (!Config.CommonConfig.tntBlockDestruction) {
                explosion.method_8346().clear();
            }
            if ((igniter = explosion.method_8347()) instanceof class_1308) {
                affectedEntities.removeIf(e -> !e.equals((Object)((class_1308)igniter).method_5968()));
            }
        }
    }
}

