/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.difficulty;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.DifficultyConfig;
import io.github.flemmli97.improvedmobs.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class DifficultyData
extends class_18 {
    private static final String IDENTIFIER = "Difficulty";
    private static final class_18.class_8645<DifficultyData> FACTORY = new class_18.class_8645(DifficultyData::new, DifficultyData::new, class_4284.field_19212);
    private float difficultyLevel;
    private long prevTime;
    private boolean paused;

    public DifficultyData() {
    }

    private DifficultyData(class_2487 tag, class_7225.class_7874 provider) {
        this.load(tag);
    }

    public static DifficultyData get(MinecraftServer server) {
        return (DifficultyData)server.method_30002().method_17983().method_17924(FACTORY, IDENTIFIER);
    }

    public static float getDifficulty(class_1937 level, class_1309 e) {
        if (!(level instanceof class_3218)) {
            return 0.0f;
        }
        class_3218 serverLevel = (class_3218)level;
        return DifficultyFetcher.getDifficulty(serverLevel, e.method_19538());
    }

    public static List<class_1657> playersIn(class_1924 getter, class_243 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (class_1657 player : getter.method_18456()) {
            if (!player.method_19538().method_24802((class_2374)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public void increaseDifficultyBy(Function<Float, Float> increase, long time, MinecraftServer server) {
        if (!this.paused) {
            this.difficultyLevel += increase.apply(Float.valueOf(this.getDifficulty())).floatValue();
        }
        this.prevTime = time;
        server.method_3760().method_14571().forEach(player -> {
            PlayerDifficulty data = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((class_3222)player);
            if (!data.paused()) {
                data.setDifficultyLevel(data.getDifficultyLevel() + ((Float)increase.apply(Float.valueOf(data.getDifficultyLevel()))).floatValue());
            }
        });
        this.method_80();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
    }

    public void setDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel = level;
        this.prevTime = server.method_30002().method_8532();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.method_80();
    }

    public void addDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel += level;
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.method_80();
    }

    public float getDifficulty() {
        return this.difficultyLevel;
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public static float getDifficultyFromDist(class_3218 level, class_243 pos) {
        float dist = Config.CommonConfig.difficultyType == Config.DifficultyType.DISTANCESPAWN ? class_3532.method_15355((float)((float)pos.method_1028((double)level.method_43126().method_10263() + 0.5, pos.method_10214(), (double)level.method_43126().method_10260() + 0.5))) : class_3532.method_15355((float)((float)pos.method_1028((double)Config.CommonConfig.centerPos.getPos().method_10263() + 0.5, pos.method_10214(), (double)Config.CommonConfig.centerPos.getPos().method_10260() + 0.5)));
        Pair<Float, DifficultyConfig.Zone> conf = Config.CommonConfig.increaseHandler.get(dist);
        return ((DifficultyConfig.Zone)conf.getRight()).start() + (dist - ((Float)conf.getLeft()).floatValue()) * ((DifficultyConfig.Zone)conf.getRight()).increasePerBlock();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void load(class_2487 nbt) {
        this.difficultyLevel = nbt.method_10583(IDENTIFIER);
        this.prevTime = nbt.method_10537("Time");
        this.paused = nbt.method_10577("Paused");
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        compound.method_10548(IDENTIFIER, this.difficultyLevel);
        compound.method_10544("Time", this.prevTime);
        compound.method_10556("Paused", this.paused);
        return compound;
    }
}

