/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.ai.util.ItemAITasks;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_4537;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class EquipmentList {
    private static final int CONFIG_VERSION = 2;
    private static final Map<class_1304, WeightedItemstackList> EQUIPMENTS = new HashMap<class_1304, WeightedItemstackList>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static class_1799 getEquip(class_1308 e, class_1304 slot, float difficulty) {
        WeightedItemstackList eq = EQUIPMENTS.get(slot);
        if (eq == null || eq.list.isEmpty() || eq.getTotalWeight(difficulty) <= 0) {
            return class_1799.field_8037;
        }
        int index = e.method_37908().field_9229.method_43048(eq.getTotalWeight(difficulty));
        for (WeightedItemstack entry : eq.filteredList) {
            if ((index -= entry.getWeight(difficulty)) >= 0) continue;
            return entry.getItem();
        }
        return class_1799.field_8037;
    }

    public static void initEquip(class_7225.class_7874 provider) {
        try {
            File conf = CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json").toFile();
            JsonObject confObj = new JsonObject();
            class_6903 ops = provider.method_57093((DynamicOps)JsonOps.INSTANCE);
            if (!conf.exists()) {
                EquipmentList.initDefaultVals();
                conf.createNewFile();
            } else {
                FileReader reader = new FileReader(conf);
                confObj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (confObj == null) {
                    confObj = new JsonObject();
                }
                reader.close();
                int version = class_3518.method_15282((JsonObject)confObj, (String)"version", (int)1);
                if (version < 2) {
                    ImprovedMobs.LOGGER.debug("You are having a legacy config. A Backup will be created");
                    EquipmentList.createBackup();
                } else {
                    class_1304[] class_1304Array = class_1304.values();
                    int n = class_1304Array.length;
                    for (int i = 0; i < n; ++i) {
                        class_1304 key = class_1304Array[i];
                        if (!confObj.has(key.toString())) continue;
                        JsonArray entries = confObj.get(key.toString()).getAsJsonArray();
                        if (!entries.isEmpty()) {
                            entries.forEach(ent -> {
                                WeightedItemstack value = (WeightedItemstack)WeightedItemstack.CODEC.parse((DynamicOps)ops, ent).getOrThrow();
                                EQUIPMENTS.compute(key, (s, l) -> l == null ? new WeightedItemstackList(value) : l.add(value));
                            });
                            continue;
                        }
                        EQUIPMENTS.put(key, new WeightedItemstackList(new WeightedItemstack[0]));
                    }
                }
            }
            JsonArray comment = new JsonArray();
            comment.add("Mobs will be able to equip items declared here");
            comment.add("Value is the item. It also accepts item components. The default config has an example with a harming potion");
            comment.add("Weight is the weight of an item. Higher weight means that the item is more likely to get choosen");
            comment.add("Quality is a modifier applied to the weight. The final weight used is weight + quality * current difficulty");
            confObj.addProperty("version", (Number)2);
            confObj.add("__comment", (JsonElement)comment);
            for (class_1304 key : class_1304.values()) {
                WeightedItemstackList stackList = EQUIPMENTS.get(key);
                if (stackList == null) continue;
                JsonArray sorted = new JsonArray();
                ArrayList<WeightedItemstack> sort = new ArrayList<WeightedItemstack>(stackList.list);
                Collections.sort(sort);
                sort.forEach(s -> sorted.add((JsonElement)WeightedItemstack.CODEC.encodeStart((DynamicOps)ops, s).getOrThrow()));
                confObj.add(key.toString(), (JsonElement)sorted);
                stackList.finishList();
            }
            conf.delete();
            conf.createNewFile();
            JsonWriter wr = GSON.newJsonWriter((Writer)new FileWriter(conf));
            GSON.toJson((Object)confObj, JsonObject.class, wr);
            wr.close();
        }
        catch (IOException | IllegalStateException e) {
            ImprovedMobs.LOGGER.error("Error initializing equipment");
            e.printStackTrace();
        }
    }

    private static void createBackup() {
        try {
            Files.move(CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json"), CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json.bak"), new CopyOption[0]);
            EquipmentList.initDefaultVals();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDefaultVals() {
        HashMap mapBuilder = new HashMap();
        BiFunction<List, WeightedItemstack, List> func = (o, v) -> {
            if (o == null) {
                return new ArrayList<WeightedItemstack>(List.of(v));
            }
            o.add(v);
            return o;
        };
        class_7923.field_41178.forEach(item -> {
            ItemAI ai;
            if (item instanceof class_1753) {
                EquipmentList.addItemTo(mapBuilder, class_1304.field_6173, item);
            }
            if ((ai = ItemAITasks.getAI(item)) != null) {
                switch (ai.prefHand()) {
                    case BOTH: {
                        float[] weights;
                        if (ai.type() == ItemAI.ItemType.NONSTRAFINGITEM) {
                            weights = EquipmentList.getDefaultWeight(item);
                            WeightedItemstack val = new WeightedItemstack(new class_1799((class_1935)item), (int)weights[0], weights[1]);
                            if (((List)mapBuilder.get(class_1304.field_6173)).contains(val)) break;
                            mapBuilder.compute(class_1304.field_6171, (s, l) -> (List)func.apply((List)l, val));
                            break;
                        }
                        if (item instanceof class_4537) {
                            weights = EquipmentList.getDefaultWeight(item);
                            mapBuilder.compute(class_1304.field_6173, (s, l) -> (List)func.apply((List)l, new WeightedItemstack(class_1844.method_57400((class_1792)item, (class_6880)class_1847.field_9004), (int)weights[0], weights[1])));
                            break;
                        }
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6173, item);
                        break;
                    }
                    case MAIN: {
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6173, item);
                        break;
                    }
                    case OFF: {
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6171, item);
                    }
                }
            }
            if (item instanceof class_1738) {
                class_1738 armorItem = (class_1738)item;
                switch (armorItem.method_7685()) {
                    case field_6166: {
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6166, item);
                        break;
                    }
                    case field_6174: {
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6174, item);
                        break;
                    }
                    case field_6169: {
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6169, item);
                        break;
                    }
                    case field_6172: {
                        EquipmentList.addItemTo(mapBuilder, class_1304.field_6172, item);
                    }
                }
            }
            if ((item instanceof class_1829 || item instanceof class_1766) && !EquipmentList.defaultBlackLists(item)) {
                EquipmentList.addItemTo(mapBuilder, class_1304.field_6173, item);
            }
        });
        Map minMaxWeight = mapBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Pair.of((Object)((List)e.getValue()).stream().mapToInt(w -> w.weight).min().orElse(1), (Object)((List)e.getValue()).stream().mapToInt(w -> w.weight).max().orElse(1)), (e1, e2) -> e1, HashMap::new));
        for (Map.Entry entry : mapBuilder.entrySet()) {
            WeightedItemstackList list = new WeightedItemstackList(new WeightedItemstack[0]);
            int min = (int)((double)((Integer)((Pair)minMaxWeight.get(entry.getKey())).getFirst()).intValue() * 0.25);
            int max = (Integer)((Pair)minMaxWeight.get(entry.getKey())).getSecond();
            ((List)entry.getValue()).forEach(s -> list.add(new WeightedItemstack(s.item, s.weight == 0 ? s.weight : max - s.weight + min, s.quality)));
            EQUIPMENTS.put((class_1304)entry.getKey(), list);
        }
    }

    private static void addItemTo(Map<class_1304, List<WeightedItemstack>> map, class_1304 slot, class_1792 item) {
        float[] weights = EquipmentList.getDefaultWeight(item);
        map.compute(slot, (s, l) -> {
            if (l == null) {
                return new ArrayList<WeightedItemstack>(List.of(new WeightedItemstack(new class_1799((class_1935)item), (int)weights[0], weights[1])));
            }
            l.add(new WeightedItemstack(new class_1799((class_1935)item), (int)weights[0], weights[1]));
            return l;
        });
    }

    private static boolean defaultBlackLists(class_1792 item) {
        if (item instanceof class_1766 && !(item instanceof class_1743)) {
            return true;
        }
        return class_7923.field_41178.method_10221((Object)item).method_12836().equals("mobbattle");
    }

    private static float[] getDefaultWeight(class_1792 item) {
        int inverseWeight = 0;
        float durability = ((Integer)item.method_57347().method_57830(class_9334.field_50072, (Object)0)).intValue();
        if (item instanceof class_1738) {
            class_1738 armor = (class_1738)item;
            float protection = ((class_1741)armor.method_7686().comp_349()).method_48403(class_1738.class_8051.field_41934) + ((class_1741)armor.method_7686().comp_349()).method_48403(class_1738.class_8051.field_41935) + ((class_1741)armor.method_7686().comp_349()).method_48403(class_1738.class_8051.field_41936) + ((class_1741)armor.method_7686().comp_349()).method_48403(class_1738.class_8051.field_41937);
            inverseWeight = (int)((float)inverseWeight + protection * protection * 4.0f);
            float toughness = ((class_1741)armor.method_7686().comp_349()).comp_2303();
            inverseWeight = (int)((double)inverseWeight + (double)(toughness * toughness * toughness) * 0.5);
            if ((durability /= (float)armor.method_48398().method_56690(1)) <= 0.0f) {
                durability = 100.0f;
            }
            inverseWeight = (int)((float)inverseWeight + durability * 7.0f);
            float enchantmentValue = armor.method_7837();
            inverseWeight = (int)((float)inverseWeight + enchantmentValue * 5.0f);
            inverseWeight = (int)((double)inverseWeight * ((double)((class_1741)armor.method_7686().comp_349()).comp_2304() * 0.5 + 1.0));
            try {
                inverseWeight = (int)((float)inverseWeight * (((class_1741)armor.method_7686().comp_349()).comp_2301() != null && ((class_1741)armor.method_7686().comp_349()).comp_2301().get() != class_1856.field_9017 ? 1.0f : 0.9f));
            }
            catch (Exception e) {
                ImprovedMobs.LOGGER.error("Cannot compute repair ingredient {}", (Object)class_7923.field_41178.method_10221((Object)item), (Object)e);
            }
            inverseWeight = (int)((float)inverseWeight * (armor.method_7686() == class_1740.field_7897 || armor.method_7686() == class_1740.field_7895 || armor.method_7686() == class_1740.field_7887 || armor.method_7686() == class_1740.field_7892 || armor.method_7686() == class_1740.field_7889 || armor.method_7686() == class_1740.field_21977 || armor.method_7686() == class_1740.field_7890 ? 0.8f : 1.0f));
        } else if (item instanceof class_1829 || item instanceof class_1766) {
            class_1799 def = new class_1799((class_1935)item);
            double dmg = ItemUtils.damageRaw((class_1799)def);
            inverseWeight = dmg <= 10.0 ? (int)((double)inverseWeight + (dmg * dmg * 2.0 + dmg * 3.0)) : (dmg <= 30.0 ? (int)((double)inverseWeight + ((dmg -= 10.0) * dmg * 1.5 + dmg * 5.0 + 230.0)) : (int)((double)inverseWeight + ((dmg -= 30.0) * 12.0 + 930.0)));
            inverseWeight = (int)((double)inverseWeight + (double)durability * 1.7);
        } else {
            if (item == class_1802.field_8884) {
                inverseWeight = 1000;
            } else if (item instanceof class_1819) {
                inverseWeight = 750;
            } else if (item == class_1802.field_8187) {
                inverseWeight = 1500;
            } else if (item == class_1802.field_8634) {
                inverseWeight = 1100;
            } else if (item == class_1802.field_8543) {
                inverseWeight = 550;
            } else if (item instanceof class_4537) {
                inverseWeight = 1500;
            } else if (item instanceof class_1753) {
                class_1753 bow = (class_1753)item;
                inverseWeight = 1500 + bow.method_24792() * 20;
            } else if (item == class_1802.field_8598) {
                inverseWeight = 1600;
            } else if (item == class_2246.field_10375.method_8389()) {
                inverseWeight = 1700;
            } else if (item == class_1802.field_8547) {
                inverseWeight = 2000;
            } else if (item instanceof class_1764) {
                class_1764 crossbow = (class_1764)item;
                inverseWeight = 1200 + crossbow.method_24792() * 18;
            }
            inverseWeight = (int)((float)inverseWeight + durability * 2.0f);
        }
        float quality = EquipmentList.defaultQualityFromWeight(inverseWeight);
        return new float[]{Math.max(inverseWeight, 1), quality};
    }

    private static float defaultQualityFromWeight(int weight) {
        float multiplier = weight <= 500 ? 1.0f : (weight <= 2000 ? (float)Math.log(100 * (weight - 500)) : (float)Math.log(500 * (weight - 2000)) + 5.0f);
        multiplier = (float)((double)multiplier * 0.01);
        weight = Math.max(1, weight);
        return (float)weight * 0.01f * multiplier;
    }

    public static class WeightedItemstackList {
        private final List<WeightedItemstack> list = new ArrayList<WeightedItemstack>();
        private List<WeightedItemstack> filteredList = new ArrayList<WeightedItemstack>();
        private int totalWeight;
        private float lastModifier = -1.0f;

        public WeightedItemstackList(WeightedItemstack ... item) {
            this.list.addAll(Arrays.asList(item));
            this.list.removeIf(w -> w.item == null);
        }

        public int getTotalWeight(float modifier) {
            if (this.lastModifier != modifier) {
                this.lastModifier = modifier;
                this.calculateTotalWeight(this.lastModifier);
            }
            return this.totalWeight;
        }

        private void calculateTotalWeight(float modifier) {
            this.filteredList = this.list.stream().filter(entry -> entry.getWeight(modifier) > 0).toList();
            this.totalWeight = this.filteredList.stream().mapToInt(entry -> entry.getWeight(modifier)).sum();
        }

        public void finishList() {
            this.list.removeIf(w -> w.weight <= 0 && w.quality <= 0.0f || this.modBlacklist(w.item.method_7909()));
        }

        private boolean modBlacklist(class_1792 item) {
            if (Config.CommonConfig.equipmentModWhitelist) {
                for (String s : Config.CommonConfig.equipmentModBlacklist) {
                    if (!class_7923.field_41178.method_10221((Object)item).method_12836().equals(s)) continue;
                    return false;
                }
                return true;
            }
            for (String s : Config.CommonConfig.equipmentModBlacklist) {
                if (!class_7923.field_41178.method_10221((Object)item).method_12836().equals(s)) continue;
                return true;
            }
            return false;
        }

        public WeightedItemstackList add(WeightedItemstack item) {
            if (item.item == null) {
                return this;
            }
            this.list.remove(item);
            this.list.add(item);
            return this;
        }

        public String toString() {
            return String.format("TotalWeight: %d ; [%s]", this.totalWeight, this.list);
        }
    }

    public static class WeightedItemstack
    implements Comparable<WeightedItemstack> {
        public static final Codec<WeightedItemstack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtils.ITEM_STACK_CODEC.fieldOf("value").forGetter(d -> d.item), (App)Codec.INT.fieldOf("weight").forGetter(d -> d.weight), (App)Codec.FLOAT.fieldOf("quality").forGetter(d -> Float.valueOf(d.quality))).apply((Applicative)inst, WeightedItemstack::new));
        private final class_1799 item;
        private final int weight;
        private final float quality;

        public WeightedItemstack(class_1799 item, int itemWeight, float quality) {
            this.weight = itemWeight;
            this.quality = quality;
            this.item = item;
        }

        public class_1799 getItem() {
            return this.item.method_7972();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeightedItemstack) {
                WeightedItemstack oth = (WeightedItemstack)other;
                return class_1799.method_7973((class_1799)this.item, (class_1799)oth.item);
            }
            return false;
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        @Override
        public int compareTo(WeightedItemstack o) {
            return class_7923.field_41178.method_10221((Object)this.item.method_7909()).toString().compareTo(class_7923.field_41178.method_10221((Object)o.item.method_7909()).toString());
        }

        public String toString() {
            return String.format("Item: %s; Weight: %d", class_7923.field_41178.method_10221((Object)this.item.method_7909()), this.weight);
        }

        public int getWeight(float modifier) {
            return Math.max(this.weight + class_3532.method_15375((float)(modifier * this.quality)), 0);
        }
    }
}

