/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EntityModifyFlagConfig {
    private final Map<String, EnumSet<Flags>> map = new HashMap<String, EnumSet<Flags>>();
    private final List<String> tagsEntryToResolve = new ArrayList<String>();
    private boolean resolved;

    public void initDefault(class_1937 world) {
        this.map.clear();
        for (class_1299 entry : class_7923.field_41177) {
            try {
                class_1297 e = entry.method_5883(world);
                if (!(e instanceof class_1308)) continue;
                EnumSet<Flags> set = EnumSet.noneOf(Flags.class);
                for (Flags flag : Flags.values()) {
                    if (flag.tag == null || !entry.method_40124().method_40220(flag.tag)) continue;
                    set.add(flag);
                }
                if (set.isEmpty() && !(e instanceof class_1569)) {
                    set.add(Flags.ALL);
                }
                if (set.isEmpty()) continue;
                this.map.put(class_7923.field_41177.method_10221((Object)entry).toString(), set);
            }
            catch (Exception e) {
                ImprovedMobs.LOGGER.error("Error during default entity config for EntityType {}, skipping this type. Cause: {}", (Object)class_7923.field_41177.method_10221((Object)entry), (Object)e.getMessage());
            }
        }
    }

    public boolean hasFlag(class_1308 living, Flags flag, boolean reverse) {
        class_2960 res;
        if (!this.resolved) {
            this.resolveTags();
        }
        if ((res = class_7923.field_41177.method_10221((Object)living.method_5864())) == null) {
            return true;
        }
        if (Config.CommonConfig.flagBlacklist.contains(flag.toString())) {
            return true;
        }
        EnumSet<Flags> set = this.map.get(res.toString());
        if (set == null) {
            set = this.map.get(res.method_12836());
        }
        if (set != null) {
            return reverse ^ set.contains((Object)Flags.REVERSE) ^ (set.contains((Object)Flags.ALL) || set.contains((Object)flag));
        }
        return reverse;
    }

    public EntityModifyFlagConfig readFromString(List<String> s) {
        this.map.clear();
        for (String val : s) {
            EnumSet<Flags> set;
            if (val.startsWith("#")) {
                this.tagsEntryToResolve.add(val);
                continue;
            }
            String[] subs = val.split("\\|");
            if (subs.length == 1) {
                set = EnumSet.of(Flags.ALL);
            } else {
                set = EnumSet.noneOf(Flags.class);
                for (int i = 1; i < subs.length; ++i) {
                    set.add(Flags.valueOf(subs[i].trim()));
                }
            }
            this.map.put(subs[0].trim(), set);
        }
        this.resolved = false;
        return this;
    }

    public void resolveTags() {
        this.resolved = true;
        for (String val : this.tagsEntryToResolve) {
            EnumSet<Flags> set;
            String[] subs = val.substring(1).split("\\|");
            if (subs.length == 1) {
                set = EnumSet.of(Flags.ALL);
            } else {
                set = EnumSet.noneOf(Flags.class);
                for (int i = 1; i < subs.length; ++i) {
                    set.add(Flags.valueOf(subs[i].trim()));
                }
            }
            Iterable tag = class_7923.field_41177.method_40286(class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)class_2960.method_60654((String)subs[0].trim())));
            tag.forEach(h -> this.map.put(class_7923.field_41177.method_10221((Object)((class_1299)h.comp_349())).toString(), set));
        }
    }

    public List<String> writeToString() {
        ArrayList<String> s = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            StringBuilder val = new StringBuilder(key);
            for (Flags f : this.map.get(key)) {
                if (f == Flags.ALL) continue;
                val.append("|").append(f.name());
            }
            s.add(val.toString());
        }
        return s;
    }

    public static String use() {
        CharSequence[] str = new String[]{"Entities added here will be blacklisted from their assigned flags. Usage:", "<entity registry name> or <namespace> or <#tag> followed by any of:", "[" + ArrayUtils.arrayToString((Object[])Flags.values()) + "].", "Having no flags is equal to ALL. Use REVERSE to reverse all flags. Some flags do nothing for certain mobs!", "Examples (without <>):", "<minecraft:sheep> (equal to minecraft:sheep|ALL) excludes sheeps from all modifications", "<minecraft:sheep|REVERSE|ATTRIBUTES will> add sheep to attributes modification only", "<#minecraft:raiders|ATTRIBUTES> will add all entities in the raiders tag to everything except attributes", "<minecraft:sheep|ATTRIBUTES> will add sheep to everything except attributes", "<minecraft> disables everything for all minecraft mobs"};
        return String.join((CharSequence)"\n", str);
    }

    public static enum Flags {
        ALL(null),
        ATTRIBUTES("attributes"),
        ARMOR("armor"),
        HELDITEMS("helditems"),
        BLOCKBREAK("blockbreak"),
        USEITEM("useitem"),
        LADDER("ladder"),
        STEAL("steal"),
        GUARDIAN("guardian"),
        PARROT("parrot"),
        TARGETVILLAGER("villager"),
        NEUTRALAGGRO("neutral"),
        PEHKUI("pehkui"),
        REVERSE(null);

        public final class_6862<class_1299<?>> tag;

        private Flags(String id) {
            this.tag = id == null ? null : class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)ImprovedMobs.modRes("default_blacklist_" + id));
        }

        public static List<Flags> toggable() {
            ArrayList<Flags> all = new ArrayList<Flags>(Arrays.asList(Flags.values()));
            all.remove((Object)ALL);
            all.remove((Object)REVERSE);
            return all;
        }
    }
}

