/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.improvedmobs.config.Config;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BreakableBlocks {
    private final Set<String> blocks = new HashSet<String>();
    private List<String> configString = new ArrayList<String>();
    private boolean initialized;

    public BreakableBlocks(String ... defaultVal) {
        this.configString.addAll(List.of(defaultVal));
    }

    public boolean canBreak(class_2680 state, class_2338 pos, class_1922 level, @Nullable class_1297 entity, class_3726 ctx) {
        class_1308 mob;
        if (!this.initialized) {
            this.initialize();
        }
        if (!Config.CommonConfig.idleBreak && entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() == null) {
            return false;
        }
        if (state.method_26194(level, pos, ctx).method_1110()) {
            return false;
        }
        if (!Config.CommonConfig.breakTileEntities && state.method_31709()) {
            return false;
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        if (Config.CommonConfig.breakingAsBlacklist) {
            return !this.blocks.contains(id.toString()) && !this.blocks.contains(id.method_12836());
        }
        return this.blocks.contains(id.method_12836()) || this.blocks.contains(id.toString());
    }

    public BreakableBlocks readFromString(List<String> arr) {
        this.blocks.clear();
        this.configString = arr;
        this.initialized = false;
        return this;
    }

    public void initialize() {
        this.initialized = true;
        this.blocks.clear();
        HashSet<String> blackList = new HashSet<String>();
        for (String s : this.configString) {
            if (s.startsWith("!")) {
                BreakableBlocks.addBlocks(s.substring(1), blackList);
                continue;
            }
            BreakableBlocks.addBlocks(s, this.blocks);
        }
        this.blocks.removeAll(blackList);
    }

    private static void addBlocks(String s, Set<String> blocks) {
        if (s.startsWith("#")) {
            Iterable tag = class_7923.field_41175.method_40286(class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)class_2960.method_60654((String)s.substring(1))));
            tag.forEach(h -> blocks.add(class_7923.field_41175.method_10221((Object)((class_2248)h.comp_349())).toString()));
        } else {
            blocks.add(s);
        }
    }

    public List<String> writeToString() {
        return this.configString;
    }

    public static String use() {
        return "Usage: id|namespace|#tag. Put \"!\" infront to exclude blocks. E.g. \"minecraft\", \"minecraft:dirt\" or \"#minecraft:planks\"";
    }
}

