/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.DifficultyConfig;
import io.github.flemmli97.improvedmobs.config.EquipmentList;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.network.PacketHandler;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class IMCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"improvedmobs").executes(IMCommand::getDifficulty)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadJson").requires(src -> src.method_9259(2))).executes(IMCommand::reloadJson))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"difficulty").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::setDifficultyPlayer)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::addDifficultyPlayer)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::setDifficulty)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::addDifficulty)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pause").then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(src -> IMCommand.pauseDifficulty((CommandContext<class_2168>)src, class_2191.method_9330((CommandContext)src, (String)"players"), true))))).executes(src -> IMCommand.pauseDifficulty((CommandContext<class_2168>)src, null, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unpause").then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(src -> IMCommand.pauseDifficulty((CommandContext<class_2168>)src, class_2191.method_9330((CommandContext)src, (String)"players"), false))))).executes(src -> IMCommand.pauseDifficulty((CommandContext<class_2168>)src, null, false)))).then(class_2170.method_9247((String)"simulate").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"steps", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(src -> IMCommand.simulateDifficulty((CommandContext<class_2168>)src, class_2191.method_9330((CommandContext)src, (String)"players"), IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))).executes(src -> IMCommand.simulateDifficulty((CommandContext<class_2168>)src, null, IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))));
    }

    private static int reloadJson(CommandContext<class_2168> src) {
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloading equipment.json"), true);
        EquipmentList.initEquip((class_7225.class_7874)((class_2168)src.getSource()).method_30497());
        return 1;
    }

    private static int setDifficulty(CommandContext<class_2168> src) {
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        data.setDifficulty(FloatArgumentType.getFloat(src, (String)"val"), ((class_2168)src.getSource()).method_9211());
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty set to " + data.getDifficulty())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int addDifficulty(CommandContext<class_2168> src) {
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        data.addDifficulty(FloatArgumentType.getFloat(src, (String)"val"), ((class_2168)src.getSource()).method_9211());
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty set to " + data.getDifficulty())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int setDifficultyPlayer(CommandContext<class_2168> src) throws CommandSyntaxException {
        Collection profs = class_2191.method_9330(src, (String)"players");
        MinecraftServer server = ((class_2168)src.getSource()).method_9211();
        for (GameProfile prof : profs) {
            class_3222 player = server.method_3760().method_14602(prof.getId());
            PlayerDifficulty data = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player);
            data.setDifficultyLevel(FloatArgumentType.getFloat(src, (String)"val"));
            CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        }
        return profs.size();
    }

    private static int addDifficultyPlayer(CommandContext<class_2168> src) throws CommandSyntaxException {
        Collection profs = class_2191.method_9330(src, (String)"players");
        MinecraftServer server = ((class_2168)src.getSource()).method_9211();
        for (GameProfile prof : profs) {
            class_3222 player = server.method_3760().method_14602(prof.getId());
            PlayerDifficulty data = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player);
            data.setDifficultyLevel(data.getDifficultyLevel() + FloatArgumentType.getFloat(src, (String)"val"));
            CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        }
        return profs.size();
    }

    private static int getDifficulty(CommandContext<class_2168> src) throws CommandSyntaxException {
        float diff;
        if (Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL) {
            diff = DifficultyData.get(((class_2168)src.getSource()).method_9211()).getDifficulty();
        } else {
            class_3222 player = ((class_2168)src.getSource()).method_9207();
            diff = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).getDifficultyLevel();
        }
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty: " + diff)).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int pauseDifficulty(CommandContext<class_2168> src, Collection<GameProfile> profs, boolean pause) throws CommandSyntaxException {
        if (profs != null) {
            MinecraftServer server = ((class_2168)src.getSource()).method_9211();
            for (GameProfile prof : profs) {
                class_3222 player = server.method_3760().method_14602(prof.getId());
                PlayerDifficulty data = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player);
                data.setPaused(pause);
            }
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty " + (pause ? "paused" : "unpaused") + " for given players")).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
            return profs.size();
        }
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        data.setPaused(pause);
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty " + (pause ? "paused" : "unpaused"))).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int simulateDifficulty(CommandContext<class_2168> src, Collection<GameProfile> profs, int steps) {
        if (profs != null) {
            MinecraftServer server = ((class_2168)src.getSource()).method_9211();
            for (GameProfile prof : profs) {
                class_3222 player = server.method_3760().method_14602(prof.getId());
                PlayerDifficulty data = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player);
                for (int i = steps; i > 0; --i) {
                    float current = data.getDifficultyLevel();
                    data.setDifficultyLevel(current + ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current).getRight()).start());
                }
                CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            }
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Simulated %s difficulty steps for given players", steps)).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
            return profs.size();
        }
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        float current = data.getDifficulty();
        for (int i = steps; i > 0; --i) {
            current += ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current).getRight()).start();
        }
        data.setDifficulty(current, ((class_2168)src.getSource()).method_9211());
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Simulated %s difficulty steps globally. Now at %s", steps, Float.valueOf(data.getDifficulty()))).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }
}

