/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.difficulty;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public interface DifficultyGetter {
    public static List<class_1657> playersIn(class_1924 getter, class_243 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (class_1657 player : getter.method_18456()) {
            if (!player.method_19538().method_24802((class_2374)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public static float getDifficulty(class_1937 level, class_243 pos, Function<class_3222, Float> getter) {
        return switch (Config.CommonConfig.difficultyType) {
            default -> throw new MatchException(null, null);
            case Config.DifficultyType.PLAYERMAX -> {
                float diff = 0.0f;
                for (class_1657 player : DifficultyData.playersIn((class_1924)level, pos, 256.0)) {
                    float pD = getter.apply((class_3222)player).floatValue();
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERSUM -> {
                float diff = 0.0f;
                for (class_1657 player : DifficultyData.playersIn((class_1924)level, pos, 256.0)) {
                    diff += getter.apply((class_3222)player).floatValue();
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERMEAN, Config.DifficultyType.GLOBAL, Config.DifficultyType.DISTANCE, Config.DifficultyType.DISTANCESPAWN -> {
                float diff = 0.0f;
                List<class_1657> list = DifficultyData.playersIn((class_1924)level, pos, 256.0);
                if (list.isEmpty()) {
                    yield 0.0f;
                }
                for (class_1657 player : list) {
                    diff += getter.apply((class_3222)player).floatValue();
                }
                yield diff / (float)list.size();
            }
        };
    }

    public float getDifficulty(class_3218 var1, class_243 var2);

    public Config.IntegrationType getType();

    default public boolean hasOwnDisplay() {
        return false;
    }
}

