/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.difficulty;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyGetter;
import io.github.flemmli97.improvedmobs.api.difficulty.impl.DefaultDifficulty;
import io.github.flemmli97.improvedmobs.api.difficulty.impl.VanillaDifficulty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class DifficultyFetcher {
    private static final class_2960 DEFAULT = ImprovedMobs.modRes("default");
    private static final List<OrderedResource> ORDERED_RESOURCES = new ArrayList<OrderedResource>();
    private static final Map<class_2960, DifficultyGetter> DIFFICULTIES = new HashMap<class_2960, DifficultyGetter>();

    public static void register() {
        DifficultyFetcher.add(DEFAULT, -1, new DefaultDifficulty());
        DifficultyFetcher.add(class_2960.method_60655((String)"minecraft", (String)"clamped_difficulty"), new VanillaDifficulty());
    }

    public static synchronized void add(class_2960 id, DifficultyGetter impl) {
        DifficultyFetcher.add(id, ORDERED_RESOURCES.size(), impl);
    }

    public static synchronized void add(class_2960 id, int order, DifficultyGetter impl) {
        ORDERED_RESOURCES.add(new OrderedResource(order, id));
        ORDERED_RESOURCES.sort(Collections.reverseOrder());
        DIFFICULTIES.put(id, impl);
    }

    public static boolean shouldClientShowDifficulty() {
        int base = 0;
        ArrayList<Boolean> adding = new ArrayList<Boolean>();
        for (OrderedResource r : ORDERED_RESOURCES) {
            DifficultyGetter v = DIFFICULTIES.get(r.res);
            switch (v.getType()) {
                case ON: {
                    if (base != 0) break;
                    base = v.hasOwnDisplay() ? 2 : 1;
                    break;
                }
                case ADD: {
                    adding.add(v.hasOwnDisplay());
                }
            }
        }
        return base < 2 || adding.size() == 1 && (Boolean)adding.get(0) == false || !adding.isEmpty();
    }

    public static float getDifficulty(class_3218 level, class_243 pos) {
        float difficulty = 0.0f;
        float toAdd = 0.0f;
        for (OrderedResource r : ORDERED_RESOURCES) {
            DifficultyGetter v = DIFFICULTIES.get(r.res);
            switch (v.getType()) {
                case ON: {
                    if (difficulty != 0.0f) break;
                    difficulty = v.getDifficulty(level, pos);
                    break;
                }
                case ADD: {
                    toAdd += v.getDifficulty(level, pos);
                }
            }
        }
        return difficulty + toAdd;
    }

    record OrderedResource(int order, class_2960 res) implements Comparable<OrderedResource>
    {
        @Override
        public int compareTo(@NotNull OrderedResource o) {
            return this.order == o.order ? this.res.method_12833(o.res) : Integer.compare(this.order, o.order);
        }
    }
}

