/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai.util;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.ai.util.AIUtils;
import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.mixinhelper.ITNTThrowable;
import io.github.flemmli97.improvedmobs.utils.EntityFlags;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1547;
import net.minecraft.class_1588;
import net.minecraft.class_1669;
import net.minecraft.class_1678;
import net.minecraft.class_1680;
import net.minecraft.class_1682;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class ItemAIs {
    private static final List<class_6880<class_1291>> POTION_EFFECTS = Lists.newArrayList((Object[])new class_6880[]{class_1294.field_5924, class_1294.field_5904, class_1294.field_5910, class_1294.field_5905, class_1294.field_5907, class_1294.field_5918});
    public static final ItemAI ENCHANTEDBOOK = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            block7: {
                if (entity.method_37908().field_9236) break block7;
                List nearby = entity.method_37908().method_8335((class_1297)entity, entity.method_5829().method_1014(8.0));
                List nearTarget = entity.method_37908().method_8335((class_1297)entity.method_5968(), entity.method_5968().method_5829().method_1014(2.0));
                if (nearby.isEmpty() || nearby.size() == 1 && nearby.get(0) == entity.method_5968() || entity.method_37908().field_9229.method_43048(3) <= 1) {
                    if (nearTarget.isEmpty()) {
                        for (int x = -1; x <= 1; ++x) {
                            for (int z = -1; z <= 1; ++z) {
                                if (x != 0 && z != 0) continue;
                                class_243 targetMotion = target.method_18798();
                                class_1669 fang = new class_1669(entity.method_37908(), target.method_23317() + (double)x + targetMotion.field_1352, target.method_23318(), target.method_23321() + (double)z + targetMotion.field_1350, 0.0f, 5, (class_1309)entity);
                                entity.method_37908().method_8649((class_1297)fang);
                            }
                        }
                    } else {
                        class_1678 bullet = new class_1678(entity.method_37908(), (class_1309)entity, (class_1297)target, entity.method_5735().method_10166());
                        EntityFlags.get((class_1297)bullet).isThrownEntity = true;
                        entity.method_37908().method_8649((class_1297)bullet);
                    }
                } else {
                    for (int i = 0; i < nearby.size(); ++i) {
                        class_1297 entityRand = (class_1297)nearby.get(entity.method_37908().field_9229.method_43048(nearby.size()));
                        if (!(entityRand instanceof class_1588)) continue;
                        class_1588 mob = (class_1588)entityRand;
                        if (entityRand == entity.method_5968()) continue;
                        mob.method_6092(new class_1293(POTION_EFFECTS.get(mob.method_37908().field_9229.method_43048(6)), 3600, 1));
                        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15203, class_3419.field_15254, 2.0f, 1.0f);
                        return;
                    }
                }
            }
        }

        @Override
        public int cooldown() {
            return 80;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI TRIDENT = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            AIUtils.tridentAttack(entity, target);
        }

        @Override
        public int cooldown() {
            return 65;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(class_1308 entity, class_1268 hand) {
            return 40;
        }
    };
    public static final ItemAI TNT = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            double dis = entity.method_19538().method_1022(target.method_19538());
            if (!entity.method_37908().field_9236) {
                class_1541 tnt = new class_1541(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_1309)entity);
                ((ITNTThrowable)tnt).shootFromEntity((class_1297)entity, entity.method_36455(), entity.method_36454(), -20.0f, 0.2f + (float)(dis * 0.05), 1.0f);
                EntityFlags.get((class_1297)tnt).isThrownEntity = true;
                entity.method_37908().method_8649((class_1297)tnt);
            }
        }

        @Override
        public int cooldown() {
            return 65;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI FLINT_N_STEEL = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            double dis = entity.method_19538().method_1022(target.method_19538());
            if (dis < (double)(entity.method_17681() + target.method_17681()) + 0.5 && !target.method_5809()) {
                target.method_20803(4);
            }
        }

        @Override
        public int cooldown() {
            return 25;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI SPLASH = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            class_1799 stack = entity.method_5998(hand);
            if (AIUtils.isBadPotion(stack)) {
                double dis = entity.method_19538().method_1022(target.method_19538());
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14910, class_3419.field_15254, 0.5f, 0.4f / (entity.method_37908().field_9229.method_43057() * 0.4f + 0.8f));
                if (!entity.method_37908().field_9236) {
                    class_1686 potion = new class_1686(entity.method_37908(), (class_1309)entity);
                    potion.method_16940(stack);
                    potion.method_24919((class_1297)entity, entity.method_36455(), entity.method_36454(), -30.0f, 0.2f + (float)(dis * 0.05), 1.2f);
                    EntityFlags.get((class_1297)potion).isThrownEntity = true;
                    entity.method_37908().method_8649((class_1297)potion);
                }
            }
        }

        @Override
        public int cooldown() {
            return 85;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean applies(class_1799 stack) {
            return AIUtils.isBadPotion(stack);
        }
    };
    public static final ItemAI LINGERINGPOTIONS = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            class_1799 stack = entity.method_5998(hand);
            if (AIUtils.isBadPotion(stack)) {
                double dis = entity.method_19538().method_1022(target.method_19538());
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14910, class_3419.field_15254, 0.5f, 0.4f / (entity.method_37908().field_9229.method_43057() * 0.4f + 0.8f));
                if (!entity.method_37908().field_9236) {
                    class_1686 potion = new class_1686(entity.method_37908(), (class_1309)entity);
                    potion.method_16940(stack);
                    potion.method_24919((class_1297)entity, entity.method_36455(), entity.method_36454(), -30.0f, 0.2f + (float)(dis * 0.05), 1.2f);
                    EntityFlags.get((class_1297)potion).isThrownEntity = true;
                    entity.method_37908().method_8649((class_1297)potion);
                }
            }
        }

        @Override
        public int cooldown() {
            return 85;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean applies(class_1799 stack) {
            return AIUtils.isBadPotion(stack);
        }
    };
    public static final ItemAI CROSSBOWS = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            class_1799 stack = entity.method_5998(hand);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1764) {
                class_1764 crossbow = (class_1764)class_17922;
                class_9278 projectile = (class_9278)stack.method_57379(class_9334.field_49649, (Object)class_9278.field_49298);
                float vel = projectile != null && projectile.method_57438(class_1802.field_8639) ? 1.6f : 3.15f;
                crossbow.method_7777(entity.method_37908(), (class_1309)entity, hand, stack, vel, 13.5f - (float)(entity.method_37908().method_8407().method_5461() * 4), target);
            }
        }

        @Override
        public int cooldown() {
            return 20;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(class_1308 entity, class_1268 hand) {
            return class_1764.method_7775((class_1799)entity.method_5998(hand), (class_1309)entity) + 5;
        }
    };
    public static final ItemAI BOWS = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            AIUtils.attackWithArrows(entity, target, class_1753.method_7722((int)entity.method_6048()));
        }

        @Override
        public int cooldown() {
            return 30;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }
    };
    public static final ItemAI SHIELDS = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
        }

        @Override
        public int cooldown() {
            return 60;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.OFF;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(class_1308 entity, class_1268 hand) {
            return 75;
        }

        @Override
        public boolean isIncompatibleWith(class_1309 entity, class_1799 stack) {
            return stack.method_7909() instanceof class_1764 || entity instanceof class_1547 && stack.method_7909() instanceof class_1753;
        }
    };
    public static final ItemAI SNOWBALL = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (entity.method_37908().field_9229.method_43057() * 0.4f + 0.8f));
            if (!entity.method_37908().field_9236) {
                class_1680 snowball = new class_1680(entity.method_37908(), (class_1309)entity);
                snowball.method_24919((class_1297)entity, entity.method_36455(), entity.method_36454(), 0.0f, 1.5f, 1.0f);
                EntityFlags.get((class_1297)snowball).isThrownEntity = true;
                entity.method_37908().method_8649((class_1297)snowball);
            }
        }

        @Override
        public int cooldown() {
            return 25;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI ENDER_PEARL = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            double dis = entity.method_19538().method_1025(target.method_19538());
            if (dis > 49.0) {
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (entity.method_37908().field_9229.method_43057() * 0.4f + 0.8f));
                if (!entity.method_37908().field_9236) {
                    class_243 v1 = entity.method_19538().method_1020(target.method_19538()).method_1029().method_1021(16.0);
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    if (entity.method_19538().method_1020(target.method_19538()).method_1033() > 16.0) {
                        x = v1.field_1352;
                        y = v1.field_1351;
                        z = v1.field_1350;
                    }
                    class_1684 pearl = new class_1684(entity.method_37908(), (class_1309)entity);
                    AIUtils.setHeadingToPosition((class_1682)pearl, target.method_23317() - x, target.method_23318() - y, target.method_23321() - z, 1.5f, 3.0f);
                    entity.method_37908().method_8649((class_1297)pearl);
                }
            }
        }

        @Override
        public int cooldown() {
            return 35;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI LAVABUCKET = new ItemAI(){

        @Override
        public void attack(class_1308 entity, class_1309 target, class_1268 hand) {
            double dis = entity.method_19538().method_1022(target.method_19538());
            if (dis < 8.0 && AIUtils.tryPlaceLava(entity.method_37908(), class_2338.method_49637((double)(target.method_23317() - 2.0 + (double)entity.method_37908().field_9229.method_43048(4)), (double)(target.method_23318() - 1.0 + (double)entity.method_37908().field_9229.method_43048(2)), (double)(target.method_23321() - 2.0 + (double)entity.method_37908().field_9229.method_43048(4))))) {
                entity.method_6092(new class_1293(class_1294.field_5918, 240, 1, true, false));
            }
        }

        @Override
        public int cooldown() {
            return 80;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
}

