/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai;

import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.ai.util.ItemAITasks;
import io.github.flemmli97.improvedmobs.utils.EntityFlags;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_5134;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUseGoal
extends class_1352 {
    private final class_1308 living;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private ItemAI ai;
    private class_1268 hand;
    private class_1799 stackMain;
    private class_1799 stackOff;

    public ItemUseGoal(class_1308 entity, float maxDistance) {
        this.living = entity;
        float follow = maxDistance;
        if (entity.method_5996(class_5134.field_23717) != null) {
            follow = (float)entity.method_5996(class_5134.field_23717).method_6194();
        }
        maxDistance = Math.min(follow - 3.0f, maxDistance);
        this.maxAttackDistance = maxDistance * maxDistance;
    }

    public boolean method_6264() {
        class_1309 target = this.living.method_5968();
        if (target == null || !target.method_5805() || target.method_59922().method_43048(10) != 0) {
            return false;
        }
        Pair<ItemAI, class_1268> pair = ItemAITasks.getAI(this.living);
        this.ai = (ItemAI)pair.getKey();
        this.hand = (class_1268)pair.getValue();
        return this.ai != null;
    }

    public void method_6269() {
        this.method_6265(this.ai.type() != ItemAI.ItemType.NONSTRAFINGITEM ? EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406) : EnumSet.noneOf(class_1352.class_4134.class));
        this.stackMain = this.living.method_6047();
        this.stackOff = this.living.method_6079();
    }

    public boolean method_6266() {
        class_1309 target = this.living.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.stackMain != this.living.method_6047() || this.stackOff != this.living.method_6079()) {
            Pair<ItemAI, class_1268> pair = ItemAITasks.getAI(this.living);
            this.ai = (ItemAI)pair.getKey();
            this.hand = (class_1268)pair.getValue();
        }
        return this.ai != null;
    }

    public void method_6270() {
        this.seeTime = 0;
        this.attackTime = -1;
        this.living.method_6021();
        this.ai = null;
        this.stackMain = null;
        this.stackOff = null;
        this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
    }

    public void method_6268() {
        if (EntityFlags.get((class_1297)this.living).isShieldDisabled() && this.living.method_5998(this.hand).method_7976() == class_1839.field_8949) {
            return;
        }
        class_1309 target = this.living.method_5968();
        if (target != null) {
            boolean flag = this.living.method_5985().method_6369((class_1297)target);
            if (this.ai.type() == ItemAI.ItemType.STRAFINGITEM) {
                this.moveStrafing(target, flag);
            } else if (this.ai.type() == ItemAI.ItemType.STANDING) {
                this.moveToRange(target, flag);
            }
            if (this.living.method_6115() || !this.ai.useHand()) {
                if (!flag && this.seeTime < -60) {
                    this.living.method_6021();
                    this.ai.onReset(this.living, this.hand);
                } else if (flag) {
                    if (this.ai.useHand()) {
                        int i = this.living.method_6048();
                        if (i >= this.ai.maxUseCount(this.living, this.hand)) {
                            this.living.method_6075();
                            this.ai.attack(this.living, target, this.hand);
                            this.attackTime = this.ai.cooldown();
                        }
                    } else if (--this.attackTime <= 0) {
                        this.ai.attack(this.living, target, this.hand);
                        this.living.method_6075();
                        this.attackTime = this.ai.cooldown();
                    }
                }
            } else if (--this.attackTime < 0 && this.seeTime >= -60) {
                this.living.method_6019(this.hand);
            }
        }
    }

    private void moveStrafing(class_1309 target, boolean canSee) {
        boolean flag1;
        double dist = this.living.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        boolean bl = flag1 = this.seeTime > 0;
        if (canSee != flag1) {
            this.seeTime = 0;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        if (dist <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.living.method_5942().method_6340();
            ++this.strafingTime;
        } else {
            this.living.method_5942().method_6335((class_1297)target, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.living.method_59922().method_43057() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.living.method_59922().method_43057() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (dist > (double)this.maxAttackDistance * 0.75) {
                this.strafingBackwards = false;
            } else if (dist < (double)this.maxAttackDistance * 0.25) {
                this.strafingBackwards = true;
            }
            this.living.method_5962().method_6243(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.living.method_5951((class_1297)target, 30.0f, 30.0f);
        } else {
            this.living.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        }
    }

    private void moveToRange(class_1309 target, boolean canSee) {
        double dist = this.living.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (dist <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.living.method_5942().method_6340();
        } else {
            this.living.method_5942().method_6335((class_1297)target, 1.0);
        }
        this.living.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
    }
}

