/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai;

import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9;

public class BlockBreakGoal
extends class_1352 {
    protected final class_1308 living;
    private class_1309 target;
    private class_2338 markedLoc;
    private class_2338 entityPos;
    private int digTimer;
    private int cooldown = Config.CommonConfig.breakerInitCooldown;
    private final List<class_2338> breakAOE = new ArrayList<class_2338>();
    private int breakIndex;
    private final int digHeight;

    public BlockBreakGoal(class_1308 living) {
        this.living = living;
        int digWidth = living.method_17681() < 1.0f ? 0 : class_3532.method_15386((float)living.method_17681());
        for (int i = this.digHeight = (int)living.method_17682() + 1; i >= 0; --i) {
            this.breakAOE.add(new class_2338(0, i, 0));
        }
        for (int z = digWidth + 1; z >= -digWidth; --z) {
            for (int y = this.digHeight; y >= 0; --y) {
                for (int x = 0; x <= digWidth; ++x) {
                    if (z == 0) continue;
                    this.breakAOE.add(new class_2338(x, y, z));
                    if (x == 0) continue;
                    this.breakAOE.add(new class_2338(-x, y, z));
                }
            }
        }
    }

    public boolean method_6264() {
        this.target = this.living.method_5968();
        if (this.entityPos == null) {
            this.entityPos = this.living.method_24515();
            this.cooldown = Config.CommonConfig.breakerCooldown;
        }
        if (--this.cooldown <= 0) {
            if (!this.entityPos.equals((Object)this.living.method_24515())) {
                this.entityPos = null;
                this.cooldown = Config.CommonConfig.breakerCooldown;
                return false;
            }
            if (this.target != null && (double)this.living.method_5739((class_1297)this.target) > 1.0) {
                class_2338 blockPos = this.getDiggingLocation();
                if (blockPos == null) {
                    return false;
                }
                this.cooldown = Config.CommonConfig.breakerCooldown;
                this.markedLoc = blockPos;
                this.entityPos = this.living.method_24515();
                return true;
            }
        }
        return false;
    }

    public boolean method_6266() {
        return this.target != null && this.target.method_5805() && this.living.method_5805() && this.markedLoc != null && this.nearSameSpace(this.entityPos, this.living.method_24515()) && (double)this.living.method_5739((class_1297)this.target) > 1.0;
    }

    private boolean nearSameSpace(class_2338 pos1, class_2338 pos2) {
        return pos1 != null && pos2 != null && pos1.method_10263() == pos2.method_10263() && pos1.method_10260() == pos2.method_10260() && Math.abs(pos1.method_10264() - pos2.method_10264()) <= 1;
    }

    public void method_6270() {
        this.breakIndex = 0;
        if (this.markedLoc != null) {
            this.living.method_37908().method_8517(this.living.method_5628(), this.markedLoc, -1);
        }
        this.markedLoc = null;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.markedLoc == null || this.living.method_37908().method_8320(this.markedLoc).method_26220((class_1922)this.living.method_37908(), this.markedLoc).method_1110()) {
            this.digTimer = 0;
            return;
        }
        class_2680 state = this.living.method_37908().method_8320(this.markedLoc);
        float str = Utils.getBlockStrength(this.living, state, this.living.method_37908(), this.markedLoc);
        float f = str = str == Float.POSITIVE_INFINITY ? 1.0f : str / (1.0f + str * 6.0f) * ((float)this.digTimer * this.breakSpeedMod() + 1.0f);
        if (str >= 1.0f) {
            boolean canHarvest;
            class_1937 class_19372;
            this.digTimer = 0;
            this.cooldown = (int)((double)this.cooldown * 0.5);
            class_1799 item = this.living.method_6047();
            class_1799 itemOff = this.living.method_6079();
            if (Config.CommonConfig.restoreDelay > 0 && (class_19372 = this.living.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                canHarvest = false;
                BlockRestorationData.get(serverLevel).restore(serverLevel, serverLevel.method_8320(this.markedLoc), this.markedLoc, (class_1297)this.living);
            } else {
                canHarvest = Utils.canHarvest(state, item) || Utils.canHarvest(state, itemOff);
            }
            this.living.method_37908().method_22352(this.markedLoc, canHarvest);
            this.living.method_37908().method_8517(this.living.method_5628(), this.markedLoc, -1);
            this.markedLoc = null;
            if (!this.aboveTarget()) {
                this.living.method_6125(0.0f);
                this.living.method_5942().method_6340();
                this.living.method_5942().method_6334(this.living.method_5942().method_6349((class_1297)this.target, 0), 1.0);
            }
        } else {
            ++this.digTimer;
            if (this.digTimer % 5 == 0) {
                class_2498 sound = CrossPlatformStuff.INSTANCE.blockSound(state, (class_1309)this.living, this.markedLoc);
                this.living.method_37908().method_8465(null, (double)this.markedLoc.method_10263() + 0.5, (double)this.markedLoc.method_10264() + 0.5, (double)this.markedLoc.method_10260() + 0.5, (class_6880)(Config.CommonConfig.useBlockBreakSound ? class_7923.field_41172.method_47983((Object)sound.method_10595()) : class_3417.field_14624), class_3419.field_15245, 2.0f, 0.5f, this.living.method_37908().method_8409().method_43055());
                this.living.method_6104(class_1268.field_5808);
                this.living.method_5988().method_6230((double)this.markedLoc.method_10263(), (double)this.markedLoc.method_10264(), (double)this.markedLoc.method_10260(), 0.0f, 0.0f);
                this.living.method_37908().method_8517(this.living.method_5628(), this.markedLoc, (int)(str * 10.0f) - 1);
            }
        }
    }

    private float breakSpeedMod() {
        float mod = Config.CommonConfig.breakSpeedBaseMod;
        if (Config.CommonConfig.breakSpeedAdd != 0.0f) {
            mod += Config.CommonConfig.breakSpeedAdd * DifficultyFetcher.getDifficulty((class_3218)this.living.method_37908(), this.living.method_19538());
        }
        return mod;
    }

    public class_2338 getDiggingLocation() {
        class_2680 state;
        class_1799 item = this.living.method_6047();
        class_1799 itemOff = this.living.method_6079();
        class_2338 pos = this.living.method_24515();
        if (this.living.method_5968() != null) {
            class_243 target = this.living.method_5968().method_19538();
            if (this.aboveTarget() && Math.abs(target.field_1352 - (double)pos.method_10263()) <= 1.0 && Math.abs(target.field_1350 - (double)pos.method_10260()) <= 1.0) {
                pos = this.living.method_24515().method_10074();
                state = this.living.method_37908().method_8320(pos);
                if (this.canBreak((class_1309)this.living, state, pos, item, itemOff)) {
                    this.breakIndex = 0;
                    return pos;
                }
            }
        }
        class_2470 rot = BlockBreakGoal.getDigDirection(this.living);
        class_2338 offset = this.breakAOE.get(this.breakIndex);
        offset = new class_2338(offset.method_10263(), this.aboveTarget() ? -(offset.method_10264() - this.digHeight) : offset.method_10264(), offset.method_10260());
        pos = pos.method_10081((class_2382)offset.method_10070(rot));
        state = this.living.method_37908().method_8320(pos);
        if (this.canBreak((class_1309)this.living, state, pos, item, itemOff)) {
            this.breakIndex = 0;
            return pos;
        }
        ++this.breakIndex;
        if (this.breakIndex == this.breakAOE.size()) {
            this.breakIndex = 0;
        }
        return null;
    }

    private boolean canBreak(class_1309 entity, class_2680 state, class_2338 pos, class_1799 item, class_1799 itemOff) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (class_1922)entity.method_37908(), (class_1297)entity, class_3726.method_16195((class_1297)entity)) && (Utils.canHarvest(state, item) || Utils.canHarvest(state, itemOff));
    }

    private boolean aboveTarget() {
        return this.target.method_23318() < this.living.method_23318() + 1.1;
    }

    public static class_2470 getDigDirection(class_1308 mob) {
        class_11 path = mob.method_5942().method_6345();
        if (path != null) {
            class_9 point;
            class_9 class_92 = point = path.method_39() < path.method_38() ? path.method_29301() : null;
            if (point != null) {
                class_243 dir = new class_243((double)point.field_40 + 0.5, mob.method_19538().field_1351, (double)point.field_38 + 0.5).method_1020(mob.method_19538());
                if (Math.abs(dir.field_1352) < Math.abs(dir.field_1350)) {
                    if (dir.field_1350 >= 0.0) {
                        return class_2470.field_11467;
                    }
                    return class_2470.field_11464;
                }
                if (dir.field_1352 > 0.0) {
                    return class_2470.field_11465;
                }
                return class_2470.field_11463;
            }
        }
        return switch (mob.method_5735()) {
            case class_2350.field_11035 -> class_2470.field_11464;
            case class_2350.field_11034 -> class_2470.field_11463;
            case class_2350.field_11039 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        };
    }
}

