/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class WaterRemovalScheduler {
    private static final int MAX_TASKS = 120;
    private static final int MAX_TASKS_PER_TICK = 10;
    private final Queue<ScheduledTask> tasks = new ConcurrentLinkedQueue<ScheduledTask>();
    private final Set<Integer> processedStructures = new HashSet<Integer>();
    public final List<class_3218> worlds = new CopyOnWriteArrayList<class_3218>();

    public void addWorld(class_3218 world) {
        if (world.method_27983().equals(class_1937.field_25179)) {
            this.worlds.clear();
            this.worlds.add(world);
        }
    }

    public void removeWorld(class_3218 world) {
        this.worlds.remove(world);
        this.tasks.clear();
        this.processedStructures.clear();
    }

    public void tick() {
        int processedCount = 0;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext() && processedCount < 10) {
            ScheduledTask task = (ScheduledTask)iterator.next();
            task.tick();
            if (task.isExpired()) {
                iterator.remove();
                continue;
            }
            if (!task.isDue() || this.processedStructures.contains(task.getHash())) continue;
            task.run();
            this.processedStructures.add(task.getHash());
            iterator.remove();
            ++processedCount;
        }
        if (this.processedStructures.size() > 120) {
            this.processedStructures.clear();
        }
        if (this.tasks.size() > 1000) {
            this.tasks.clear();
            this.processedStructures.clear();
        }
    }

    public void schedule(class_2338 startPos, class_2338 endPos, int delayTicks) {
        int hash = Objects.hash(startPos, endPos);
        if (this.tasks.size() < 120 && !this.processedStructures.contains(hash)) {
            this.tasks.add(new ScheduledTask(this.worlds, new class_238(new class_243((double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260()), new class_243((double)endPos.method_10263(), (double)endPos.method_10264(), (double)endPos.method_10260())), delayTicks, hash));
        }
    }

    private static class ScheduledTask {
        private static final int MAX_LIFESPAN_TICKS = 200;
        private final List<class_3218> worlds;
        private final class_238 structureBox;
        private final int delayTicks;
        private final int hash;
        private int currentTick;

        public ScheduledTask(List<class_3218> worlds, class_238 structureBox, int delayTicks, int hash) {
            this.worlds = worlds;
            this.structureBox = structureBox;
            this.delayTicks = delayTicks;
            this.hash = hash;
        }

        public int getHash() {
            return this.hash;
        }

        public boolean isDue() {
            return this.currentTick >= this.delayTicks;
        }

        public boolean isExpired() {
            return this.currentTick >= 200;
        }

        public void run() {
            for (class_3218 world : this.worlds) {
                class_2338.method_29715((class_238)this.structureBox).forEach(pos -> {
                    if (!world.method_39999(pos)) {
                        return;
                    }
                    class_2680 state = world.method_8320(pos);
                    if (state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 2);
                        for (class_2350 direction : class_2350.values()) {
                            class_2338 neighborPos = pos.method_10093(direction);
                            class_2680 neighborState = world.method_8320(neighborPos);
                            if (!world.method_39999(neighborPos) || !neighborState.method_27852(class_2246.field_10382)) continue;
                            world.method_8652(neighborPos, class_2246.field_10124.method_9564(), 2);
                        }
                    }
                });
            }
        }

        public void tick() {
            ++this.currentTick;
        }
    }
}

